/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;

public class StringUtils {
    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String ltrim(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            stringBuffer.append(cArray, i, cArray.length - i);
            break;
        }
        return stringBuffer.toString();
    }

    public static String rtrim(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = cArray.length; i > 0; --i) {
            char c = string.charAt(i - 1);
            if (c == ' ') continue;
            stringBuffer.append(cArray, 0, i);
            break;
        }
        return stringBuffer.toString();
    }

    public static String xmlEscaping(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        return string;
    }

    public static String debug(ByteBuffer byteBuffer) {
        int n = (int)Math.ceil((double)byteBuffer.remaining() / 16.0);
        StringBuffer stringBuffer = new StringBuffer(n * 80);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = new byte[Math.min(16, byteBuffer.remaining())];
            byteBuffer.get(byArray);
            stringBuffer.append(NumberUtils.toHexValue(n2));
            stringBuffer.append("h: ");
            for (int j = 0; j < 16; ++j) {
                if (j < byArray.length) {
                    stringBuffer.append(NumberUtils.toHexValue(byArray[j]).toUpperCase());
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(" ");
            }
            stringBuffer.append("; ");
            String string = Charset.decode(byArray);
            char[] cArray = string.toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (Character.isISOControl(cArray[j])) {
                    stringBuffer.append('.');
                    continue;
                }
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append("\r\n");
            n2 += 16;
        }
        return stringBuffer.toString();
    }
}

