/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;

public final class CharsetUtils {
    public static final CharsetUtils SYSTEM = new CharsetUtils(System.getProperty("file.encoding"));
    public static final CharsetUtils UTF8 = new CharsetUtils("UTF-8");
    private Charset charset;
    private ThreadLocal encoderCache = new ThreadLocal();
    private ThreadLocal decoderCache = new ThreadLocal();
    private static ThreadLocal charsetCache = new ThreadLocal();

    private static Object getReference(ThreadLocal threadLocal) {
        SoftReference softReference = (SoftReference)threadLocal.get();
        if (softReference != null) {
            return softReference.get();
        }
        return null;
    }

    private static void setReference(ThreadLocal threadLocal, Object object) {
        threadLocal.set(new SoftReference<Object>(object));
    }

    public CharsetUtils(String string) {
        this.charset = Charset.forName(string);
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    private CharsetEncoder getEncoder() {
        CharsetEncoder charsetEncoder = (CharsetEncoder)CharsetUtils.getReference(this.encoderCache);
        if (charsetEncoder == null) {
            charsetEncoder = this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharsetUtils.setReference(this.encoderCache, charsetEncoder);
        }
        return charsetEncoder;
    }

    private CharsetDecoder getDecoder() {
        CharsetDecoder charsetDecoder = (CharsetDecoder)CharsetUtils.getReference(this.decoderCache);
        if (charsetDecoder == null) {
            charsetDecoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharsetUtils.setReference(this.decoderCache, charsetDecoder);
        }
        return charsetDecoder;
    }

    public ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public ByteBuffer encode(CharBuffer charBuffer) {
        CharsetEncoder charsetEncoder = this.getEncoder();
        int n = 0;
        if (charBuffer.remaining() > 0 && (n = (int)((float)charBuffer.remaining() * charsetEncoder.averageBytesPerChar())) == 0) {
            n = (int)((float)charBuffer.remaining() * charsetEncoder.maxBytesPerChar());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        if (n == 0) {
            return byteBuffer;
        }
        charsetEncoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = charBuffer.hasRemaining() ? charsetEncoder.encode(charBuffer, byteBuffer, true) : charsetEncoder.flush(byteBuffer);
            if (coderResult.isUnderflow()) break;
            if (!coderResult.isOverflow()) continue;
            byteBuffer.flip();
            byteBuffer = ByteBuffer.allocate(n *= 2).put(byteBuffer);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public ByteBuffer[] encode(CharBuffer charBuffer, int n) {
        CharsetEncoder charsetEncoder = this.getEncoder();
        charsetEncoder.reset();
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        while (true) {
            ByteBuffer byteBuffer;
            CoderResult coderResult;
            if ((coderResult = charsetEncoder.encode(charBuffer, byteBuffer = ByteBuffer.allocate(n), true)).isUnderflow()) {
                charsetEncoder.flush(byteBuffer);
                byteBuffer.flip();
                arrayList.add(byteBuffer);
                break;
            }
            if (!coderResult.isOverflow()) continue;
            if (byteBuffer.position() == 0) break;
            byteBuffer.flip();
            arrayList.add(byteBuffer);
        }
        return arrayList.toArray(new ByteBuffer[0]);
    }

    public CharBuffer decode(byte[] byArray) {
        return this.decode(ByteBuffer.wrap(byArray));
    }

    public CharBuffer decode(ByteBuffer byteBuffer) {
        CharsetDecoder charsetDecoder = this.getDecoder();
        int n = 0;
        if (byteBuffer.remaining() > 0 && (n = (int)((float)byteBuffer.remaining() * charsetDecoder.averageCharsPerByte())) == 0) {
            n = (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
        }
        CharBuffer charBuffer = CharBuffer.allocate(n);
        if (n == 0) {
            return charBuffer;
        }
        charsetDecoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = byteBuffer.hasRemaining() ? charsetDecoder.decode(byteBuffer, charBuffer, true) : charsetDecoder.flush(charBuffer);
            if (coderResult.isUnderflow()) break;
            if (!coderResult.isOverflow()) continue;
            charBuffer.flip();
            charBuffer = CharBuffer.allocate(n *= 2).put(charBuffer);
        }
        charBuffer.flip();
        return charBuffer;
    }

    private static CharsetUtils getCharsetUtils(String string) {
        CharsetUtils charsetUtils = (CharsetUtils)CharsetUtils.getReference(charsetCache);
        if (charsetUtils == null || !charsetUtils.charset.name().equals(string)) {
            charsetUtils = new CharsetUtils(string);
            CharsetUtils.setReference(charsetCache, charsetUtils);
        }
        return charsetUtils;
    }

    public static ByteBuffer encode(String string, CharBuffer charBuffer) {
        return CharsetUtils.getCharsetUtils(string).encode(charBuffer);
    }

    public static ByteBuffer encode(String string, String string2) {
        return CharsetUtils.getCharsetUtils(string).encode(string2);
    }

    public static CharBuffer decode(String string, ByteBuffer byteBuffer) {
        return CharsetUtils.getCharsetUtils(string).decode(byteBuffer);
    }
}

