/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemObj
implements SsiItemObj {
    private final MutableTlvChain extraTlvs = TlvTools.createMutableChain();

    public static List<SsiItem> generateSsiItems(Collection<? extends SsiItemObj> itemObjs) {
        List safeItemObjs = DefensiveTools.getSafeNonnullListCopy(itemObjs, (String)"itemObjs");
        ArrayList<SsiItem> items = new ArrayList<SsiItem>(safeItemObjs.size());
        for (SsiItemObj itemObj : safeItemObjs) {
            items.add(itemObj.toSsiItem());
        }
        return DefensiveTools.getUnmodifiable(items);
    }

    protected AbstractItemObj() {
        this(null);
    }

    protected AbstractItemObj(TlvChain extraTlvs) {
        if (extraTlvs != null) {
            this.addExtraTlvs(extraTlvs);
        }
    }

    protected final TlvChain copyExtraTlvs() {
        return TlvTools.getMutableCopy(this.extraTlvs);
    }

    @Override
    public final MutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    protected final void addExtraTlvs(TlvChain extraTlvs) {
        this.extraTlvs.addAll(extraTlvs);
    }

    protected final SsiItem generateItem(String name, int parentid, int subid, int type, TlvChain customTlvs) {
        MutableTlvChain chain = TlvTools.getMutableCopy(this.extraTlvs);
        if (customTlvs != null) {
            chain.replaceAll(customTlvs);
        }
        return new SsiItem(name, parentid, subid, type, ByteBlock.createByteBlock((LiveWritable)chain));
    }
}

