/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractChatMsgIcbm
extends AbstractIcbm {
    private static final int TYPE_IS_PUBLIC = 1;
    private static final int TYPE_MSGBLOCK = 5;
    private final ChatMsg chatMsg;
    private final TlvChain chatTlvs;

    protected AbstractChatMsgIcbm(int command, SnacPacket packet) {
        super(14, command, packet);
        ImmutableTlvChain chain = TlvTools.readChain(this.getChannelData());
        Tlv msgTlv = chain.getLastTlv(5);
        if (msgTlv != null) {
            ByteBlock msgBlock = msgTlv.getData();
            this.chatMsg = ChatMsg.readChatMsg(msgBlock);
        } else {
            this.chatMsg = null;
        }
        this.chatTlvs = chain;
    }

    protected AbstractChatMsgIcbm(int command, long messageId, ChatMsg chatMsg) {
        super(14, command, messageId, 3);
        this.chatMsg = chatMsg;
        this.chatTlvs = null;
    }

    public final ChatMsg getMessage() {
        return this.chatMsg;
    }

    protected final TlvChain getChatTlvs() {
        return this.chatTlvs;
    }

    protected void writeChannelData(OutputStream out) throws IOException {
        if (this.chatMsg != null) {
            ByteBlock msgBlock = ByteBlock.createByteBlock((LiveWritable)this.chatMsg);
            new Tlv(5, (Writable)msgBlock).write(out);
        }
        this.writeChatTlvs(out);
    }

    protected abstract void writeChatTlvs(OutputStream var1) throws IOException;

    public String toString() {
        return "AbstractChatMsgIcbm: <" + super.toString() + ">, " + "chatMsg=" + this.chatMsg;
    }
}

