/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.snaccmd.buddy.BuddyCommand;
import net.kano.joscar.snaccmd.chat.ChatCommand;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icon.IconCommand;
import net.kano.joscar.snaccmd.invite.InviteCommand;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.snaccmd.popup.PopupCommand;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.snaccmd.search.SearchCommand;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnacFamilyInfoFactory {
    private static final Map<Integer, SnacFamilyInfo> families = new HashMap<Integer, SnacFamilyInfo>();

    private SnacFamilyInfoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SnacFamilyInfo> getDefaultFamilyInfos(int[] supportedFamilies) {
        DefensiveTools.checkNull((Object)supportedFamilies, (String)"supportedFamilies");
        LinkedList<SnacFamilyInfo> list = new LinkedList<SnacFamilyInfo>();
        Map<Integer, SnacFamilyInfo> map = families;
        synchronized (map) {
            for (int supportedFamily : supportedFamilies) {
                SnacFamilyInfo info = SnacFamilyInfoFactory.getFamily(supportedFamily);
                if (info == null) continue;
                list.add(info);
            }
        }
        return DefensiveTools.getUnmodifiable(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SnacFamilyInfo getFamily(int family) {
        Map<Integer, SnacFamilyInfo> map = families;
        synchronized (map) {
            return families.get(family);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SnacFamilyInfo[] infos = new SnacFamilyInfo[]{AuthCommand.FAMILY_INFO, ConnCommand.FAMILY_INFO, LocCommand.FAMILY_INFO, BuddyCommand.FAMILY_INFO, PopupCommand.FAMILY_INFO, AcctCommand.FAMILY_INFO, RoomCommand.FAMILY_INFO, ChatCommand.FAMILY_INFO, InviteCommand.FAMILY_INFO, SearchCommand.FAMILY_INFO, IconCommand.FAMILY_INFO, SsiCommand.FAMILY_INFO, IcbmCommand.FAMILY_INFO};
        Map<Integer, SnacFamilyInfo> map = families;
        synchronized (map) {
            for (SnacFamilyInfo sfi : infos) {
                families.put(sfi.getFamily(), sfi);
            }
        }
    }
}

