/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;

public final class ImEncodedString {
    private final ImEncodingParams encoding;
    private final byte[] bytes;
    private final String string;

    public static String readImEncodedString(ImEncodingParams encoding, ByteBlock block) {
        DefensiveTools.checkNull((Object)encoding, (String)"encoding");
        DefensiveTools.checkNull((Object)block, (String)"block");
        return OscarTools.getString(block, encoding.toCharsetName());
    }

    public static ImEncodedString encodeString(String string) {
        DefensiveTools.checkNull((Object)string, (String)"string");
        return new ImEncodedString(string);
    }

    private ImEncodedString(String string) {
        EncodedStringInfo encInfo = MinimalEncoder.encodeMinimally(string);
        this.bytes = encInfo.getData();
        this.string = string;
        this.encoding = encInfo.getImEncoding();
    }

    public final ImEncodingParams getEncoding() {
        return this.encoding;
    }

    public final byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public final String getString() {
        return this.string;
    }

    public String toString() {
        return "ImEncodedString: encoding=<" + this.encoding + ">, string=" + this.string;
    }
}

