/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;

class ChannelBuffer
extends Buffer {
    private byte[] asBytes = null;
    private int bufLength = 0;
    private ByteBuffer directBuffer;
    private boolean dirty = true;

    ChannelBuffer(byte[] buf) {
        this.directBuffer = ByteBuffer.wrap(buf);
        this.setBufLength(buf.length);
    }

    ChannelBuffer(int size, boolean direct) {
        this.directBuffer = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        this.setBufLength(size);
        this.directBuffer.position(4);
    }

    private byte[] bufferToArray() {
        if (!this.dirty) {
            return this.asBytes;
        }
        if (this.directBuffer.hasArray()) {
            this.asBytes = this.directBuffer.array();
            this.dirty = false;
            return this.asBytes;
        }
        int bufferLength = this.directBuffer.limit();
        this.asBytes = new byte[bufferLength];
        int oldPosition = this.getPosition();
        this.directBuffer.position(0);
        this.directBuffer.get(this.asBytes, 0, bufferLength);
        this.directBuffer.position(oldPosition);
        this.dirty = false;
        return this.asBytes;
    }

    final void clear() {
        this.directBuffer.position(4);
    }

    final void ensureCapacity(int additionalData) throws SQLException {
        int bufferCapacity = this.directBuffer.capacity();
        int currentPosition = this.directBuffer.position();
        if (currentPosition + additionalData > this.getBufLength()) {
            if (currentPosition + additionalData < bufferCapacity) {
                this.setBufLength(currentPosition + additionalData);
            } else {
                int newLength = (int)((double)bufferCapacity * 1.25);
                if (newLength < 4096) {
                    newLength = 4096;
                }
                if (newLength < bufferCapacity + additionalData) {
                    newLength = bufferCapacity + (int)((double)additionalData * 1.25);
                }
                if (newLength < bufferCapacity) {
                    newLength = bufferCapacity + additionalData;
                }
                ByteBuffer largerBuffer = ByteBuffer.allocateDirect(newLength);
                this.directBuffer.position(0);
                largerBuffer.put(this.directBuffer);
                this.directBuffer = largerBuffer;
                this.directBuffer.position(currentPosition);
                bufferCapacity = this.directBuffer.capacity();
                this.setBufLength(bufferCapacity);
            }
        }
    }

    public int fastSkipLenString() {
        long len = this.readFieldLength();
        this.directBuffer.position((int)((long)this.directBuffer.position() + len));
        return (int)len;
    }

    int getBufLength() {
        return this.directBuffer.limit();
    }

    public byte[] getByteBuffer() {
        return this.bufferToArray();
    }

    final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        byte[] nioByteBuffer = this.bufferToArray();
        System.arraycopy(nioByteBuffer, this.directBuffer.position(), b, 0, len);
        this.directBuffer.position(this.directBuffer.position() + len);
        return b;
    }

    byte[] getBytes(int offset, int len) {
        byte[] b = new byte[len];
        byte[] nioByteBuffer = this.bufferToArray();
        System.arraycopy(nioByteBuffer, offset, b, 0, len);
        this.directBuffer.position(offset + len);
        return b;
    }

    int getCapacity() {
        return this.directBuffer.capacity();
    }

    public ByteBuffer getNioBuffer() {
        return this.directBuffer;
    }

    public int getPosition() {
        return this.directBuffer.position();
    }

    final boolean isLastDataPacket() {
        boolean hasMarker = (this.directBuffer.get(0) & 0xFF) == 254;
        return hasMarker && this.bufLength < 9;
    }

    final long newReadLength() {
        int sw = this.directBuffer.get(this.directBuffer.position()) & 0xFF;
        this.directBuffer.position(this.directBuffer.position() + 1);
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final byte readByte() {
        byte b = this.directBuffer.get();
        return b;
    }

    final byte readByte(int readAt) {
        return this.directBuffer.get(readAt);
    }

    final long readFieldLength() {
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final int readInt() {
        return this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8;
    }

    final int readIntAsLong() {
        int i = this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8 | (this.directBuffer.get() & 0xFF) << 16 | (this.directBuffer.get() & 0xFF) << 24;
        return i;
    }

    final byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == -1L) {
            return null;
        }
        if (len == 0L) {
            return Constants.EMPTY_BYTE_ARRAY;
        }
        this.directBuffer.position(this.directBuffer.position() + offset);
        return this.getBytes((int)len);
    }

    final long readLength() {
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final long readLong() {
        long l = (long)this.directBuffer.get() & 0xFFL | ((long)this.directBuffer.get() & 0xFFL) << 8 | ((long)this.directBuffer.get() & 0xFFL) << 16 | ((long)this.directBuffer.get() & 0xFFL) << 24;
        return l;
    }

    final int readLongInt() {
        int i = this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8 | (this.directBuffer.get() & 0xFF) << 16;
        return i;
    }

    final long readLongLong() {
        long l = (long)(this.directBuffer.get() & 0xFF) | (long)(this.directBuffer.get() & 0xFF) << 8 | (long)(this.directBuffer.get() & 0xFF) << 16 | (long)(this.directBuffer.get() & 0xFF) << 24 | (long)(this.directBuffer.get() & 0xFF) << 32 | (long)(this.directBuffer.get() & 0xFF) << 40 | (long)(this.directBuffer.get() & 0xFF) << 48 | (long)(this.directBuffer.get() & 0xFF) << 56;
        return l;
    }

    final int readnBytes() {
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 1: {
                return this.directBuffer.get() & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final String readString() {
        int len = 0;
        int maxLen = this.getBufLength();
        int oldPosition = this.getPosition();
        while (this.getPosition() < maxLen && this.directBuffer.get() != 0) {
            ++len;
        }
        this.setPosition(oldPosition);
        String s = new String(this.bufferToArray(), this.getPosition(), len);
        this.directBuffer.position(this.getPosition() + len + 1);
        return s;
    }

    final String readString(String encoding) throws SQLException {
        String string;
        int len = 0;
        int maxLen = this.getBufLength();
        while (this.getPosition() < maxLen && this.directBuffer.get() != 0) {
            ++len;
        }
        try {
            string = new String(this.bufferToArray(), this.getPosition(), len, encoding);
            Object var6_6 = null;
            this.directBuffer.position(this.getPosition() + len + 1);
        }
        catch (UnsupportedEncodingException uEE) {
            try {
                throw new SQLException(Messages.getString("ChannelBuffer.0") + encoding + Messages.getString("ChannelBuffer.1"), "S1009");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.directBuffer.position(this.getPosition() + len + 1);
                throw throwable;
            }
        }
        return string;
    }

    void setBufLength(int bufLengthToSet) {
        this.bufLength = bufLengthToSet;
        this.directBuffer.limit(this.bufLength);
        this.dirty = true;
    }

    public void setByteBuffer(byte[] byteBuffer) {
        this.directBuffer = ByteBuffer.wrap(byteBuffer);
    }

    public void setPosition(int position) {
        this.directBuffer.position(position);
    }

    final void writeByte(byte b) throws SQLException {
        this.ensureCapacity(1);
        this.directBuffer.put(b);
        this.dirty = true;
    }

    final void writeBytesNoNull(byte[] bytes) throws SQLException {
        int len = bytes.length;
        this.ensureCapacity(len);
        this.directBuffer.put(bytes, 0, len);
        this.dirty = true;
    }

    final void writeBytesNoNull(byte[] bytes, int offset, int length) throws SQLException {
        this.ensureCapacity(length);
        this.directBuffer.put(bytes, offset, length);
        this.dirty = true;
    }

    final void writeDouble(double d) throws SQLException {
        long l = Double.doubleToLongBits(d);
        this.writeLongLong(l);
        this.dirty = true;
    }

    final void writeFieldLength(long length) throws SQLException {
        if (length < 251L) {
            this.writeByte((byte)length);
        } else if (length < 65536L) {
            this.ensureCapacity(3);
            this.writeByte((byte)-4);
            this.writeInt((int)length);
        } else if (length < 0x1000000L) {
            this.ensureCapacity(4);
            this.writeByte((byte)-3);
            this.writeLongInt((int)length);
        } else {
            this.ensureCapacity(9);
            this.writeByte((byte)-2);
            this.writeLongLong(length);
        }
    }

    final void writeFloat(float f) throws SQLException {
        this.ensureCapacity(4);
        int i = Float.floatToIntBits(f);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.dirty = true;
    }

    final void writeInt(int i) throws SQLException {
        this.ensureCapacity(2);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.dirty = true;
    }

    final void writeLenBytes(byte[] b) throws SQLException {
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        this.directBuffer.put(b, 0, len);
        this.dirty = true;
    }

    final void writeLenString(String s, String encoding, String serverEncoding, SingleByteCharsetConverter converter, boolean parserKnowsUnicode) throws UnsupportedEncodingException, SQLException {
        byte[] b = null;
        b = converter != null ? converter.toBytes(s) : StringUtils.getBytes(s, encoding, serverEncoding, parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        this.directBuffer.put(b, 0, len);
        this.dirty = true;
    }

    final void writeLong(long i) throws SQLException {
        this.ensureCapacity(4);
        this.directBuffer.put((byte)(i & 0xFFL));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.dirty = true;
    }

    final void writeLongInt(int i) throws SQLException {
        this.ensureCapacity(3);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.dirty = true;
    }

    final void writeLongLong(long i) throws SQLException {
        this.ensureCapacity(8);
        this.directBuffer.put((byte)(i & 0xFFL));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.directBuffer.put((byte)(i >>> 32));
        this.directBuffer.put((byte)(i >>> 40));
        this.directBuffer.put((byte)(i >>> 48));
        this.directBuffer.put((byte)(i >>> 56));
        this.dirty = true;
    }

    final void writeString(String s) throws SQLException {
        this.ensureCapacity(s.length() * 2 + 1);
        this.writeStringNoNull(s);
        this.directBuffer.put((byte)0);
        this.dirty = true;
    }

    final void writeStringNoNull(String s) throws SQLException {
        int len = s.length();
        this.ensureCapacity(len * 2);
        this.directBuffer.put(s.getBytes(), 0, len);
        this.dirty = true;
    }

    final void writeStringNoNull(String s, String encoding, String serverEncoding, boolean parserKnowsUnicode) throws UnsupportedEncodingException, SQLException {
        byte[] b = StringUtils.getBytes(s, encoding, serverEncoding, parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len);
        this.directBuffer.put(b, 0, len);
        this.dirty = true;
    }
}

