/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipOutputStream
extends FilterOutputStream {
    private static final byte[] ZERO = new byte[2];
    private static final byte[] LZERO = new byte[4];
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    protected static final ZipLong LFH_SIG = new ZipLong(67324752L);
    protected static final ZipLong DD_SIG = new ZipLong(134695760L);
    protected static final ZipLong CFH_SIG = new ZipLong(33639248L);
    protected static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong DOS_TIME_MIN = new ZipLong(8448L);
    private ZipEntry entry;
    private String comment;
    private int level;
    private boolean hasCompressionLevelChanged;
    private int method;
    private Vector entries;
    private CRC32 crc;
    private long written;
    private long dataStart;
    private long localDataStart;
    private ZipLong cdOffset;
    private ZipLong cdLength;
    private Hashtable offsets;
    private String encoding;
    protected Deflater def;
    protected byte[] buf;
    private RandomAccessFile raf;

    public boolean isSeekable() {
        boolean bl = false;
        if (this.raf != null) {
            bl = true;
        }
        return bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = new ZipLong(this.written);
        int n = 0;
        while (n < this.entries.size()) {
            this.writeCentralFileHeader((ZipEntry)this.entries.elementAt(n));
            ++n;
        }
        this.cdLength = new ZipLong(this.written - this.cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.removeAllElements();
    }

    public void closeEntry() throws IOException {
        long l;
        if (this.entry == null) {
            return;
        }
        long l2 = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(this.def.getTotalIn());
            this.entry.setComprSize(this.def.getTotalOut());
            this.entry.setCrc(l2);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else if (this.raf == null) {
            if (this.entry.getCrc() != l2) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(l2));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        } else {
            l = this.written - this.dataStart;
            this.entry.setSize(l);
            this.entry.setComprSize(l);
            this.entry.setCrc(l2);
        }
        if (this.raf != null) {
            l = this.raf.getFilePointer();
            this.raf.seek(this.localDataStart);
            this.writeOut(new ZipLong(this.entry.getCrc()).getBytes());
            this.writeOut(new ZipLong(this.entry.getCompressedSize()).getBytes());
            this.writeOut(new ZipLong(this.entry.getSize()).getBytes());
            this.raf.seek(l);
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        this.entry = zipEntry;
        this.entries.addElement(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == (long)-1) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == (long)-1) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == (long)-1) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setComprSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n) {
        boolean bl = false;
        if (this.level != n) {
            bl = true;
        }
        this.hasCompressionLevelChanged = bl;
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry.getMethod() == 8) {
            if (n2 > 0 && !this.def.finished()) {
                this.def.setInput(byArray, n, n2);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
            }
        } else {
            this.writeOut(byArray, n, n2);
            this.written += (long)n2;
        }
        this.crc.update(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.writeOut(this.buf, 0, n);
        }
    }

    protected void writeLocalFileHeader(ZipEntry zipEntry) throws IOException {
        this.offsets.put(zipEntry, new ZipLong(this.written));
        this.writeOut(LFH_SIG.getBytes());
        this.written += (long)4;
        if (zipEntry.getMethod() == 8 && this.raf == null) {
            this.writeOut(new ZipShort(20).getBytes());
            this.writeOut(new ZipShort(8).getBytes());
        } else {
            this.writeOut(new ZipShort(10).getBytes());
            this.writeOut(ZERO);
        }
        this.written += (long)4;
        this.writeOut(new ZipShort(zipEntry.getMethod()).getBytes());
        this.written += (long)2;
        this.writeOut(ZipOutputStream.toDosTime(new Date(zipEntry.getTime())).getBytes());
        this.written += (long)4;
        this.localDataStart = this.written;
        if (zipEntry.getMethod() == 8 || this.raf != null) {
            this.writeOut(LZERO);
            this.writeOut(LZERO);
            this.writeOut(LZERO);
        } else {
            this.writeOut(new ZipLong(zipEntry.getCrc()).getBytes());
            this.writeOut(new ZipLong(zipEntry.getSize()).getBytes());
            this.writeOut(new ZipLong(zipEntry.getSize()).getBytes());
        }
        this.written += 12L;
        byte[] byArray = this.getBytes(zipEntry.getName());
        this.writeOut(new ZipShort(byArray.length).getBytes());
        this.written += (long)2;
        byte[] byArray2 = zipEntry.getLocalFileDataExtra();
        this.writeOut(new ZipShort(byArray2.length).getBytes());
        this.written += (long)2;
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byArray2);
        this.written += (long)byArray2.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG.getBytes());
        this.writeOut(new ZipLong(this.entry.getCrc()).getBytes());
        this.writeOut(new ZipLong(this.entry.getCompressedSize()).getBytes());
        this.writeOut(new ZipLong(this.entry.getSize()).getBytes());
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        this.writeOut(CFH_SIG.getBytes());
        this.written += (long)4;
        this.writeOut(new ZipShort(zipEntry.getPlatform() << 8 | 0x14).getBytes());
        this.written += (long)2;
        if (zipEntry.getMethod() == 8 && this.raf == null) {
            this.writeOut(new ZipShort(20).getBytes());
            this.writeOut(new ZipShort(8).getBytes());
        } else {
            this.writeOut(new ZipShort(10).getBytes());
            this.writeOut(ZERO);
        }
        this.written += (long)4;
        this.writeOut(new ZipShort(zipEntry.getMethod()).getBytes());
        this.written += (long)2;
        this.writeOut(ZipOutputStream.toDosTime(new Date(zipEntry.getTime())).getBytes());
        this.written += (long)4;
        this.writeOut(new ZipLong(zipEntry.getCrc()).getBytes());
        this.writeOut(new ZipLong(zipEntry.getCompressedSize()).getBytes());
        this.writeOut(new ZipLong(zipEntry.getSize()).getBytes());
        this.written += 12L;
        byte[] byArray = this.getBytes(zipEntry.getName());
        this.writeOut(new ZipShort(byArray.length).getBytes());
        this.written += (long)2;
        byte[] byArray2 = zipEntry.getCentralDirectoryExtra();
        this.writeOut(new ZipShort(byArray2.length).getBytes());
        this.written += (long)2;
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = this.getBytes(string);
        this.writeOut(new ZipShort(byArray3.length).getBytes());
        this.written += (long)2;
        this.writeOut(ZERO);
        this.written += (long)2;
        this.writeOut(new ZipShort(zipEntry.getInternalAttributes()).getBytes());
        this.written += (long)2;
        this.writeOut(new ZipLong(zipEntry.getExternalAttributes()).getBytes());
        this.written += (long)4;
        this.writeOut(((ZipLong)this.offsets.get(zipEntry)).getBytes());
        this.written += (long)4;
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byArray2);
        this.written += (long)byArray2.length;
        this.writeOut(byArray3);
        this.written += (long)byArray3.length;
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeOut(EOCD_SIG.getBytes());
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        byte[] byArray = new ZipShort(this.entries.size()).getBytes();
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(this.cdLength.getBytes());
        this.writeOut(this.cdOffset.getBytes());
        byte[] byArray2 = this.getBytes(this.comment);
        this.writeOut(new ZipShort(byArray2.length).getBytes());
        this.writeOut(byArray2);
    }

    protected static ZipLong toDosTime(Date date) {
        int n = date.getYear() + 1900;
        int n2 = date.getMonth() + 1;
        if (n < 1980) {
            return DOS_TIME_MIN;
        }
        long l = n - 1980 << 25 | n2 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)((l & 0xFF00L) >> 8), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF000000L) >> 24)};
        return new ZipLong(byArray);
    }

    protected byte[] getBytes(String string) throws ZipException {
        if (this.encoding == null) {
            return string.getBytes();
        }
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException.getMessage());
        }
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    private final /* synthetic */ void this() {
        this.comment = "";
        this.level = -1;
        this.hasCompressionLevelChanged = false;
        this.method = 8;
        this.entries = new Vector();
        this.crc = new CRC32();
        this.written = 0L;
        this.dataStart = 0L;
        this.localDataStart = 0L;
        this.cdOffset = new ZipLong(0L);
        this.cdLength = new ZipLong(0L);
        this.offsets = new Hashtable();
        this.encoding = null;
        this.def = new Deflater(-1, true);
        this.buf = new byte[512];
        this.raf = null;
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.this();
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        this.this();
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
        }
        catch (IOException iOException) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException2) {}
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }
}

