/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnixStat;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AsiExtraField
implements ZipExtraField,
UnixStat,
Cloneable {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private int mode;
    private int uid;
    private int gid;
    private String link;
    private boolean dirFlag;
    private CRC32 crc;

    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        byte[] byArray = new byte[this.getLocalFileDataLength().getValue() - 4];
        System.arraycopy(new ZipShort(this.getMode()).getBytes(), 0, byArray, 0, 2);
        byte[] byArray2 = this.getLinkedFile().getBytes();
        System.arraycopy(new ZipLong(byArray2.length).getBytes(), 0, byArray, 2, 4);
        System.arraycopy(new ZipShort(this.getUserId()).getBytes(), 0, byArray, 6, 2);
        System.arraycopy(new ZipShort(this.getGroupId()).getBytes(), 0, byArray, 8, 2);
        System.arraycopy(byArray2, 0, byArray, 10, byArray2.length);
        this.crc.reset();
        this.crc.update(byArray);
        long l = this.crc.getValue();
        byte[] byArray3 = new byte[byArray.length + 4];
        System.arraycopy(new ZipLong(l).getBytes(), 0, byArray3, 0, 4);
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        return byArray3;
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void setUserId(int n) {
        this.uid = n;
    }

    public int getUserId() {
        return this.uid;
    }

    public void setGroupId(int n) {
        this.gid = n;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setLinkedFile(String string) {
        this.link = string;
        this.mode = this.getMode(this.mode);
    }

    public String getLinkedFile() {
        return this.link;
    }

    public boolean isLink() {
        boolean bl = false;
        if (this.getLinkedFile().length() != 0) {
            bl = true;
        }
        return bl;
    }

    public void setMode(int n) {
        this.mode = this.getMode(n);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDirectory(boolean bl) {
        this.dirFlag = bl;
        this.mode = this.getMode(this.mode);
    }

    public boolean isDirectory() {
        boolean bl = false;
        if (this.dirFlag && !this.isLink()) {
            bl = true;
        }
        return bl;
    }

    public void parseFromLocalFileData(byte[] byArray, int n, int n2) throws ZipException {
        long l = new ZipLong(byArray, n).getValue();
        byte[] byArray2 = new byte[n2 - 4];
        System.arraycopy(byArray, n + 4, byArray2, 0, n2 - 4);
        this.crc.reset();
        this.crc.update(byArray2);
        long l2 = this.crc.getValue();
        if (l != l2) {
            throw new ZipException("bad CRC checksum " + Long.toHexString(l) + " instead of " + Long.toHexString(l2));
        }
        int n3 = new ZipShort(byArray2, 0).getValue();
        byte[] byArray3 = new byte[(int)new ZipLong(byArray2, 2).getValue()];
        this.uid = new ZipShort(byArray2, 6).getValue();
        this.gid = new ZipShort(byArray2, 8).getValue();
        if (byArray3.length == 0) {
            this.link = "";
        } else {
            System.arraycopy(byArray2, 10, byArray3, 0, byArray3.length);
            this.link = new String(byArray3);
        }
        boolean bl = false;
        if ((n3 & 0x4000) != 0) {
            bl = true;
        }
        this.setDirectory(bl);
        this.setMode(n3);
    }

    protected int getMode(int n) {
        int n2 = 32768;
        if (this.isLink()) {
            n2 = 40960;
        } else if (this.isDirectory()) {
            n2 = 16384;
        }
        return n2 | n & 0xFFF;
    }

    private final /* synthetic */ void this() {
        this.mode = 0;
        this.uid = 0;
        this.gid = 0;
        this.link = "";
        this.dirFlag = false;
        this.crc = new CRC32();
    }

    public AsiExtraField() {
        this.this();
    }
}

