/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Delete
extends MatchingTask {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    protected File file;
    protected File dir;
    protected Vector filesets;
    protected boolean usedMatchingTask;
    protected boolean includeEmpty;
    private int verbosity;
    private boolean quiet;
    private boolean failonerror;
    private boolean deleteOnExit;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
        if (bl) {
            this.failonerror = false;
        }
    }

    public void setFailOnError(boolean bl) {
        this.failonerror = bl;
    }

    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        this.usedMatchingTask = true;
        return super.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        this.usedMatchingTask = true;
        return super.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    public void setIncludes(String string) {
        this.usedMatchingTask = true;
        super.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.usedMatchingTask = true;
        super.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(bl);
    }

    public void setIncludesfile(File file) {
        this.usedMatchingTask = true;
        super.setIncludesfile(file);
    }

    public void setExcludesfile(File file) {
        this.usedMatchingTask = true;
        super.setExcludesfile(file);
    }

    public void setCaseSensitive(boolean bl) {
        this.usedMatchingTask = true;
        super.setCaseSensitive(bl);
    }

    public void setFollowSymlinks(boolean bl) {
        this.usedMatchingTask = true;
        super.setFollowSymlinks(bl);
    }

    public void addSelector(SelectSelector selectSelector) {
        this.usedMatchingTask = true;
        super.addSelector(selectSelector);
    }

    public void addAnd(AndSelector andSelector) {
        this.usedMatchingTask = true;
        super.addAnd(andSelector);
    }

    public void addOr(OrSelector orSelector) {
        this.usedMatchingTask = true;
        super.addOr(orSelector);
    }

    public void addNot(NotSelector notSelector) {
        this.usedMatchingTask = true;
        super.addNot(notSelector);
    }

    public void addNone(NoneSelector noneSelector) {
        this.usedMatchingTask = true;
        super.addNone(noneSelector);
    }

    public void addMajority(MajoritySelector majoritySelector) {
        this.usedMatchingTask = true;
        super.addMajority(majoritySelector);
    }

    public void addDate(DateSelector dateSelector) {
        this.usedMatchingTask = true;
        super.addDate(dateSelector);
    }

    public void addSize(SizeSelector sizeSelector) {
        this.usedMatchingTask = true;
        super.addSize(sizeSelector);
    }

    public void addFilename(FilenameSelector filenameSelector) {
        this.usedMatchingTask = true;
        super.addFilename(filenameSelector);
    }

    public void addCustom(ExtendSelector extendSelector) {
        this.usedMatchingTask = true;
        super.addCustom(extendSelector);
    }

    public void addContains(ContainsSelector containsSelector) {
        this.usedMatchingTask = true;
        super.addContains(containsSelector);
    }

    public void addPresent(PresentSelector presentSelector) {
        this.usedMatchingTask = true;
        super.addPresent(presentSelector);
    }

    public void addDepth(DepthSelector depthSelector) {
        this.usedMatchingTask = true;
        super.addDepth(depthSelector);
    }

    public void addDepend(DependSelector dependSelector) {
        this.usedMatchingTask = true;
        super.addDepend(dependSelector);
    }

    public void addContainsRegexp(ContainsRegexpSelector containsRegexpSelector) {
        this.usedMatchingTask = true;
        super.addContainsRegexp(containsRegexpSelector);
    }

    public void addModified(ModifiedSelector modifiedSelector) {
        this.usedMatchingTask = true;
        super.addModified(modifiedSelector);
    }

    public void add(FileSelector fileSelector) {
        this.usedMatchingTask = true;
        super.add(fileSelector);
    }

    public void execute() throws BuildException {
        String[] stringArray;
        String[] stringArray2;
        if (this.usedMatchingTask) {
            this.log("DEPRECATED - Use of the implicit FileSet is deprecated.  Use a nested fileset element instead.");
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.quiet && this.failonerror) {
            throw new BuildException("quiet and failonerror cannot both be set to true", this.getLocation());
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " cannot be removed using the file attribute.  Use dir instead.");
                } else {
                    this.log("Deleting: " + this.file.getAbsolutePath());
                    if (!this.delete(this.file)) {
                        String string = "Unable to delete file " + this.file.getAbsolutePath();
                        if (this.failonerror) {
                            throw new BuildException(string);
                        }
                        this.log(string, this.quiet ? 3 : 1);
                    }
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to delete.", 3);
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            if (this.verbosity == 3) {
                this.log("Deleting directory " + this.dir.getAbsolutePath());
            }
            this.removeDir(this.dir);
        }
        int n = 0;
        while (n < this.filesets.size()) {
            stringArray2 = (String[])this.filesets.elementAt(n);
            try {
                stringArray = stringArray2.getDirectoryScanner(this.getProject());
                String[] stringArray3 = stringArray.getIncludedFiles();
                String[] stringArray4 = stringArray.getIncludedDirectories();
                this.removeFiles(stringArray2.getDir(this.getProject()), stringArray3, stringArray4);
            }
            catch (BuildException buildException) {
                if (this.failonerror) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), this.quiet ? 3 : 1);
            }
            ++n;
        }
        if (this.usedMatchingTask && this.dir != null) {
            try {
                DirectoryScanner directoryScanner = super.getDirectoryScanner(this.dir);
                stringArray2 = directoryScanner.getIncludedFiles();
                stringArray = directoryScanner.getIncludedDirectories();
                this.removeFiles(this.dir, stringArray2, stringArray);
            }
            catch (BuildException buildException) {
                if (this.failonerror) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), this.quiet ? 3 : 1);
            }
        }
    }

    private final boolean delete(File file) {
        if (!file.delete()) {
            if (Os.isFamily("windows")) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            if (!file.delete()) {
                if (this.deleteOnExit) {
                    int n = this.quiet + 2;
                    this.log("Failed to delete " + file + ", calling deleteOnExit. This attempts to delete the file when the ant jvm has exited and might not succeed.", n);
                    file.deleteOnExit();
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void removeDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                this.removeDir(file2);
            } else {
                this.log("Deleting " + file2.getAbsolutePath(), this.verbosity);
                if (!this.delete(file2)) {
                    String string2 = "Unable to delete file " + file2.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException(string2);
                    }
                    this.log(string2, this.quiet ? 3 : 1);
                }
            }
            ++n;
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!this.delete(file)) {
            String string = "Unable to delete directory " + this.dir.getAbsolutePath();
            if (this.failonerror) {
                throw new BuildException(string);
            }
            this.log(string, this.quiet ? 3 : 1);
        }
    }

    protected void removeFiles(File file, String[] stringArray, String[] stringArray2) {
        Object object;
        int n;
        if (stringArray.length > 0) {
            this.log("Deleting " + stringArray.length + " files from " + file.getAbsolutePath());
            n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                this.log("Deleting " + file2.getAbsolutePath(), this.verbosity);
                if (!this.delete(file2)) {
                    object = "Unable to delete file " + file2.getAbsolutePath();
                    if (this.failonerror) {
                        throw new BuildException((String)object);
                    }
                    this.log((String)object, this.quiet ? 3 : 1);
                }
                ++n;
            }
        }
        if (stringArray2.length > 0 && this.includeEmpty) {
            n = 0;
            int n2 = stringArray2.length - 1;
            while (n2 >= 0) {
                object = new File(file, stringArray2[n2]);
                String[] stringArray3 = ((File)object).list();
                if (stringArray3 == null || stringArray3.length == 0) {
                    this.log("Deleting " + ((File)object).getAbsolutePath(), this.verbosity);
                    if (!this.delete((File)object)) {
                        String string = "Unable to delete directory " + ((File)object).getAbsolutePath();
                        if (this.failonerror) {
                            throw new BuildException(string);
                        }
                        this.log(string, this.quiet ? 3 : 1);
                    } else {
                        ++n;
                    }
                }
                --n2;
            }
            if (n > 0) {
                this.log("Deleted " + n + " director" + (n == 1 ? "y" : "ies") + " from " + file.getAbsolutePath());
            }
        }
    }

    private final /* synthetic */ void this() {
        this.file = null;
        this.dir = null;
        this.filesets = new Vector();
        this.usedMatchingTask = false;
        this.includeEmpty = false;
        this.verbosity = 3;
        this.quiet = false;
        this.failonerror = true;
        this.deleteOnExit = false;
    }

    public Delete() {
        this.this();
    }
}

