/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.TargetInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.exception.ExtCertPathValidatorException;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.CertStatus;
import org.bouncycastle.jce.provider.ReasonsMask;
import org.bouncycastle.util.Selector;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import org.bouncycastle.x509.ExtendedPKIXParameters;
import org.bouncycastle.x509.PKIXAttrCertChecker;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;

class RFC3281CertPathUtilities
extends CertPathValidatorUtilities {
    private static final String TARGET_INFORMATION = X509Extensions.TargetInformation.getId();
    private static final String NO_REV_AVAIL = X509Extensions.NoRevAvail.getId();
    private static final String AUTHORITY_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();

    RFC3281CertPathUtilities() {
    }

    protected static void processAttrCert7(X509AttributeCertificate x509AttributeCertificate, CertPath certPath, CertPath certPath2, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        Set<String> set = x509AttributeCertificate.getCriticalExtensionOIDs();
        if (set.contains(TARGET_INFORMATION)) {
            try {
                TargetInformation.getInstance(CertPathValidatorUtilities.getExtensionValue(x509AttributeCertificate, TARGET_INFORMATION));
            }
            catch (AnnotatedException annotatedException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", annotatedException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExtCertPathValidatorException("Target information extension could not be read.", illegalArgumentException);
            }
        }
        set.remove(TARGET_INFORMATION);
        Iterator iterator = extendedPKIXParameters.getAttrCertCheckers().iterator();
        while (iterator.hasNext()) {
            ((PKIXAttrCertChecker)iterator.next()).check(x509AttributeCertificate, certPath, certPath2, set);
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Attribute certificate contains unsupported critical extensions: " + set);
        }
    }

    protected static void checkCRLs(X509AttributeCertificate x509AttributeCertificate, ExtendedPKIXParameters extendedPKIXParameters, X509Certificate x509Certificate, Date date) throws CertPathValidatorException {
        if (extendedPKIXParameters.isRevocationEnabled()) {
            if (x509AttributeCertificate.getExtensionValue(NO_REV_AVAIL) == null) {
                ExtendedPKIXParameters extendedPKIXParameters2;
                Object object;
                CRLDistPoint cRLDistPoint = null;
                try {
                    cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509AttributeCertificate, CRL_DISTRIBUTION_POINTS));
                }
                catch (AnnotatedException annotatedException) {
                    throw new CertPathValidatorException("CRL distribution point extension could not be read.", annotatedException);
                }
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, extendedPKIXParameters);
                }
                catch (AnnotatedException annotatedException) {
                    throw new CertPathValidatorException("No additional CRL locations could be decoded from CRL distribution point extension.", annotatedException);
                }
                CertStatus certStatus = new CertStatus();
                ReasonsMask reasonsMask = new ReasonsMask();
                AnnotatedException annotatedException = null;
                boolean bl = false;
                if (cRLDistPoint != null) {
                    object = null;
                    try {
                        object = cRLDistPoint.getDistributionPoints();
                    }
                    catch (Exception exception) {
                        throw new ExtCertPathValidatorException("Distribution points could not be read.", exception);
                    }
                    try {
                        for (int i = 0; i < ((DistributionPoint[])object).length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                            extendedPKIXParameters2 = (ExtendedPKIXParameters)extendedPKIXParameters.clone();
                            RFC3281CertPathUtilities.checkCRL(object[i], x509AttributeCertificate, extendedPKIXParameters2, date, x509Certificate, certStatus, reasonsMask);
                            bl = true;
                        }
                    }
                    catch (AnnotatedException annotatedException2) {
                        annotatedException = new AnnotatedException("No valid CRL for distribution point found.", annotatedException2);
                    }
                }
                if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
                    try {
                        object = null;
                        try {
                            object = new ASN1InputStream(((X500Principal)x509AttributeCertificate.getIssuer().getPrincipals()[0]).getEncoded()).readObject();
                        }
                        catch (Exception exception) {
                            throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", exception);
                        }
                        DistributionPoint distributionPoint = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, (ASN1Encodable)object))), null, null);
                        extendedPKIXParameters2 = (ExtendedPKIXParameters)extendedPKIXParameters.clone();
                        RFC3281CertPathUtilities.checkCRL(distributionPoint, x509AttributeCertificate, extendedPKIXParameters2, date, x509Certificate, certStatus, reasonsMask);
                        bl = true;
                    }
                    catch (AnnotatedException annotatedException3) {
                        annotatedException = new AnnotatedException("No valid CRL for distribution point found.", annotatedException3);
                    }
                }
                if (!bl) {
                    throw new ExtCertPathValidatorException("No valid CRL found.", annotatedException);
                }
                if (certStatus.getCertStatus() != 11) {
                    object = "Attribute certificate revocation after " + certStatus.getRevocationDate();
                    object = (String)object + ", reason: " + crlReasons[certStatus.getCertStatus()];
                    throw new CertPathValidatorException((String)object);
                }
                if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
                    certStatus.setCertStatus(12);
                }
                if (certStatus.getCertStatus() == 12) {
                    throw new CertPathValidatorException("Attribute certificate status could not be determined.");
                }
            } else if (x509AttributeCertificate.getExtensionValue(CRL_DISTRIBUTION_POINTS) != null || x509AttributeCertificate.getExtensionValue(AUTHORITY_INFO_ACCESS) != null) {
                throw new CertPathValidatorException("No rev avail extension is set, but also an AC revocation pointer.");
            }
        }
    }

    protected static void additionalChecks(X509AttributeCertificate x509AttributeCertificate, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        for (String string : extendedPKIXParameters.getProhibitedACAttributes()) {
            if (x509AttributeCertificate.getAttributes(string) == null) continue;
            throw new CertPathValidatorException("Attribute certificate contains prohibited attribute: " + string + ".");
        }
        for (String string : extendedPKIXParameters.getNecessaryACAttributes()) {
            if (x509AttributeCertificate.getAttributes(string) != null) continue;
            throw new CertPathValidatorException("Attribute certificate does not contain necessary attribute: " + string + ".");
        }
    }

    protected static void processAttrCert5(X509AttributeCertificate x509AttributeCertificate, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        try {
            x509AttributeCertificate.checkValidity(CertPathValidatorUtilities.getValidDate(extendedPKIXParameters));
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new ExtCertPathValidatorException("Attribute certificate is not valid.", certificateNotYetValidException);
        }
    }

    protected static void processAttrCert4(X509Certificate x509Certificate, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        Set set = extendedPKIXParameters.getTrustedACIssuers();
        boolean bl = false;
        for (TrustAnchor trustAnchor : set) {
            if (!x509Certificate.getSubjectX500Principal().getName("RFC2253").equals(trustAnchor.getCAName()) && !x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
            bl = true;
        }
        if (!bl) {
            throw new CertPathValidatorException("Attribute certificate issuer is not directly trusted.");
        }
    }

    protected static void processAttrCert3(X509Certificate x509Certificate, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        if (x509Certificate.getKeyUsage() != null && !x509Certificate.getKeyUsage()[0] && !x509Certificate.getKeyUsage()[1]) {
            throw new CertPathValidatorException("Attribute certificate issuer public key cannot be used to validate digital signatures.");
        }
        if (x509Certificate.getBasicConstraints() != -1) {
            throw new CertPathValidatorException("Attribute certificate issuer is also a public key certificate issuer.");
        }
    }

    protected static CertPathValidatorResult processAttrCert2(CertPath certPath, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        CertPathValidator certPathValidator = null;
        try {
            certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExtCertPathValidatorException("Support class could not be created.", noSuchAlgorithmException);
        }
        try {
            return certPathValidator.validate(certPath, extendedPKIXParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Certification path for issuer certificate of attribute certificate could not be validated.", certPathValidatorException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected static CertPath processAttrCert1(X509AttributeCertificate x509AttributeCertificate, ExtendedPKIXParameters extendedPKIXParameters) throws CertPathValidatorException {
        int n;
        Object object;
        Cloneable cloneable;
        CertPathBuilderResult certPathBuilderResult = null;
        HashSet hashSet = new HashSet();
        if (x509AttributeCertificate.getHolder().getIssuer() != null) {
            cloneable = new X509CertStoreSelector();
            ((X509CertSelector)cloneable).setSerialNumber(x509AttributeCertificate.getHolder().getSerialNumber());
            object = x509AttributeCertificate.getHolder().getIssuer();
            for (n = 0; n < ((Principal[])object).length; ++n) {
                try {
                    if (object[n] instanceof X500Principal) {
                        ((X509CertSelector)cloneable).setIssuer(((X500Principal)object[n]).getEncoded());
                    }
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((Selector)cloneable, extendedPKIXParameters.getStores()));
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", annotatedException);
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", iOException);
                }
            }
            if (hashSet.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in base certificate ID for attribute certificate cannot be found.");
            }
        }
        if (x509AttributeCertificate.getHolder().getEntityNames() != null) {
            cloneable = new X509CertStoreSelector();
            object = x509AttributeCertificate.getHolder().getEntityNames();
            for (n = 0; n < ((Principal[])object).length; ++n) {
                try {
                    if (object[n] instanceof X500Principal) {
                        ((X509CertSelector)cloneable).setIssuer(((X500Principal)object[n]).getEncoded());
                    }
                    hashSet.addAll(CertPathValidatorUtilities.findCertificates((Selector)cloneable, extendedPKIXParameters.getStores()));
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    throw new ExtCertPathValidatorException("Public key certificate for attribute certificate cannot be searched.", annotatedException);
                }
                catch (IOException iOException) {
                    throw new ExtCertPathValidatorException("Unable to encode X500 principal.", iOException);
                }
            }
            if (hashSet.isEmpty()) {
                throw new CertPathValidatorException("Public key certificate specified in entity name for attribute certificate cannot be found.");
            }
        }
        cloneable = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(extendedPKIXParameters);
        object = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
            x509CertStoreSelector.setCertificate((X509Certificate)iterator.next());
            ((ExtendedPKIXParameters)cloneable).setTargetConstraints(x509CertStoreSelector);
            CertPathBuilder certPathBuilder = null;
            try {
                certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", noSuchProviderException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ExtCertPathValidatorException("Support class could not be created.", noSuchAlgorithmException);
            }
            try {
                certPathBuilderResult = certPathBuilder.build(ExtendedPKIXBuilderParameters.getInstance((PKIXParameters)cloneable));
            }
            catch (CertPathBuilderException certPathBuilderException) {
                object = new ExtCertPathValidatorException("Certification path for public key certificate of attribute certificate could not be build.", certPathBuilderException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
            }
        }
        if (object != null) {
            throw object;
        }
        return certPathBuilderResult.getCertPath();
    }

    private static void checkCRL(DistributionPoint distributionPoint, X509AttributeCertificate x509AttributeCertificate, ExtendedPKIXParameters extendedPKIXParameters, Date date, X509Certificate x509Certificate, CertStatus certStatus, ReasonsMask reasonsMask) throws AnnotatedException {
        if (x509AttributeCertificate.getExtensionValue(X509Extensions.NoRevAvail.getId()) != null) {
            return;
        }
        Date date2 = new Date(System.currentTimeMillis());
        if (date.getTime() > date2.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set set = CertPathValidatorUtilities.getCompleteCRLs(distributionPoint, x509AttributeCertificate, date2, extendedPKIXParameters);
        boolean bl = false;
        AnnotatedException annotatedException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                X509CRL x509CRL = (X509CRL)iterator.next();
                ReasonsMask reasonsMask2 = RFC3281CertPathUtilities.processCRLD(x509CRL, distributionPoint);
                if (!reasonsMask2.hasNewReasons(reasonsMask)) continue;
                Set set2 = RFC3281CertPathUtilities.processCRLF(x509CRL, x509AttributeCertificate, null, null, extendedPKIXParameters);
                PublicKey publicKey = RFC3281CertPathUtilities.processCRLG(x509CRL, set2);
                X509CRL x509CRL2 = null;
                if (extendedPKIXParameters.isUseDeltasEnabled()) {
                    Set set3 = CertPathValidatorUtilities.getDeltaCRLs(date2, extendedPKIXParameters, x509CRL);
                    x509CRL2 = RFC3281CertPathUtilities.processCRLH(set3, publicKey);
                }
                if (extendedPKIXParameters.getValidityModel() != 1 && x509AttributeCertificate.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3281CertPathUtilities.processCRLB1(distributionPoint, x509AttributeCertificate, x509CRL);
                RFC3281CertPathUtilities.processCRLB2(distributionPoint, x509AttributeCertificate, x509CRL);
                RFC3281CertPathUtilities.processCRLC(x509CRL2, x509CRL, extendedPKIXParameters);
                RFC3281CertPathUtilities.processCRLI(date, x509CRL2, x509AttributeCertificate.getSerialNumber(), certStatus, extendedPKIXParameters);
                RFC3281CertPathUtilities.processCRLJ(date, x509CRL, x509AttributeCertificate.getSerialNumber(), certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonsMask.addReasons(reasonsMask2);
                bl = true;
            }
            catch (AnnotatedException annotatedException2) {
                annotatedException = annotatedException2;
            }
        }
        if (!bl) {
            throw annotatedException;
        }
    }

    protected static void processCRLB2(DistributionPoint distributionPoint, Object object, X509CRL x509CRL) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null && issuingDistributionPoint.getDistributionPoint() != null) {
            int n;
            DistributionPointName distributionPointName = IssuingDistributionPoint.getInstance(issuingDistributionPoint).getDistributionPoint();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            if (distributionPointName.getType() == 0) {
                GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                for (int i = 0; i < generalNameArray.length; ++i) {
                    arrayList.add(generalNameArray[i].getDEREncoded());
                }
            }
            boolean bl = false;
            if (distributionPoint.getDistributionPoint() != null) {
                distributionPointName = distributionPoint.getDistributionPoint();
                if (distributionPointName.getType() == 0) {
                    GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                    for (n = 0; n < generalNameArray.length; ++n) {
                        if (!arrayList.contains(generalNameArray[n])) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    throw new AnnotatedException("None of the names in the CRL issuing distribution point matches one of the names in a distributionPoint field of the certificate CRL distribution point.");
                }
            } else {
                if (distributionPoint.getCRLIssuer() == null) {
                    throw new AnnotatedException("Either the cRLIssuer or the distributionPoint field must be contained in DistributionPoint.");
                }
                GeneralName[] generalNameArray = distributionPoint.getCRLIssuer().getNames();
                for (n = 0; n < generalNameArray.length; ++n) {
                    if (!arrayList.contains(generalNameArray[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new AnnotatedException("None of the names in the CRL issuing distribution point matches one of the names in a cRLIssuer field of the certificate CRL distribution point.");
                }
            }
            BasicConstraints basicConstraints = null;
            try {
                basicConstraints = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)object, BASIC_CONSTRAINTS));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Basic constraints extension could not be decoded.", exception);
            }
            if (object instanceof X509Certificate) {
                if (issuingDistributionPoint.onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    throw new AnnotatedException("CA Cert CRL only contains user certificates.");
                }
                if (issuingDistributionPoint.onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    throw new AnnotatedException("End CRL only contains CA certificates.");
                }
            }
            if (issuingDistributionPoint.onlyContainsAttributeCerts()) {
                throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted.");
            }
        }
    }

    protected static void processCRLB1(DistributionPoint distributionPoint, Object object, X509CRL x509CRL) throws AnnotatedException {
        DERObject dERObject = CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT);
        boolean bl = false;
        if (dERObject != null && IssuingDistributionPoint.getInstance(dERObject).isIndirectCRL()) {
            bl = true;
        }
        byte[] byArray = CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded();
        boolean bl2 = false;
        if (distributionPoint.getCRLIssuer() != null) {
            GeneralName[] generalNameArray = distributionPoint.getCRLIssuer().getNames();
            for (int i = 0; i < generalNameArray.length; ++i) {
                if (generalNameArray[i].getTagNo() != 4) continue;
                try {
                    if (!generalNameArray[i].getName().getDERObject().getEncoded().equals(byArray)) continue;
                    bl2 = true;
                    continue;
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
            if (bl2 && !bl) {
                throw new AnnotatedException("Distribution point contains cRLIssuer field but CRL is not indirect.");
            }
            if (!bl2) {
                throw new AnnotatedException("CRL issuer of CRL does not match CRL issuer of distribution point.");
            }
        } else if (CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).equals(CertPathValidatorUtilities.getEncodedIssuerPrincipal(object))) {
            bl2 = true;
        }
        if (!bl2) {
            throw new AnnotatedException("Cannot find matching CRL issuer for certificate.");
        }
    }

    protected static ReasonsMask processCRLD(X509CRL x509CRL, DistributionPoint distributionPoint) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null && issuingDistributionPoint.getOnlySomeReasons() != null && distributionPoint.getReasons() != null) {
            return new ReasonsMask(distributionPoint.getReasons().intValue()).intersect(new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons().intValue()));
        }
        if ((issuingDistributionPoint == null || issuingDistributionPoint.getOnlySomeReasons() == null) && distributionPoint.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (distributionPoint.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(distributionPoint.getReasons().intValue())).intersect(issuingDistributionPoint == null ? ReasonsMask.allReasons : new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons().intValue()));
    }

    protected static Set processCRLF(X509CRL x509CRL, Object object, X509Certificate x509Certificate, PublicKey publicKey, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        Object object2;
        Serializable serializable;
        X509CertStoreSelector x509CertStoreSelector = new X509CertStoreSelector();
        try {
            x509CertStoreSelector.setSubject(CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate for CRL could not be set.", iOException);
        }
        Collection collection = null;
        try {
            collection = CertPathValidatorUtilities.findCertificates(x509CertStoreSelector, extendedPKIXParameters.getStores());
            collection = CertPathValidatorUtilities.findCertificates(x509CertStoreSelector, extendedPKIXParameters.getAddionalStores());
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate for CRL cannot be searched.", annotatedException);
        }
        if (x509Certificate != null) {
            collection.add(x509Certificate);
        }
        Iterator iterator = collection.iterator();
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        while (iterator.hasNext()) {
            serializable = (X509Certificate)iterator.next();
            if (CertPathValidatorUtilities.getEncodedIssuerPrincipal(object).equals(((X509Certificate)serializable).getSubjectX500Principal()) && ((Certificate)serializable).getPublicKey().equals(publicKey)) {
                hashSet.add(serializable);
                continue;
            }
            try {
                object2 = CertPathBuilder.getInstance("PKIX", "BC");
                x509CertStoreSelector = new X509CertStoreSelector();
                x509CertStoreSelector.setCertificate((X509Certificate)serializable);
                ExtendedPKIXBuilderParameters extendedPKIXBuilderParameters = (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance(extendedPKIXParameters);
                extendedPKIXBuilderParameters.setTargetConstraints(x509CertStoreSelector);
                Serializable serializable2 = new HashSet();
                serializable2.add(object);
                extendedPKIXBuilderParameters.setExcludedCerts((Set)((Object)serializable2));
                ((CertPathBuilder)object2).build(extendedPKIXBuilderParameters);
                hashSet.add(serializable);
            }
            catch (Exception exception) {}
        }
        serializable = new HashSet();
        if (x509Certificate == null && publicKey != null) {
            serializable.add(publicKey);
        }
        object2 = null;
        for (Serializable serializable2 : hashSet) {
            boolean[] blArray = ((X509Certificate)serializable2).getKeyUsage();
            if (!(blArray == null || blArray.length >= 7 && blArray[6])) {
                object2 = new AnnotatedException("Issuer certificate key usage extension does not permit CRL signing.");
                continue;
            }
            serializable.add(((Certificate)serializable2).getPublicKey());
        }
        if (serializable.isEmpty() && object2 == null) {
            throw new AnnotatedException("Cannot find a valid issuer certificate.");
        }
        if (serializable.isEmpty() && object2 != null) {
            throw object2;
        }
        return serializable;
    }

    protected static PublicKey processCRLG(X509CRL x509CRL, Set set) throws AnnotatedException {
        Exception exception = null;
        try {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                PublicKey publicKey = (PublicKey)iterator.next();
                x509CRL.verify(publicKey);
                return publicKey;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        throw new AnnotatedException("Cannot verify CRL.", exception);
    }

    protected static X509CRL processCRLH(Set set, PublicKey publicKey) throws AnnotatedException {
        Exception exception = null;
        try {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                X509CRL x509CRL = (X509CRL)iterator.next();
                x509CRL.verify(publicKey);
                return x509CRL;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        throw new AnnotatedException("Cannot verify delta CRL.", exception);
    }

    protected static Set processCRLA1i(Date date, ExtendedPKIXParameters extendedPKIXParameters, X509Certificate x509Certificate, X509CRL x509CRL) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        if (extendedPKIXParameters.isUseDeltasEnabled()) {
            CRLDistPoint cRLDistPoint = null;
            try {
                cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, FRESHEST_CRL));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Freshest CRL extension could not be decoded from certificate.", annotatedException);
            }
            if (cRLDistPoint == null) {
                try {
                    cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, FRESHEST_CRL));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Freshest CRL extension could not be decoded from CRL.", annotatedException);
                }
            }
            if (cRLDistPoint != null) {
                try {
                    CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, extendedPKIXParameters);
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("No new delta CRL locations could be added from Freshest CRL extension.", annotatedException);
                }
                try {
                    hashSet.addAll(CertPathValidatorUtilities.getDeltaCRLs(date, extendedPKIXParameters, x509CRL));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
                }
            }
        }
        return hashSet;
    }

    protected static Set[] processCRLA1ii(Date date, ExtendedPKIXParameters extendedPKIXParameters, X509Certificate x509Certificate, X509CRL x509CRL) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        x509CRLStoreSelector.setCertificateChecking(x509Certificate);
        x509CRLStoreSelector.setCompleteCRLEnabled(true);
        x509CRLStoreSelector.setDateAndTime(date);
        try {
            x509CRLStoreSelector.addIssuerName(x509CRL.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from CRL." + iOException, iOException);
        }
        try {
            hashSet.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getAddionalStores()));
            hashSet.addAll(CertPathValidatorUtilities.findCRLs(x509CRLStoreSelector, extendedPKIXParameters.getStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", annotatedException);
        }
        if (extendedPKIXParameters.isUseDeltasEnabled()) {
            try {
                hashSet2.addAll(CertPathValidatorUtilities.getDeltaCRLs(date, extendedPKIXParameters, x509CRL));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
            }
        }
        return new Set[]{hashSet, hashSet2};
    }

    protected static void processCRLC(X509CRL x509CRL, X509CRL x509CRL2, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL2, ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (extendedPKIXParameters.isUseDeltasEnabled()) {
            ASN1Encodable aSN1Encodable;
            if (!x509CRL.getIssuerX500Principal().equals(x509CRL2.getIssuerX500Principal())) {
                throw new AnnotatedException("Complete CRL issuer does not match delta CRL issuer.");
            }
            if (issuingDistributionPoint != null) {
                aSN1Encodable = null;
                try {
                    aSN1Encodable = IssuingDistributionPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT));
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Issuing distribution point extension from delta CRL could not be decoded.", exception);
                }
                boolean bl = false;
                if (issuingDistributionPoint == null) {
                    if (aSN1Encodable == null) {
                        bl = true;
                    }
                } else if (issuingDistributionPoint.equals(aSN1Encodable)) {
                    bl = true;
                }
                if (!bl) {
                    throw new AnnotatedException("Issuing distribution point extension from delta CRL and complete CRL does not match.");
                }
            }
            aSN1Encodable = null;
            try {
                aSN1Encodable = CertPathValidatorUtilities.getExtensionValue(x509CRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from complete CRL.", annotatedException);
            }
            DERObject dERObject = null;
            try {
                dERObject = CertPathValidatorUtilities.getExtensionValue(x509CRL, AUTHORITY_KEY_IDENTIFIER);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from delta CRL.", annotatedException);
            }
            if (!((DERObject)aSN1Encodable).equals(dERObject)) {
                throw new AnnotatedException("Delta CRL authority key identifier does not match complete CRL authority key identifier.");
            }
        }
    }

    protected static void processCRLI(Date date, X509CRL x509CRL, BigInteger bigInteger, CertStatus certStatus, ExtendedPKIXParameters extendedPKIXParameters) throws AnnotatedException {
        if (extendedPKIXParameters.isUseDeltasEnabled()) {
            CertPathValidatorUtilities.getCertStatus(date, x509CRL, bigInteger, certStatus);
        }
    }

    protected static void processCRLJ(Date date, X509CRL x509CRL, BigInteger bigInteger, CertStatus certStatus) throws AnnotatedException {
        CertPathValidatorUtilities.getCertStatus(date, x509CRL, bigInteger, certStatus);
    }

    private static void checkCRL(DistributionPoint distributionPoint, ExtendedPKIXParameters extendedPKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, CertStatus certStatus, ReasonsMask reasonsMask, List list) throws AnnotatedException {
        Date date2 = new Date(System.currentTimeMillis());
        if (date.getTime() > date2.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Set set = CertPathValidatorUtilities.getCompleteCRLs(distributionPoint, x509Certificate, date2, extendedPKIXParameters);
        boolean bl = false;
        AnnotatedException annotatedException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                X509CRL x509CRL = (X509CRL)iterator.next();
                ReasonsMask reasonsMask2 = RFC3281CertPathUtilities.processCRLD(x509CRL, distributionPoint);
                if (!reasonsMask2.hasNewReasons(reasonsMask)) continue;
                Set set2 = RFC3281CertPathUtilities.processCRLF(x509CRL, x509Certificate, x509Certificate2, publicKey, extendedPKIXParameters);
                PublicKey publicKey2 = RFC3281CertPathUtilities.processCRLG(x509CRL, set2);
                X509CRL x509CRL2 = null;
                if (extendedPKIXParameters.isUseDeltasEnabled()) {
                    Set set3 = CertPathValidatorUtilities.getDeltaCRLs(date2, extendedPKIXParameters, x509CRL);
                    x509CRL2 = RFC3281CertPathUtilities.processCRLH(set3, publicKey2);
                }
                if (extendedPKIXParameters.getValidityModel() != 1 && x509Certificate.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3281CertPathUtilities.processCRLB1(distributionPoint, x509Certificate, x509CRL);
                RFC3281CertPathUtilities.processCRLB2(distributionPoint, x509Certificate, x509CRL);
                RFC3281CertPathUtilities.processCRLC(x509CRL2, x509CRL, extendedPKIXParameters);
                RFC3281CertPathUtilities.processCRLI(date, x509CRL2, x509Certificate.getSerialNumber(), certStatus, extendedPKIXParameters);
                RFC3281CertPathUtilities.processCRLJ(date, x509CRL, x509Certificate.getSerialNumber(), certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonsMask.addReasons(reasonsMask2);
                bl = true;
            }
            catch (AnnotatedException annotatedException2) {
                annotatedException = annotatedException2;
            }
        }
        if (!bl) {
            throw annotatedException;
        }
    }

    private static void checkCRLs(ExtendedPKIXParameters extendedPKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, List list) throws AnnotatedException {
        ExtendedPKIXParameters extendedPKIXParameters2;
        Object object;
        AnnotatedException annotatedException = null;
        CRLDistPoint cRLDistPoint = null;
        try {
            cRLDistPoint = CRLDistPoint.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception exception) {
            throw new AnnotatedException("CRL distribution point extension could not be read.", exception);
        }
        try {
            CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, extendedPKIXParameters);
        }
        catch (AnnotatedException annotatedException2) {
            throw new AnnotatedException("No additional CRL locations could be decoded from CRL distribution point extension.", annotatedException2);
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        boolean bl = false;
        if (cRLDistPoint != null) {
            object = null;
            try {
                object = cRLDistPoint.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            try {
                for (int i = 0; i < ((DistributionPoint[])object).length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                    extendedPKIXParameters2 = (ExtendedPKIXParameters)extendedPKIXParameters.clone();
                    RFC3281CertPathUtilities.checkCRL(object[i], extendedPKIXParameters2, x509Certificate, date, x509Certificate2, publicKey, certStatus, reasonsMask, list);
                    bl = true;
                }
            }
            catch (AnnotatedException annotatedException3) {
                annotatedException = new AnnotatedException("No valid CRL for distribution point found.", annotatedException3);
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                object = null;
                try {
                    object = new ASN1InputStream(CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate).getEncoded()).readObject();
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Issuer from certificate for CRL could not be reencoded.", exception);
                }
                DistributionPoint distributionPoint = new DistributionPoint(new DistributionPointName(0, new GeneralNames(new GeneralName(4, (ASN1Encodable)object))), null, null);
                extendedPKIXParameters2 = (ExtendedPKIXParameters)extendedPKIXParameters.clone();
                RFC3281CertPathUtilities.checkCRL(distributionPoint, extendedPKIXParameters2, x509Certificate, date, x509Certificate2, publicKey, certStatus, reasonsMask, list);
                bl = true;
            }
            catch (AnnotatedException annotatedException4) {
                annotatedException = new AnnotatedException("No valid CRL for distribution point found.", annotatedException4);
            }
        }
        if (!bl) {
            throw new AnnotatedException("No valid CRL found.", annotatedException);
        }
        if (certStatus.getCertStatus() != 11) {
            object = "Certificate revocation after " + certStatus.getRevocationDate();
            object = (String)object + ", reason: " + crlReasons[certStatus.getCertStatus()];
            throw new AnnotatedException((String)object);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new AnnotatedException("Certificate status could not be determined.");
        }
    }
}

