/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnftp;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.msnftp.MsnftpMessage;
import net.sf.jml.protocol.msnftp.MsnftpSession;

public class MsnftpContent
extends MsnftpMessage {
    private boolean cancelled;
    private byte[] transferData;

    public MsnftpContent(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public byte[] getTransferData() {
        return this.transferData;
    }

    public void setTransferData(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.slice().get(byArray);
        this.setTransferData(byArray);
    }

    public void setTransferData(byte[] byArray) {
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("transfer data can't more than 65535 byte");
        }
        this.transferData = byArray;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    protected boolean load(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 3) {
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            this.cancelled = byteBuffer2.get() == 1;
            int n = byteBuffer2.getShort() & 0xFFFF;
            if (byteBuffer.remaining() < n + 3) {
                return false;
            }
            this.transferData = new byte[n];
            byteBuffer.position(byteBuffer.position() + 3);
            byteBuffer.get(this.transferData);
            return true;
        }
        return false;
    }

    protected ByteBuffer[] save() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[2];
        byteBufferArray[0] = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
        int n = this.transferData == null ? 0 : this.transferData.length;
        byteBufferArray[0].put(this.cancelled ? (byte)1 : 0);
        byteBufferArray[0].putShort((short)n);
        byteBufferArray[0].flip();
        byteBufferArray[1] = this.transferData == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(this.transferData);
        return byteBufferArray;
    }

    public String toString() {
        return this.getClass().getName() + " Content Length : " + (this.transferData == null ? 0 : this.transferData.length) + (this.cancelled ? " Cancelled" : "");
    }

    protected void messageReceived(MsnftpSession msnftpSession) {
        super.messageReceived(msnftpSession);
        if (!msnftpSession.getFileTransfer().isReceiver()) {
            msnftpSession.close();
        }
    }

    protected void messageSent(MsnftpSession msnftpSession) {
        super.messageSent(msnftpSession);
    }
}

