/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetDTMF;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DTMFMethod;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.StringUtils;

public abstract class AbstractOperationSetDTMF
implements OperationSetDTMF {
    protected DTMFMethod dtmfMethod;
    protected int minimalToneDuration;
    protected int maximalToneDuration;
    protected int volume;

    public AbstractOperationSetDTMF(ProtocolProviderService pps) {
        this.dtmfMethod = AbstractOperationSetDTMF.getDTMFMethod(pps);
        this.minimalToneDuration = AbstractOperationSetDTMF.getMinimalToneDurationSetting(pps);
        this.maximalToneDuration = AbstractOperationSetDTMF.getMaximalToneDurationSetting();
        this.volume = AbstractOperationSetDTMF.getVolumeSetting(pps);
    }

    private static int getMinimalToneDurationSetting(ProtocolProviderService pps) {
        AccountID accountID = pps.getAccountID();
        String minimalToneDurationString = accountID.getAccountPropertyString((Object)"DTMF_MINIMAL_TONE_DURATION");
        int minimalToneDuration = 100;
        if (!StringUtils.isNullOrEmpty((String)minimalToneDurationString)) {
            minimalToneDuration = Integer.valueOf(minimalToneDurationString);
        } else {
            ConfigurationService cfg = ProtocolProviderActivator.getConfigurationService();
            if (cfg != null) {
                minimalToneDuration = cfg.getInt("net.java.sip.communicator.service.protocol.minimalRtpDtmfToneDuration", minimalToneDuration);
            }
        }
        return minimalToneDuration;
    }

    private static int getMaximalToneDurationSetting() {
        int maximalToneDuration = -1;
        ConfigurationService cfg = ProtocolProviderActivator.getConfigurationService();
        if (cfg != null) {
            maximalToneDuration = cfg.getInt("net.java.sip.communicator.service.protocol.maximalRtpDtmfToneDuration", maximalToneDuration);
        }
        return maximalToneDuration;
    }

    private static DTMFMethod getDTMFMethod(ProtocolProviderService pps) {
        AccountID accountID = pps.getAccountID();
        String dtmfString = accountID.getAccountPropertyString((Object)"DTMF_METHOD");
        if (dtmfString == null || !dtmfString.equals("AUTO_DTMF") && !dtmfString.equals("RTP_DTMF") && !dtmfString.equals("SIP_INFO_DTMF") && !dtmfString.equals("INBAND_DTMF")) {
            dtmfString = "AUTO_DTMF";
            accountID.putAccountProperty("DTMF_METHOD", dtmfString);
        }
        if (dtmfString.equals("AUTO_DTMF")) {
            return DTMFMethod.AUTO_DTMF;
        }
        if (dtmfString.equals("RTP_DTMF")) {
            return DTMFMethod.RTP_DTMF;
        }
        if (dtmfString.equals("SIP_INFO_DTMF")) {
            return DTMFMethod.SIP_INFO_DTMF;
        }
        return DTMFMethod.INBAND_DTMF;
    }

    protected static boolean isRFC4733Active(MediaAwareCallPeer peer) {
        for (MediaFormat mediaFormat : ((CallPeerMediaHandler)((Object)peer.getMediaHandler())).getStream(MediaType.AUDIO).getDynamicRTPPayloadTypes().values()) {
            if (!mediaFormat.getEncoding().equals("telephone-event")) continue;
            return true;
        }
        return false;
    }

    private static int getVolumeSetting(ProtocolProviderService pps) {
        AccountID accountID = pps.getAccountID();
        String volumeString = accountID.getAccountPropertyString((Object)"DTMF_TONE_VOLUME");
        int vol = 10;
        if (!StringUtils.isNullOrEmpty((String)volumeString)) {
            vol = vol;
        }
        return vol;
    }
}

