/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.mathzrtp.ec.ECConstants;

class SimpleBigDecimal {
    private static final long serialVersionUID = 1L;
    private final BigIntegerCrypto bigInt;
    private final int scale;

    public static SimpleBigDecimal getInstance(BigIntegerCrypto value, int scale) {
        return new SimpleBigDecimal(value.shiftLeft(scale), scale);
    }

    public SimpleBigDecimal(BigIntegerCrypto bigInt, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale may not be negative");
        }
        this.bigInt = bigInt;
        this.scale = scale;
    }

    private SimpleBigDecimal(SimpleBigDecimal limBigDec) {
        this.bigInt = limBigDec.bigInt;
        this.scale = limBigDec.scale;
    }

    private void checkScale(SimpleBigDecimal b) {
        if (this.scale != b.scale) {
            throw new IllegalArgumentException("Only SimpleBigDecimal of same scale allowed in arithmetic operations");
        }
    }

    public SimpleBigDecimal adjustScale(int newScale) {
        if (newScale < 0) {
            throw new IllegalArgumentException("scale may not be negative");
        }
        if (newScale == this.scale) {
            return new SimpleBigDecimal(this);
        }
        return new SimpleBigDecimal(this.bigInt.shiftLeft(newScale - this.scale), newScale);
    }

    public SimpleBigDecimal add(SimpleBigDecimal b) {
        this.checkScale(b);
        return new SimpleBigDecimal(this.bigInt.add(b.bigInt), this.scale);
    }

    public SimpleBigDecimal add(BigIntegerCrypto b) {
        return new SimpleBigDecimal(this.bigInt.add(b.shiftLeft(this.scale)), this.scale);
    }

    public SimpleBigDecimal negate() {
        return new SimpleBigDecimal(this.bigInt.negate(), this.scale);
    }

    public SimpleBigDecimal subtract(SimpleBigDecimal b) {
        return this.add(b.negate());
    }

    public SimpleBigDecimal subtract(BigIntegerCrypto b) {
        return new SimpleBigDecimal(this.bigInt.subtract(b.shiftLeft(this.scale)), this.scale);
    }

    public SimpleBigDecimal multiply(SimpleBigDecimal b) {
        this.checkScale(b);
        return new SimpleBigDecimal(this.bigInt.multiply(b.bigInt), this.scale + this.scale);
    }

    public SimpleBigDecimal multiply(BigIntegerCrypto b) {
        return new SimpleBigDecimal(this.bigInt.multiply(b), this.scale);
    }

    public SimpleBigDecimal divide(SimpleBigDecimal b) {
        this.checkScale(b);
        BigIntegerCrypto dividend = this.bigInt.shiftLeft(this.scale);
        return new SimpleBigDecimal(dividend.divide(b.bigInt), this.scale);
    }

    public SimpleBigDecimal divide(BigIntegerCrypto b) {
        return new SimpleBigDecimal(this.bigInt.divide(b), this.scale);
    }

    public SimpleBigDecimal shiftLeft(int n) {
        return new SimpleBigDecimal(this.bigInt.shiftLeft(n), this.scale);
    }

    public int compareTo(SimpleBigDecimal val) {
        this.checkScale(val);
        return this.bigInt.compareTo(val.bigInt);
    }

    public int compareTo(BigIntegerCrypto val) {
        return this.bigInt.compareTo(val.shiftLeft(this.scale));
    }

    public BigIntegerCrypto floor() {
        return this.bigInt.shiftRight(this.scale);
    }

    public BigIntegerCrypto round() {
        SimpleBigDecimal oneHalf = new SimpleBigDecimal(ECConstants.ONE, 1);
        return this.add(oneHalf.adjustScale(this.scale)).floor();
    }

    public int intValue() {
        return this.floor().intValue();
    }

    public long longValue() {
        return this.floor().longValue();
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        if (this.scale == 0) {
            return this.bigInt.toString();
        }
        BigIntegerCrypto floorBigInt = this.floor();
        BigIntegerCrypto fract = this.bigInt.subtract(floorBigInt.shiftLeft(this.scale));
        if (this.bigInt.signum() == -1) {
            fract = ECConstants.ONE.shiftLeft(this.scale).subtract(fract);
        }
        if (floorBigInt.signum() == -1 && !fract.equals(ECConstants.ZERO)) {
            floorBigInt = floorBigInt.add(ECConstants.ONE);
        }
        String leftOfPoint = floorBigInt.toString();
        char[] fractCharArr = new char[this.scale];
        String fractStr = fract.toString(2);
        int fractLen = fractStr.length();
        int zeroes = this.scale - fractLen;
        int i = 0;
        while (i < zeroes) {
            fractCharArr[i] = 48;
            ++i;
        }
        int j = 0;
        while (j < fractLen) {
            fractCharArr[zeroes + j] = fractStr.charAt(j);
            ++j;
        }
        String rightOfPoint = new String(fractCharArr);
        StringBuffer sb = new StringBuffer(leftOfPoint);
        sb.append(".");
        sb.append(rightOfPoint);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleBigDecimal)) {
            return false;
        }
        SimpleBigDecimal other = (SimpleBigDecimal)o;
        return this.bigInt.equals(other.bigInt) && this.scale == other.scale;
    }

    public int hashCode() {
        return this.bigInt.hashCode() ^ this.scale;
    }
}

