/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketCommit
extends ZrtpPacketBase {
    private static final int ZRTP_COMMIT_LENGTH = 26;
    private static final int HASH_H2_OFFSET = 12;
    private static final int ZID_OFFSET = 44;
    private static final int HASH_OFFSET = 56;
    private static final int CIPHER_OFFSET = 60;
    private static final int AUTHLENGTHS_OFFSET = 64;
    private static final int PUBKEY_OFFSET = 68;
    private static final int SAS_OFFSET = 72;
    private static final int HVI_OFFSET = 76;
    private static final int HMAC_OFFSET = 108;
    private static final int COMMIT_LENGTH = 120;

    public ZrtpPacketCommit() {
        super(new byte[120]);
        this.setZrtpId();
        this.setLength(29);
        this.setMessageType(ZrtpConstants.CommitMsg);
    }

    public ZrtpPacketCommit(byte[] data) {
        super(data);
    }

    public final ZrtpConstants.SupportedHashes getHash() {
        ZrtpConstants.SupportedHashes[] supportedHashesArray = ZrtpConstants.SupportedHashes.values();
        int n = supportedHashesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZrtpConstants.SupportedHashes sh = supportedHashesArray[n2];
            byte[] s = sh.name;
            if (s[0] == this.packetBuffer[56] && s[1] == this.packetBuffer[57] && s[2] == this.packetBuffer[58] && s[3] == this.packetBuffer[59]) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public final ZrtpConstants.SupportedSymCiphers getCipher() {
        ZrtpConstants.SupportedSymCiphers[] supportedSymCiphersArray = ZrtpConstants.SupportedSymCiphers.values();
        int n = supportedSymCiphersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZrtpConstants.SupportedSymCiphers sh = supportedSymCiphersArray[n2];
            byte[] s = sh.name;
            if (s[0] == this.packetBuffer[60] && s[1] == this.packetBuffer[61] && s[2] == this.packetBuffer[62] && s[3] == this.packetBuffer[63]) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public final ZrtpConstants.SupportedAuthLengths getAuthlen() {
        ZrtpConstants.SupportedAuthLengths[] supportedAuthLengthsArray = ZrtpConstants.SupportedAuthLengths.values();
        int n = supportedAuthLengthsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZrtpConstants.SupportedAuthLengths sh = supportedAuthLengthsArray[n2];
            byte[] s = sh.name;
            if (s[0] == this.packetBuffer[64] && s[1] == this.packetBuffer[65] && s[2] == this.packetBuffer[66] && s[3] == this.packetBuffer[67]) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public final ZrtpConstants.SupportedPubKeys getPubKey() {
        ZrtpConstants.SupportedPubKeys[] supportedPubKeysArray = ZrtpConstants.SupportedPubKeys.values();
        int n = supportedPubKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZrtpConstants.SupportedPubKeys sh = supportedPubKeysArray[n2];
            byte[] s = sh.name;
            if (s[0] == this.packetBuffer[68] && s[1] == this.packetBuffer[69] && s[2] == this.packetBuffer[70] && s[3] == this.packetBuffer[71]) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public ZrtpConstants.SupportedSASTypes getSas() {
        ZrtpConstants.SupportedSASTypes[] supportedSASTypesArray = ZrtpConstants.SupportedSASTypes.values();
        int n = supportedSASTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZrtpConstants.SupportedSASTypes sh = supportedSASTypesArray[n2];
            byte[] s = sh.name;
            if (s[0] == this.packetBuffer[72] && s[1] == this.packetBuffer[73] && s[2] == this.packetBuffer[74] && s[3] == this.packetBuffer[75]) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public final byte[] getZid() {
        return ZrtpUtils.readRegion(this.packetBuffer, 44, 12);
    }

    public final byte[] getHvi() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76, 32);
    }

    public final byte[] getH2() {
        return ZrtpUtils.readRegion(this.packetBuffer, 12, 32);
    }

    public final byte[] getHMAC() {
        return ZrtpUtils.readRegion(this.packetBuffer, 108, 8);
    }

    public final byte[] getHMACMulti() {
        return ZrtpUtils.readRegion(this.packetBuffer, 92, 8);
    }

    public final byte[] getNonce() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76, 16);
    }

    public final void setHashType(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 56, 4);
    }

    public final void setCipherType(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 60, 4);
    }

    public final boolean isLengthOk() {
        return this.getLength() >= 25;
    }

    public final void setAuthLen(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 64, 4);
    }

    public final void setPubKeyType(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 68, 4);
    }

    public final void setSasType(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 72, 4);
    }

    public final void setZid(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 44, 12);
    }

    public final void setHvi(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 76, 32);
    }

    public final void setH2(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 32);
    }

    public final void setHMAC(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 108, 8);
    }

    public final void setHMACMulti(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 92, 8);
    }

    public final void setNonce(byte[] data) {
        byte[] temp = new byte[104];
        System.arraycopy(this.packetBuffer, 0, temp, 0, 104);
        this.packetBuffer = temp;
        System.arraycopy(data, 0, this.packetBuffer, 76, 16);
        this.setLength(25);
    }
}

