/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.PortTracker;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.TransportManager;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

public class IceUdpTransportManager
extends TransportManager {
    private static final int[] COMPONENT_IDS = new int[]{1, 2};
    private final Agent iceAgent = this.createIceAgent();
    private StreamConnector streamConnector;

    public IceUdpTransportManager(Channel channel) throws IOException {
        super(channel);
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
        super.channelPropertyChange(ev);
        if ("initiator".equals(ev.getPropertyName()) && this.iceAgent != null) {
            Channel channel = (Channel)((Object)ev.getSource());
            this.iceAgent.setControlling(channel.isInitiator());
        }
    }

    public void close() {
        super.close();
        if (this.iceAgent != null) {
            this.iceAgent.free();
        }
    }

    private synchronized void closeStreamConnector() {
        if (this.streamConnector != null) {
            this.streamConnector.close();
            this.streamConnector = null;
        }
    }

    private Agent createIceAgent() throws IOException {
        Agent iceAgent;
        block2: {
            Channel channel = this.getChannel();
            Content content = channel.getContent();
            NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)content.getConference().getVideobridge().getComponent().getBundleContext(), NetworkAddressManagerService.class);
            iceAgent = nams.createIceAgent();
            iceAgent.setControlling(channel.isInitiator());
            PortTracker portTracker = JitsiTransportManager.getPortTracker(content.getMediaType());
            IceMediaStream iceStream = nams.createIceStream(portTracker.getPort(), content.getName(), iceAgent);
            try {
                portTracker.setNextPort(1 + ((LocalCandidate)iceStream.getComponent(2).getLocalCandidates().get(0)).getTransportAddress().getPort());
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block2;
                throw (ThreadDeath)t;
            }
        }
        return iceAgent;
    }

    private StreamConnector createStreamConnector() {
        DatagramSocket[] streamConnectorSockets = this.getStreamConnectorSockets();
        return streamConnectorSockets == null ? null : new DefaultStreamConnector(streamConnectorSockets[0], streamConnectorSockets[1]);
    }

    protected void describe(IceUdpTransportPacketExtension pe) {
        pe.setPassword(this.iceAgent.getLocalPassword());
        pe.setUfrag(this.iceAgent.getLocalUfrag());
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        if (stream != null) {
            for (Component component : stream.getComponents()) {
                List candidates = component.getLocalCandidates();
                if (candidates == null || candidates.isEmpty()) continue;
                for (LocalCandidate candidate : candidates) {
                    this.describe(candidate, pe);
                }
            }
        }
    }

    private void describe(LocalCandidate candidate, IceUdpTransportPacketExtension pe) {
        CandidatePacketExtension candidatePE = new CandidatePacketExtension();
        Component component = candidate.getParentComponent();
        candidatePE.setComponent(component.getComponentID());
        candidatePE.setFoundation(candidate.getFoundation());
        candidatePE.setGeneration(component.getParentStream().getParentAgent().getGeneration());
        candidatePE.setID(this.generateCandidateID(candidate));
        candidatePE.setNetwork(0);
        candidatePE.setPriority(candidate.getPriority());
        candidatePE.setProtocol(candidate.getTransport().toString());
        candidatePE.setType(CandidateType.valueOf((String)candidate.getType().toString()));
        TransportAddress transportAddress = candidate.getTransportAddress();
        candidatePE.setIP(transportAddress.getHostAddress());
        candidatePE.setPort(transportAddress.getPort());
        TransportAddress relatedAddress = candidate.getRelatedAddress();
        if (relatedAddress != null) {
            candidatePE.setRelAddr(relatedAddress.getHostAddress());
            candidatePE.setRelPort(relatedAddress.getPort());
        }
        pe.addChildExtension((PacketExtension)candidatePE);
    }

    private String generateCandidateID(LocalCandidate candidate) {
        StringBuilder candidateID = new StringBuilder();
        Channel channel = this.getChannel();
        Content content = channel.getContent();
        Conference conference = content.getConference();
        candidateID.append(conference.getID());
        candidateID.append(Long.toHexString(content.hashCode()));
        candidateID.append(channel.getID());
        Agent iceAgent = candidate.getParentComponent().getParentStream().getParentAgent();
        candidateID.append(Long.toHexString(iceAgent.hashCode()));
        candidateID.append(Long.toHexString(iceAgent.getGeneration()));
        candidateID.append(Long.toHexString(candidate.hashCode()));
        return candidateID.toString();
    }

    public synchronized StreamConnector getStreamConnector() {
        DatagramSocket[] streamConnectorSockets;
        StreamConnector streamConnector = this.streamConnector;
        if (streamConnector != null && (streamConnectorSockets = this.getStreamConnectorSockets()) != null && (streamConnector.getDataSocket() != streamConnectorSockets[0] || streamConnector.getControlSocket() != streamConnectorSockets[1])) {
            this.closeStreamConnector();
        }
        if (this.streamConnector == null) {
            this.streamConnector = this.createStreamConnector();
        }
        return this.streamConnector;
    }

    private DatagramSocket[] getStreamConnectorSockets() {
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        if (stream != null) {
            DatagramSocket[] streamConnectorSockets = new DatagramSocket[COMPONENT_IDS.length];
            int streamConnectorSocketCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                DatagramSocket streamConnectorSocket;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamConnectorSocket = selectedPair.getLocalCandidate().getDatagramSocket()) == null) continue;
                streamConnectorSockets[i] = streamConnectorSocket;
                ++streamConnectorSocketCount;
            }
            if (streamConnectorSocketCount > 0) {
                return streamConnectorSockets;
            }
        }
        return null;
    }

    public MediaStreamTarget getStreamTarget() {
        IceMediaStream stream = this.iceAgent.getStream(this.getChannel().getContent().getName());
        MediaStreamTarget streamTarget = null;
        if (stream != null) {
            InetSocketAddress[] streamTargetAddresses = new InetSocketAddress[COMPONENT_IDS.length];
            int streamTargetAddressCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                TransportAddress streamTargetAddress;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamTargetAddress = selectedPair.getRemoteCandidate().getTransportAddress()) == null) continue;
                streamTargetAddresses[i] = streamTargetAddress;
                ++streamTargetAddressCount;
            }
            if (streamTargetAddressCount > 0) {
                streamTarget = new MediaStreamTarget(streamTargetAddresses[0], streamTargetAddresses[1]);
            }
        }
        return streamTarget;
    }

    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:ice-udp:1";
    }

    public synchronized boolean startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        String password;
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState());
        boolean startConnectivityEstablishment = false;
        List candidates = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && candidates.size() == 0) {
            return false;
        }
        Collections.sort(candidates);
        String media = this.getChannel().getContent().getName();
        IceMediaStream stream = this.iceAgent.getStream(media);
        String ufrag = transport.getUfrag();
        if (ufrag != null) {
            stream.setRemoteUfrag(ufrag);
        }
        if ((password = transport.getPassword()) != null) {
            stream.setRemotePassword(password);
        }
        int generation = this.iceAgent.getGeneration();
        for (CandidatePacketExtension candidate : candidates) {
            int relPort;
            if (candidate.getGeneration() != generation) continue;
            Component component = stream.getComponent(candidate.getComponent());
            TransportAddress relatedAddress = null;
            String relAddr = candidate.getRelAddr();
            if (relAddr != null && (relPort = candidate.getRelPort()) != -1) {
                relatedAddress = new TransportAddress(relAddr, relPort, Transport.parse((String)candidate.getProtocol()));
            }
            RemoteCandidate relatedCandidate = component.findRemoteCandidate(relatedAddress);
            RemoteCandidate remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse((String)candidate.getProtocol())), component, org.ice4j.ice.CandidateType.parse((String)candidate.getType().toString()), candidate.getFoundation(), (long)candidate.getPriority(), relatedCandidate);
            if (iceAgentStateIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
                continue;
            }
            component.addRemoteCandidate(remoteCandidate);
            startConnectivityEstablishment = true;
        }
        if (iceAgentStateIsRunning) {
            for (IceMediaStream stream2 : this.iceAgent.getStreams()) {
                for (Component component : stream2.getComponents()) {
                    component.updateRemoteCandidates();
                }
            }
        } else if (startConnectivityEstablishment) {
            for (IceMediaStream stream2 : this.iceAgent.getStreams()) {
                for (Component component : stream2.getComponents()) {
                    if (component.getRemoteCandidateCount() >= 1) continue;
                    startConnectivityEstablishment = false;
                    break;
                }
                if (startConnectivityEstablishment) continue;
                break;
            }
            if (startConnectivityEstablishment) {
                this.iceAgent.startConnectivityEstablishment();
            }
        }
        return iceAgentStateIsRunning || startConnectivityEstablishment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapupConnectivityEstablishment() throws OperationFailedException {
        final Object syncRoot = new Object();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent ev) {
                Object newValue = ev.getNewValue();
                if (IceProcessingState.COMPLETED.equals(newValue) || IceProcessingState.FAILED.equals(newValue) || IceProcessingState.TERMINATED.equals(newValue)) {
                    Agent iceAgent = (Agent)ev.getSource();
                    iceAgent.removeStateChangeListener((PropertyChangeListener)this);
                    if (iceAgent == IceUdpTransportManager.this.iceAgent) {
                        Object object = syncRoot;
                        synchronized (object) {
                            syncRoot.notify();
                        }
                    }
                }
            }
        };
        this.iceAgent.addStateChangeListener(propertyChangeListener);
        boolean interrupted = false;
        Object object = syncRoot;
        synchronized (object) {
            while (IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState())) {
                try {
                    syncRoot.wait(1000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.iceAgent.removeStateChangeListener(propertyChangeListener);
        if (IceProcessingState.FAILED.equals((Object)this.iceAgent.getState())) {
            throw new OperationFailedException("Could not establish connection (ICE failed)", 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JitsiTransportManager
    extends net.java.sip.communicator.service.protocol.media.TransportManager<MediaAwareCallPeer<?, ?, ?>> {
        public static PortTracker getPortTracker(MediaType mediaType) {
            return net.java.sip.communicator.service.protocol.media.TransportManager.getPortTracker((MediaType)mediaType);
        }

        private JitsiTransportManager(MediaAwareCallPeer<?, ?, ?> callPeer) {
            super(callPeer);
        }

        public long getHarvestingTime(String arg0) {
            return 0L;
        }

        public String getICECandidateExtendedType(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalRelayedAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteRelayedAddress(String arg0) {
            return null;
        }

        public String getICEState() {
            return null;
        }

        protected InetAddress getIntendedDestination(MediaAwareCallPeer<?, ?, ?> arg0) {
            return null;
        }

        public int getNbHarvesting() {
            return 0;
        }

        public int getNbHarvesting(String arg0) {
            return 0;
        }

        public long getTotalHarvestingTime() {
            return 0L;
        }
    }
}

