/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.packet.VCard;

public class InfoRetreiver {
    private static final Logger logger = Logger.getLogger(InfoRetreiver.class);
    private ProtocolProviderServiceJabberImpl jabberProvider = null;
    private final Map<String, List<ServerStoredDetails.GenericDetail>> retreivedDetails = new Hashtable<String, List<ServerStoredDetails.GenericDetail>>();
    private static final String TAG_FN_OPEN = "<FN>";
    private static final String TAG_FN_CLOSE = "</FN>";
    private final long vcardTimeoutReply;

    protected InfoRetreiver(ProtocolProviderServiceJabberImpl jabberProvider, String ownerUin) {
        this.jabberProvider = jabberProvider;
        this.vcardTimeoutReply = JabberActivator.getConfigurationService().getLong("net.java.sip.communicator.impl.protocol.jabber.VCARD_REPLY_TIMEOUT", -1L);
    }

    <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(String uin, Class<T> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.getContactDetails(uin);
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.isInstance(item)) continue;
            ServerStoredDetails.GenericDetail t = item;
            result.add(t);
        }
        return result.iterator();
    }

    Iterator<ServerStoredDetails.GenericDetail> getDetails(String uin, Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.getContactDetails(uin);
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.equals(item.getClass())) continue;
            result.add(item);
        }
        return result.iterator();
    }

    List<ServerStoredDetails.GenericDetail> getContactDetails(String contactAddress) {
        List<ServerStoredDetails.GenericDetail> result = this.getCachedContactDetails(contactAddress);
        if (result == null) {
            return this.retrieveDetails(contactAddress);
        }
        return result;
    }

    protected List<ServerStoredDetails.GenericDetail> retrieveDetails(String contactAddress) {
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        try {
            byte[] imageBytes;
            XMPPConnection connection = this.jabberProvider.getConnection();
            if (connection == null || !connection.isAuthenticated()) {
                return null;
            }
            VCard card = new VCard();
            if (this.vcardTimeoutReply == -1L || this.vcardTimeoutReply == (long)SmackConfiguration.getPacketReplyTimeout()) {
                card.load((Connection)connection, contactAddress);
            } else {
                this.load(card, (Connection)connection, contactAddress, this.vcardTimeoutReply);
            }
            String tmp = this.checkForFullName(card);
            if (tmp != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.DisplayNameDetail(tmp));
            }
            if ((tmp = card.getFirstName()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.FirstNameDetail(tmp));
            }
            if ((tmp = card.getMiddleName()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.MiddleNameDetail(tmp));
            }
            if ((tmp = card.getLastName()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.LastNameDetail(tmp));
            }
            if ((tmp = card.getNickName()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.NicknameDetail(tmp));
            }
            if ((tmp = card.getField("BDAY")) != null) {
                try {
                    Calendar birthDateCalendar = Calendar.getInstance();
                    SimpleDateFormat dateFormat = new SimpleDateFormat(JabberActivator.getResources().getI18NString("plugin.accountinfo.BDAY_FORMAT"));
                    Date birthDate = dateFormat.parse(tmp);
                    birthDateCalendar.setTime(birthDate);
                    ServerStoredDetails.BirthDateDetail bd = new ServerStoredDetails.BirthDateDetail(birthDateCalendar);
                    result.add((ServerStoredDetails.GenericDetail)bd);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if ((tmp = card.getAddressFieldHome("STREET")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.AddressDetail(tmp));
            }
            if ((tmp = card.getAddressFieldHome("LOCALITY")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.CityDetail(tmp));
            }
            if ((tmp = card.getAddressFieldHome("REGION")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ProvinceDetail(tmp));
            }
            if ((tmp = card.getAddressFieldHome("PCODE")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PostalCodeDetail(tmp));
            }
            if ((tmp = card.getAddressFieldHome("CTRY")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.CountryDetail(tmp));
            }
            if ((tmp = card.getPhoneHome("VOICE")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PhoneNumberDetail(tmp));
            }
            if ((tmp = card.getPhoneHome("VIDEO")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.VideoDetail(tmp));
            }
            if ((tmp = card.getPhoneHome("FAX")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.FaxDetail(tmp));
            }
            if ((tmp = card.getPhoneHome("PAGER")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PagerDetail(tmp));
            }
            if ((tmp = card.getPhoneHome("CELL")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.MobilePhoneDetail(tmp));
            }
            if ((tmp = card.getEmailHome()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.EmailAddressDetail(tmp));
            }
            if ((tmp = card.getAddressFieldWork("STREET")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkAddressDetail(tmp));
            }
            if ((tmp = card.getAddressFieldWork("LOCALITY")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkCityDetail(tmp));
            }
            if ((tmp = card.getAddressFieldWork("REGION")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkProvinceDetail(tmp));
            }
            if ((tmp = card.getAddressFieldWork("PCODE")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkPostalCodeDetail(tmp));
            }
            if ((tmp = card.getPhoneWork("VOICE")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkPhoneDetail(tmp));
            }
            if ((tmp = card.getPhoneWork("VIDEO")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkVideoDetail(tmp));
            }
            if ((tmp = card.getPhoneWork("FAX")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new WorkFaxDetail(tmp));
            }
            if ((tmp = card.getPhoneWork("PAGER")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new WorkPagerDetail(tmp));
            }
            if ((tmp = card.getPhoneWork("CELL")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkMobilePhoneDetail(tmp));
            }
            if ((tmp = card.getEmailWork()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkEmailAddressDetail(tmp));
            }
            if ((tmp = card.getOrganization()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkOrganizationNameDetail(tmp));
            }
            if ((tmp = card.getOrganizationUnit()) != null) {
                result.add((ServerStoredDetails.GenericDetail)new WorkDepartmentNameDetail(tmp));
            }
            if ((tmp = card.getField("TITLE")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.JobTitleDetail(tmp));
            }
            if ((tmp = card.getField("ABOUTME")) != null) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.AboutMeDetail(tmp));
            }
            if ((imageBytes = card.getAvatar()) != null && imageBytes.length > 0) {
                result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ImageDetail("Image", imageBytes));
            }
            try {
                tmp = card.getField("URL");
                if (tmp != null) {
                    result.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.URLDetail("URL", new URL(tmp)));
                }
            }
            catch (MalformedURLException e) {}
        }
        catch (Throwable exc) {
            String msg = "Cannot load details for contact " + contactAddress + " : " + exc.getMessage();
            if (logger.isTraceEnabled()) {
                logger.error((Object)msg, exc);
            }
            logger.error((Object)msg);
        }
        this.retreivedDetails.put(contactAddress, result);
        return result;
    }

    List<ServerStoredDetails.GenericDetail> getCachedContactDetails(String contactAddress) {
        return this.retreivedDetails.get(contactAddress);
    }

    void addCachedContactDetails(String contactAddress, List<ServerStoredDetails.GenericDetail> details) {
        this.retreivedDetails.put(contactAddress, details);
    }

    private String checkForFullName(VCard card) {
        String vcardXml = card.toXML();
        int indexOpen = vcardXml.indexOf(TAG_FN_OPEN);
        if (indexOpen == -1) {
            return null;
        }
        int indexClose = vcardXml.indexOf(TAG_FN_CLOSE, indexOpen);
        if (indexClose == -1) {
            return null;
        }
        return vcardXml.substring(indexOpen + TAG_FN_OPEN.length(), indexClose);
    }

    public void load(VCard vcard, Connection connection, String user, long timeout) throws XMPPException {
        Field[] fields;
        vcard.setTo(user);
        vcard.setType(IQ.Type.GET);
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(vcard.getPacketID()));
        connection.sendPacket((Packet)vcard);
        VCard result = null;
        try {
            result = (VCard)collector.nextResult(timeout);
            if (result == null) {
                String errorMessage = "Timeout getting VCard information";
                throw new XMPPException(errorMessage, new XMPPError(XMPPError.Condition.request_timeout, errorMessage));
            }
            if (result.getError() != null) {
                throw new XMPPException(result.getError());
            }
        }
        catch (ClassCastException e) {
            logger.error((Object)("No vcard for " + user));
        }
        if (result == null) {
            result = new VCard();
        }
        for (Field field : fields = VCard.class.getDeclaredFields()) {
            if (field.getDeclaringClass() != VCard.class || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(vcard, field.get(result));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot set field:" + field, e);
            }
        }
    }

    public static class WorkPagerDetail
    extends ServerStoredDetails.PhoneNumberDetail {
        public WorkPagerDetail(String number) {
            super(number);
            this.detailDisplayName = "WorkPager";
        }
    }

    public static class WorkFaxDetail
    extends ServerStoredDetails.FaxDetail {
        public WorkFaxDetail(String number) {
            super(number);
            this.detailDisplayName = "WorkFax";
        }
    }

    public static class WorkDepartmentNameDetail
    extends ServerStoredDetails.NameDetail {
        public WorkDepartmentNameDetail(String workDepartmentName) {
            super("Work Department Name", workDepartmentName);
        }
    }
}

