/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetAutoAnswerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStreamConnector;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JinglePacketFactory;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.media.MediaHandler;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.StreamConnectorFactory;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class CallJabberImpl
extends AbstractCallJabberGTalkImpl<CallPeerJabberImpl> {
    private static final Logger logger = Logger.getLogger(CallJabberImpl.class);
    private ColibriConferenceIQ colibri;
    private MediaHandler colibriMediaHandler;
    private final List<WeakReference<ColibriStreamConnector>> colibriStreamConnectors;
    private String jitsiVideobridge;

    protected CallJabberImpl(OperationSetBasicTelephonyJabberImpl parentOpSet) {
        super(parentOpSet);
        int mediaTypeValueCount = MediaType.values().length;
        this.colibriStreamConnectors = new ArrayList<WeakReference<ColibriStreamConnector>>(mediaTypeValueCount);
        for (int i = 0; i < mediaTypeValueCount; ++i) {
            this.colibriStreamConnectors.add(null);
        }
        parentOpSet.getActiveCallsRepository().addCall((Call)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeColibriStreamConnector(CallPeerJabberImpl peer, MediaType mediaType, ColibriStreamConnector colibriStreamConnector) {
        colibriStreamConnector.close();
        List<WeakReference<ColibriStreamConnector>> list = this.colibriStreamConnectors;
        synchronized (list) {
            int index = mediaType.ordinal();
            WeakReference<ColibriStreamConnector> weakReference = this.colibriStreamConnectors.get(index);
            if (weakReference != null && ((Object)((Object)colibriStreamConnector)).equals(weakReference.get())) {
                this.colibriStreamConnectors.set(index, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        try {
            Iterator peers = this.getCallPeers();
            while (peers.hasNext()) {
                CallPeerJabberImpl callPeer = (CallPeerJabberImpl)((Object)peers.next());
                if (callPeer.getState() != CallPeerState.CONNECTED) continue;
                callPeer.sendCoinSessionInfo();
            }
        }
        finally {
            super.conferenceFocusChanged(oldValue, newValue);
        }
    }

    public ColibriConferenceIQ createColibriChannels(CallPeerJabberImpl peer, Map<ContentPacketExtension, ContentPacketExtension> contentMap) throws OperationFailedException {
        String colibriID;
        String contentName;
        String jitsiVideobridge;
        if (!this.getConference().isJitsiVideobridge()) {
            return null;
        }
        CallPeerMediaHandlerJabberImpl peerMediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler();
        if (peerMediaHandler.getMediaHandler() != this.colibriMediaHandler) {
            for (MediaType mediaType : MediaType.values()) {
                if (peerMediaHandler.getStream(mediaType) == null) continue;
                return null;
            }
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        String string = jitsiVideobridge = this.colibri == null ? this.getJitsiVideobridge() : this.colibri.getFrom();
        if (jitsiVideobridge == null || jitsiVideobridge.length() == 0) {
            logger.error((Object)"Failed to allocate colibri channels: no videobridge found.");
            return null;
        }
        if (this.colibriMediaHandler == null) {
            this.colibriMediaHandler = new MediaHandler();
        }
        peerMediaHandler.setMediaHandler(this.colibriMediaHandler);
        ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
        if (this.colibri != null) {
            conferenceRequest.setID(this.colibri.getID());
        }
        for (Map.Entry<ContentPacketExtension, ContentPacketExtension> e : contentMap.entrySet()) {
            ColibriConferenceIQ.Content content;
            ContentPacketExtension localContent = e.getKey();
            ContentPacketExtension remoteContent = e.getValue();
            ContentPacketExtension cpe = remoteContent == null ? localContent : remoteContent;
            RtpDescriptionPacketExtension rdpe = cpe.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            String media = rdpe.getMedia();
            MediaType mediaType = MediaType.parseString((String)media);
            contentName = mediaType.toString();
            ColibriConferenceIQ.Content contentRequest = new ColibriConferenceIQ.Content(contentName);
            conferenceRequest.addContent(contentRequest);
            boolean requestLocalChannel = true;
            if (this.colibri != null && (content = this.colibri.getContent(contentName)) != null && content.getChannelCount() > 0) {
                requestLocalChannel = false;
            }
            boolean peerIsInitiator = peer.isInitiator();
            if (requestLocalChannel) {
                ColibriConferenceIQ.Channel localChannelRequest = new ColibriConferenceIQ.Channel();
                localChannelRequest.setInitiator(peerIsInitiator);
                for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                    localChannelRequest.addPayloadType(ptpe);
                }
                this.setTransportOnChannel(peer, media, localChannelRequest);
                this.setDtlsEncryptionOnChannel(jitsiVideobridge, peer, mediaType, localChannelRequest);
                this.ensureTransportOnChannel(localChannelRequest, peer);
                contentRequest.addChannel(localChannelRequest);
            }
            ColibriConferenceIQ.Channel remoteChannelRequest = new ColibriConferenceIQ.Channel();
            remoteChannelRequest.setInitiator(!peerIsInitiator);
            for (PayloadTypePacketExtension ptpe : rdpe.getPayloadTypes()) {
                remoteChannelRequest.addPayloadType(ptpe);
            }
            this.setTransportOnChannel(media, localContent, remoteContent, peer, remoteChannelRequest);
            this.setDtlsEncryptionOnChannel(mediaType, localContent, remoteContent, peer, remoteChannelRequest);
            this.ensureTransportOnChannel(remoteChannelRequest, peer);
            contentRequest.addChannel(remoteChannelRequest);
        }
        XMPPConnection connection = protocolProvider.getConnection();
        PacketCollector packetCollector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(conferenceRequest.getPacketID()));
        conferenceRequest.setTo(jitsiVideobridge);
        conferenceRequest.setType(IQ.Type.GET);
        connection.sendPacket((Packet)conferenceRequest);
        Packet response = packetCollector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (response == null) {
            logger.error((Object)"Failed to allocate colibri channels: response is null. Maybe the response timed out.");
            return null;
        }
        if (response.getError() != null) {
            logger.error((Object)("Failed to allocate colibri channels: " + response.getError()));
            return null;
        }
        if (!(response instanceof ColibriConferenceIQ)) {
            logger.error((Object)"Failed to allocate colibri channels: response is not a colibri conference");
            return null;
        }
        ColibriConferenceIQ conferenceResponse = (ColibriConferenceIQ)response;
        String conferenceResponseID = conferenceResponse.getID();
        if (this.colibri == null) {
            this.colibri = new ColibriConferenceIQ();
            this.colibri.setFrom(conferenceResponse.getFrom());
        }
        if ((colibriID = this.colibri.getID()) == null) {
            this.colibri.setID(conferenceResponseID);
        } else if (!colibriID.equals(conferenceResponseID)) {
            throw new IllegalStateException("conference.id");
        }
        for (ColibriConferenceIQ.Content content : conferenceResponse.getContents()) {
            contentName = content.getName();
            ColibriConferenceIQ.Content content2 = this.colibri.getOrCreateContent(contentName);
            for (ColibriConferenceIQ.Channel channelResponse : content.getChannels()) {
                int channelIndex = content2.getChannelCount();
                content2.addChannel(channelResponse);
                if (channelIndex != 0) continue;
                TransportManagerJabberImpl transportManager = peerMediaHandler.getTransportManager();
                transportManager.isEstablishingConnectivityWithJitsiVideobridge = true;
                transportManager.startConnectivityEstablishmentWithJitsiVideobridge = true;
                MediaType mediaType = MediaType.parseString((String)contentName);
                this.addDtlsAdvertisedEncryptions(peer, channelResponse, mediaType);
            }
        }
        ColibriConferenceIQ conferenceResult = new ColibriConferenceIQ();
        conferenceResult.setFrom(this.colibri.getFrom());
        conferenceResult.setID(conferenceResponseID);
        for (Map.Entry entry : contentMap.entrySet()) {
            ContentPacketExtension localContent = (ContentPacketExtension)entry.getKey();
            ContentPacketExtension remoteContent = (ContentPacketExtension)entry.getValue();
            ContentPacketExtension cpe = remoteContent == null ? localContent : remoteContent;
            RtpDescriptionPacketExtension rdpe = cpe.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            MediaType mediaType = MediaType.parseString((String)rdpe.getMedia());
            ColibriConferenceIQ.Content contentResponse = conferenceResponse.getContent(mediaType.toString());
            if (contentResponse == null) continue;
            String contentName2 = contentResponse.getName();
            ColibriConferenceIQ.Content contentResult = new ColibriConferenceIQ.Content(contentName2);
            conferenceResult.addContent(contentResult);
            ColibriConferenceIQ.Content content = this.colibri.getContent(contentName2);
            ColibriConferenceIQ.Channel localChannel = null;
            if (content != null && content.getChannelCount() > 0) {
                localChannel = content.getChannel(0);
                contentResult.addChannel(localChannel);
            }
            String localChannelID = localChannel == null ? null : localChannel.getID();
            for (ColibriConferenceIQ.Channel channelResponse : contentResponse.getChannels()) {
                if (localChannelID != null && localChannelID.equals(channelResponse.getID())) continue;
                contentResult.addChannel(channelResponse);
            }
        }
        return conferenceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColibriStreamConnector createColibriStreamConnector(CallPeerJabberImpl peer, MediaType mediaType, ColibriConferenceIQ.Channel channel, StreamConnectorFactory factory) {
        ColibriStreamConnector colibriStreamConnector;
        String channelID = channel.getID();
        if (channelID == null) {
            throw new IllegalArgumentException("channel");
        }
        if (this.colibri == null) {
            throw new IllegalStateException("colibri");
        }
        ColibriConferenceIQ.Content content = this.colibri.getContent(mediaType.toString());
        if (content == null) {
            throw new IllegalArgumentException("mediaType");
        }
        if (content.getChannelCount() < 1 || !channelID.equals((channel = content.getChannel(0)).getID())) {
            throw new IllegalArgumentException("channel");
        }
        List<WeakReference<ColibriStreamConnector>> list = this.colibriStreamConnectors;
        synchronized (list) {
            StreamConnector streamConnector;
            int index = mediaType.ordinal();
            WeakReference<ColibriStreamConnector> weakReference = this.colibriStreamConnectors.get(index);
            ColibriStreamConnector colibriStreamConnector2 = colibriStreamConnector = weakReference == null ? null : (ColibriStreamConnector)((Object)weakReference.get());
            if (colibriStreamConnector == null && (streamConnector = factory.createStreamConnector()) != null) {
                colibriStreamConnector = new ColibriStreamConnector(streamConnector);
                this.colibriStreamConnectors.set(index, new WeakReference<ColibriStreamConnector>(colibriStreamConnector));
            }
        }
        return colibriStreamConnector;
    }

    public void expireColibriChannels(CallPeerJabberImpl peer, ColibriConferenceIQ conference) {
        String conferenceID;
        if (this.colibri != null && (conferenceID = this.colibri.getID()).equals(conference.getID())) {
            ColibriConferenceIQ.Content colibriContent;
            ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
            conferenceRequest.setID(conferenceID);
            for (ColibriConferenceIQ.Content content : conference.getContents()) {
                colibriContent = this.colibri.getContent(content.getName());
                if (colibriContent == null) continue;
                ColibriConferenceIQ.Content contentRequest = conferenceRequest.getOrCreateContent(colibriContent.getName());
                for (ColibriConferenceIQ.Channel channel : content.getChannels()) {
                    ColibriConferenceIQ.Channel colibriChannel = colibriContent.getChannel(channel.getID());
                    if (colibriChannel == null) continue;
                    ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
                    channelRequest.setExpire(0);
                    channelRequest.setID(colibriChannel.getID());
                    contentRequest.addChannel(channelRequest);
                }
            }
            block2: for (ColibriConferenceIQ.Content contentRequest : conferenceRequest.getContents()) {
                colibriContent = this.colibri.getContent(contentRequest.getName());
                for (ColibriConferenceIQ.Channel channelRequest : contentRequest.getChannels()) {
                    ColibriConferenceIQ.Channel colibriChannel = colibriContent.getChannel(channelRequest.getID());
                    colibriContent.removeChannel(colibriChannel);
                    if (colibriContent.getChannelCount() != 1) continue;
                    colibriChannel = colibriContent.getChannel(0);
                    channelRequest = new ColibriConferenceIQ.Channel();
                    channelRequest.setExpire(0);
                    channelRequest.setID(colibriChannel.getID());
                    contentRequest.addChannel(channelRequest);
                    colibriContent.removeChannel(colibriChannel);
                    continue block2;
                }
            }
            conferenceRequest.setTo(this.colibri.getFrom());
            conferenceRequest.setType(IQ.Type.SET);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)conferenceRequest);
        }
    }

    public void setChannelDirection(String channelID, MediaType mediaType, MediaDirection direction) {
        ColibriConferenceIQ.Channel channel;
        ColibriConferenceIQ.Content content;
        if (this.colibri != null && channelID != null && (content = this.colibri.getContent(mediaType.toString())) != null && (channel = content.getChannel(channelID)) != null) {
            ColibriConferenceIQ.Channel requestChannel = new ColibriConferenceIQ.Channel();
            requestChannel.setID(channelID);
            requestChannel.setDirection(direction);
            ColibriConferenceIQ.Content requestContent = new ColibriConferenceIQ.Content();
            requestContent.setName(mediaType.toString());
            requestContent.addChannel(requestChannel);
            ColibriConferenceIQ conferenceRequest = new ColibriConferenceIQ();
            conferenceRequest.setID(this.colibri.getID());
            conferenceRequest.setTo(this.colibri.getFrom());
            conferenceRequest.setType(IQ.Type.SET);
            conferenceRequest.addContent(requestContent);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)conferenceRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallPeerJabberImpl initiateSession(String calleeJID, DiscoverInfo discoverInfo, Iterable<PacketExtension> sessionInitiateExtensions, Collection<String> supportedTransports) throws OperationFailedException {
        CallPeerJabberImpl callPeer = new CallPeerJabberImpl(calleeJID, this);
        callPeer.setDiscoveryInfo(discoverInfo);
        this.addCallPeer(callPeer);
        callPeer.setState(CallPeerState.INITIATING_CALL);
        if (this.getCallPeerCount() == 1) {
            ((OperationSetBasicTelephonyJabberImpl)this.parentOpSet).fireCallEvent(1, (Call)this);
        }
        CallPeerMediaHandlerJabberImpl mediaHandler = (CallPeerMediaHandlerJabberImpl)callPeer.getMediaHandler();
        mediaHandler.setSupportedTransports(supportedTransports);
        mediaHandler.setLocalVideoTransmissionEnabled(this.localVideoAllowed);
        mediaHandler.setLocalInputEvtAware(this.getLocalInputEvtAware());
        callPeer.setState(CallPeerState.CONNECTING);
        boolean sessionInitiated = false;
        try {
            callPeer.initiateSession(sessionInitiateExtensions);
            sessionInitiated = true;
        }
        finally {
            if (!sessionInitiated) {
                callPeer.setState(CallPeerState.FAILED);
            }
        }
        return callPeer;
    }

    @Override
    public void modifyVideoContent() throws OperationFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating video content for " + (Object)((Object)this)));
        }
        boolean change = false;
        for (CallPeerJabberImpl peer : this.getCallPeerList()) {
            change |= peer.sendModifyVideoContent();
        }
        if (change) {
            this.fireCallChangeEvent("CallParticipantsChanged", null, null);
        }
    }

    boolean processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        if (this.colibri == null) {
            return false;
        }
        if (conferenceIQ.getID().equals(this.colibri.getID())) {
            for (MediaType mediaType : MediaType.values()) {
                ColibriConferenceIQ.Channel thisChannel;
                ColibriConferenceIQ.Channel channel;
                ColibriConferenceIQ.Content thisContent;
                String contentName = mediaType.toString();
                ColibriConferenceIQ.Content content = conferenceIQ.getContent(contentName);
                if (content == null || (thisContent = this.colibri.getContent(contentName)) == null || thisContent.getChannelCount() <= 0 || (channel = content.getChannel((thisChannel = thisContent.getChannel(0)).getID())) == null) continue;
                content.removeChannel(channel);
            }
            for (CallPeerJabberImpl callPeer : this.getCallPeerList()) {
                callPeer.processColibriConferenceIQ(conferenceIQ);
            }
            return true;
        }
        return false;
    }

    public CallPeerJabberImpl processSessionInitiate(JingleIQ jingleIQ) {
        OperationSetAutoAnswerJabberImpl autoAnswerOpSet;
        CallPeerJabberImpl callPeer;
        OperationSetBasicTelephonyJabberImpl basicTelephony;
        CallPeerJabberImpl attendant;
        boolean autoAnswer;
        block16: {
            String remoteParty = jingleIQ.getInitiator();
            autoAnswer = false;
            attendant = null;
            basicTelephony = null;
            if (remoteParty == null) {
                remoteParty = jingleIQ.getFrom();
            }
            callPeer = new CallPeerJabberImpl(remoteParty, this, jingleIQ);
            this.addCallPeer(callPeer);
            try {
                ProtocolProviderServiceJabberImpl protocolProvider;
                CallJabberImpl attendantCall;
                String sid;
                TransferPacketExtension transfer = (TransferPacketExtension)jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
                if (transfer != null && (sid = transfer.getSID()) != null && (attendantCall = (basicTelephony = (OperationSetBasicTelephonyJabberImpl)(protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicTelephony.class)).getActiveCallsRepository().findSID(sid)) != null && (attendant = (CallPeerJabberImpl)((Object)attendantCall.getPeer(sid))) != null && basicTelephony.getFullCalleeURI(attendant.getAddress()).equals(transfer.getFrom()) && protocolProvider.getOurJID().equals(transfer.getTo())) {
                    autoAnswer = true;
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Failed to hang up on attendant as part of session transfer", t);
                if (!(t instanceof ThreadDeath)) break block16;
                throw (ThreadDeath)t;
            }
        }
        CoinPacketExtension coin = (CoinPacketExtension)jingleIQ.getExtension("conference-info", "");
        if (coin != null) {
            boolean b = Boolean.parseBoolean((String)coin.getAttribute("isfocus"));
            callPeer.setConferenceFocus(b);
        }
        callPeer.processSessionInitiate(jingleIQ);
        if (((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getAccountID().getAccountPropertyBoolean((Object)"MODE_PARANOIA", false) && ((CallPeerMediaHandlerJabberImpl)callPeer.getMediaHandler()).getAdvertisedEncryptionMethods().length == 0) {
            String reasonText = JabberActivator.getResources().getI18NString("service.gui.security.encryption.required");
            JingleIQ errResp = JinglePacketFactory.createSessionTerminate(jingleIQ.getTo(), jingleIQ.getFrom(), jingleIQ.getSID(), Reason.SECURITY_ERROR, reasonText);
            callPeer.setState(CallPeerState.FAILED, reasonText);
            ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getConnection().sendPacket((Packet)errResp);
            return null;
        }
        if (callPeer.getState() == CallPeerState.FAILED) {
            return null;
        }
        callPeer.setState(CallPeerState.INCOMING_CALL);
        if (autoAnswer) {
            try {
                callPeer.answer();
            }
            catch (Exception e) {
                logger.info((Object)"Exception occurred while answer transferred call", (Throwable)e);
                callPeer = null;
            }
            try {
                basicTelephony.hangupCallPeer((CallPeer)attendant);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"Failed to hang up on attendant as part of session transfer", (Throwable)e);
            }
            return callPeer;
        }
        List<ContentPacketExtension> offer = callPeer.getSessionIQ().getContentList();
        HashMap<MediaType, MediaDirection> directions = new HashMap<MediaType, MediaDirection>();
        directions.put(MediaType.AUDIO, MediaDirection.INACTIVE);
        directions.put(MediaType.VIDEO, MediaDirection.INACTIVE);
        for (ContentPacketExtension c : offer) {
            String contentName = c.getName();
            MediaDirection remoteDirection = JingleUtils.getDirection(c, callPeer.isInitiator());
            if (MediaType.AUDIO.toString().equals(contentName)) {
                directions.put(MediaType.AUDIO, remoteDirection);
                continue;
            }
            if (!MediaType.VIDEO.toString().equals(contentName)) continue;
            directions.put(MediaType.VIDEO, remoteDirection);
        }
        if (this.getCallPeerCount() == 1) {
            ((OperationSetBasicTelephonyJabberImpl)this.parentOpSet).fireCallEvent(2, (Call)this, directions);
        }
        if ((autoAnswerOpSet = (OperationSetAutoAnswerJabberImpl)((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getOperationSet(OperationSetBasicAutoAnswer.class)) != null) {
            autoAnswerOpSet.autoAnswer((Call)this, directions);
        }
        return callPeer;
    }

    private boolean addDtlsAdvertisedEncryptions(CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel, MediaType mediaType) {
        CallPeerMediaHandlerJabberImpl peerMediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler();
        DtlsControl dtlsControl = (DtlsControl)peerMediaHandler.getSrtpControls().get(mediaType, SrtpControlType.DTLS_SRTP);
        if (dtlsControl != null) {
            dtlsControl.setDtlsProtocol(1);
        }
        IceUdpTransportPacketExtension remoteTransport = channel.getTransport();
        return peerMediaHandler.addDtlsAdvertisedEncryptions(true, remoteTransport, mediaType);
    }

    private void setDtlsEncryptionOnChannel(MediaType mediaType, ContentPacketExtension localContent, ContentPacketExtension remoteContent, CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel) {
        List<DtlsFingerprintPacketExtension> localFingerprints;
        IceUdpTransportPacketExtension localTransport;
        List<DtlsFingerprintPacketExtension> remoteFingerprints;
        IceUdpTransportPacketExtension remoteTransport;
        AccountID accountID = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getAccountID();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME) && remoteContent != null && (remoteTransport = remoteContent.getFirstChildOfType(IceUdpTransportPacketExtension.class)) != null && !(remoteFingerprints = remoteTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty() && (localTransport = this.ensureTransportOnChannel(channel, peer)) != null && (localFingerprints = localTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty()) {
            for (DtlsFingerprintPacketExtension remoteFingerprint : remoteFingerprints) {
                DtlsFingerprintPacketExtension localFingerprint = new DtlsFingerprintPacketExtension();
                localFingerprint.setFingerprint(remoteFingerprint.getFingerprint());
                localFingerprint.setHash(remoteFingerprint.getHash());
                localTransport.addChildExtension(localFingerprint);
            }
        }
    }

    private void setDtlsEncryptionOnChannel(String jitsiVideobridge, CallPeerJabberImpl peer, MediaType mediaType, ColibriConferenceIQ.Channel channel) {
        IceUdpTransportPacketExtension transport;
        CallPeerMediaHandlerJabberImpl mediaHandler;
        DtlsControl dtlsControl;
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)this.getProtocolProvider();
        AccountID accountID = protocolProvider.getAccountID();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME) && protocolProvider.isFeatureSupported(jitsiVideobridge, "urn:xmpp:jingle:apps:dtls:0") && (dtlsControl = (DtlsControl)(mediaHandler = (CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getSrtpControls().getOrCreate(mediaType, SrtpControlType.DTLS_SRTP)) != null && (transport = this.ensureTransportOnChannel(channel, peer)) != null) {
            CallJabberImpl.setDtlsEncryptionOnTransport(dtlsControl, transport);
        }
    }

    static void setDtlsEncryptionOnTransport(DtlsControl dtlsControl, IceUdpTransportPacketExtension localTransport) {
        String fingerprint = dtlsControl.getLocalFingerprint();
        String hash = dtlsControl.getLocalFingerprintHashFunction();
        DtlsFingerprintPacketExtension fingerprintPE = localTransport.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (fingerprintPE == null) {
            fingerprintPE = new DtlsFingerprintPacketExtension();
            localTransport.addChildExtension(fingerprintPE);
        }
        fingerprintPE.setFingerprint(fingerprint);
        fingerprintPE.setHash(hash);
    }

    private void setTransportOnChannel(CallPeerJabberImpl peer, String media, ColibriConferenceIQ.Channel channel) throws OperationFailedException {
        PacketExtension transport = ((CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getTransportManager().createTransport(media);
        if (transport instanceof IceUdpTransportPacketExtension) {
            channel.setTransport((IceUdpTransportPacketExtension)transport);
        }
    }

    private void setTransportOnChannel(String media, ContentPacketExtension localContent, ContentPacketExtension remoteContent, CallPeerJabberImpl peer, ColibriConferenceIQ.Channel channel) throws OperationFailedException {
        if (remoteContent != null) {
            IceUdpTransportPacketExtension transport = remoteContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            channel.setTransport(TransportManagerJabberImpl.cloneTransportAndCandidates(transport));
        }
    }

    private IceUdpTransportPacketExtension ensureTransportOnChannel(ColibriConferenceIQ.Channel channel, CallPeerJabberImpl peer) {
        PacketExtension pe;
        IceUdpTransportPacketExtension transport = channel.getTransport();
        if (transport == null && (pe = ((CallPeerMediaHandlerJabberImpl)peer.getMediaHandler()).getTransportManager().createTransportPacketExtension()) instanceof IceUdpTransportPacketExtension) {
            transport = (IceUdpTransportPacketExtension)pe;
            channel.setTransport(transport);
        }
        return transport;
    }

    public String getJitsiVideobridge() {
        String jitsiVideobridge;
        if (this.jitsiVideobridge == null && this.getConference().isJitsiVideobridge() && (jitsiVideobridge = ((ProtocolProviderServiceJabberImpl)this.getProtocolProvider()).getJitsiVideobridge()) != null) {
            this.jitsiVideobridge = jitsiVideobridge;
        }
        return this.jitsiVideobridge;
    }
}

