/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.SrtpControl;

public class DtlsTransformEngine
implements SrtpControl.TransformEngine {
    private AbstractRTPConnector connector;
    private final DtlsControlImpl dtlsControl;
    private int dtlsProtocol;
    private MediaType mediaType;
    private final DtlsPacketTransformer[] packetTransformers = new DtlsPacketTransformer[2];

    public DtlsTransformEngine(DtlsControlImpl dtlsControl) {
        this.dtlsControl = dtlsControl;
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.packetTransformers.length; ++i) {
            DtlsPacketTransformer packetTransformer = this.packetTransformers[i];
            if (packetTransformer == null) continue;
            packetTransformer.close();
            this.packetTransformers[i] = null;
        }
        this.setConnector(null);
        this.setMediaType(null);
    }

    private DtlsPacketTransformer createPacketTransformer(int componentID) {
        DtlsPacketTransformer packetTransformer = new DtlsPacketTransformer(this, componentID);
        packetTransformer.setConnector(this.connector);
        packetTransformer.setDtlsProtocol(this.dtlsProtocol);
        packetTransformer.setMediaType(this.mediaType);
        return packetTransformer;
    }

    DtlsControlImpl getDtlsControl() {
        return this.dtlsControl;
    }

    private DtlsPacketTransformer getPacketTransformer(int componentID) {
        int index = componentID - 1;
        DtlsPacketTransformer packetTransformer = this.packetTransformers[index];
        if (packetTransformer == null && (packetTransformer = this.createPacketTransformer(componentID)) != null) {
            this.packetTransformers[index] = packetTransformer;
        }
        return packetTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.getPacketTransformer(2);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.getPacketTransformer(1);
    }

    void setConnector(AbstractRTPConnector connector) {
        if (this.connector != connector) {
            this.connector = connector;
            for (DtlsPacketTransformer packetTransformer : this.packetTransformers) {
                if (packetTransformer == null) continue;
                packetTransformer.setConnector(this.connector);
            }
        }
    }

    void setDtlsProtocol(int dtlsProtocol) {
        if (this.dtlsProtocol != dtlsProtocol) {
            this.dtlsProtocol = dtlsProtocol;
            for (DtlsPacketTransformer packetTransformer : this.packetTransformers) {
                if (packetTransformer == null) continue;
                packetTransformer.setDtlsProtocol(this.dtlsProtocol);
            }
        }
    }

    private void setMediaType(MediaType mediaType) {
        if (this.mediaType != mediaType) {
            this.mediaType = mediaType;
            for (DtlsPacketTransformer packetTransformer : this.packetTransformers) {
                if (packetTransformer == null) continue;
                packetTransformer.setMediaType(this.mediaType);
            }
        }
    }

    void start(MediaType mediaType) {
        this.setMediaType(mediaType);
    }
}

