/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class TransformEngineChain
implements TransformEngine {
    private final TransformEngine[] engineChain;
    private final PacketTransformerChain rtpTransformChain;
    private final PacketTransformerChain rtcpTransformChain;

    public TransformEngineChain(TransformEngine[] engineChain) {
        this.engineChain = (TransformEngine[])engineChain.clone();
        this.rtpTransformChain = new PacketTransformerChain(true);
        this.rtcpTransformChain = new PacketTransformerChain(false);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformChain;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformChain;
    }

    private class PacketTransformerChain
    implements PacketTransformer {
        private final boolean isRtp;

        public PacketTransformerChain(boolean isRtp) {
            this.isRtp = isRtp;
        }

        @Override
        public void close() {
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer pTransformer;
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pTransformer.close();
            }
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer pTransformer;
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer != null && (pkt = pTransformer.transform(pkt)) == null) break;
            }
            return pkt;
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            for (int i = TransformEngineChain.this.engineChain.length - 1; i >= 0; --i) {
                PacketTransformer pTransformer;
                TransformEngine engine = TransformEngineChain.this.engineChain[i];
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer != null && (pkt = pTransformer.reverseTransform(pkt)) == null) break;
            }
            return pkt;
        }
    }
}

