/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.Format;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.StreamRTPManager;
import org.jitsi.impl.neomedia.protocol.FakePushBufferDataSource;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.util.Logger;

public class RTPTranslatorImpl
implements ReceiveStreamListener,
RTPTranslator {
    private static final Logger logger = Logger.getLogger(RTPTranslatorImpl.class);
    private static final boolean CREATE_FAKE_SEND_STREAM_IF_NECESSARY = false;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private RTPConnectorImpl connector;
    private SendStream fakeSendStream;
    private final RTPManager manager = RTPManager.newInstance();
    private final List<SendStreamDesc> sendStreams = new LinkedList<SendStreamDesc>();
    private final List<StreamRTPManagerDesc> streamRTPManagers = new ArrayList<StreamRTPManagerDesc>();

    public RTPTranslatorImpl() {
        this.manager.addReceiveStreamListener(this);
    }

    public synchronized void addFormat(StreamRTPManager streamRTPManager, Format format, int payloadType) {
        this.manager.addFormat(format, payloadType);
        this.getStreamRTPManagerDesc(streamRTPManager, true).addFormat(format, payloadType);
    }

    public synchronized void addReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        this.getStreamRTPManagerDesc(streamRTPManager, true).addReceiveStreamListener(listener);
    }

    public void addRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.addRemoteListener(listener);
    }

    public void addSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void addSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeFakeSendStreamIfNotNecessary() {
        block8: {
            try {
                if (this.sendStreams.isEmpty() && this.streamRTPManagers.size() >= 2 || this.fakeSendStream == null) break block8;
                try {
                    this.fakeSendStream.close();
                }
                catch (NullPointerException npe) {
                    logger.error("Failed to close fake send stream", npe);
                }
                finally {
                    this.fakeSendStream = null;
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Failed to close the fake SendStream of this RTPTranslator.", t);
            }
        }
    }

    private synchronized void closeSendStream(SendStreamDesc sendStreamDesc) {
        if (this.sendStreams.contains(sendStreamDesc) && sendStreamDesc.getSendStreamCount() < 1) {
            SendStream sendStream = sendStreamDesc.sendStream;
            try {
                sendStream.close();
            }
            catch (NullPointerException npe) {
                logger.error("Failed to close send stream", npe);
            }
            this.sendStreams.remove(sendStreamDesc);
        }
    }

    private synchronized void createFakeSendStreamIfNecessary() {
        if (this.fakeSendStream == null && this.sendStreams.isEmpty() && this.streamRTPManagers.size() > 1) {
            Format supportedFormat = null;
            for (StreamRTPManagerDesc s : this.streamRTPManagers) {
                Format[] formats = s.getFormats();
                if (formats == null || formats.length <= 0) continue;
                for (Format f : formats) {
                    if (f == null) continue;
                    supportedFormat = f;
                    break;
                }
                if (supportedFormat == null) continue;
                break;
            }
            if (supportedFormat != null) {
                try {
                    this.fakeSendStream = this.manager.createSendStream(new FakePushBufferDataSource(supportedFormat), 0);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.error("Failed to create a fake SendStream to ensure that this RTPTranslator is able to disperse RTP and RTCP received from remote peers even when the local peer is not generating media to be transmitted.", t);
                }
            }
        }
    }

    public synchronized SendStream createSendStream(StreamRTPManager streamRTPManager, DataSource dataSource, int streamIndex) throws IOException, UnsupportedFormatException {
        SendStream sendStream;
        SendStreamDesc sendStreamDesc = null;
        for (SendStreamDesc s : this.sendStreams) {
            if (s.dataSource != dataSource || s.streamIndex != streamIndex) continue;
            sendStreamDesc = s;
            break;
        }
        if (sendStreamDesc == null && (sendStream = this.manager.createSendStream(dataSource, streamIndex)) != null) {
            sendStreamDesc = new SendStreamDesc(dataSource, streamIndex, sendStream);
            this.sendStreams.add(sendStreamDesc);
            this.closeFakeSendStreamIfNotNecessary();
        }
        return sendStreamDesc == null ? null : sendStreamDesc.getSendStream(streamRTPManager, true);
    }

    @Override
    public synchronized void dispose() {
        this.manager.removeReceiveStreamListener(this);
        try {
            this.manager.dispose();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to dispose of RTPManager", t);
        }
    }

    public synchronized void dispose(StreamRTPManager streamRTPManager) {
        Iterator<StreamRTPManagerDesc> streamRTPManagerIter = this.streamRTPManagers.iterator();
        while (streamRTPManagerIter.hasNext()) {
            StreamRTPManagerDesc streamRTPManagerDesc = streamRTPManagerIter.next();
            if (streamRTPManagerDesc.streamRTPManager != streamRTPManager) continue;
            RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
            if (connectorDesc != null) {
                if (this.connector != null) {
                    this.connector.removeConnector(connectorDesc);
                }
                connectorDesc.connector.close();
                streamRTPManagerDesc.connectorDesc = null;
            }
            streamRTPManagerIter.remove();
            this.closeFakeSendStreamIfNotNecessary();
            break;
        }
    }

    private synchronized StreamRTPManagerDesc findStreamRTPManagerDescByReceiveSSRC(int receiveSSRC, StreamRTPManagerDesc exclusion) {
        int count = this.streamRTPManagers.size();
        for (int i = 0; i < count; ++i) {
            StreamRTPManagerDesc s = this.streamRTPManagers.get(i);
            if (s == exclusion || !s.containsReceiveSSRC(receiveSSRC)) continue;
            return s;
        }
        return null;
    }

    public Object getControl(StreamRTPManager streamRTPManager, String controlType) {
        return this.manager.getControl(controlType);
    }

    public GlobalReceptionStats getGlobalReceptionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalReceptionStats();
    }

    public GlobalTransmissionStats getGlobalTransmissionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalTransmissionStats();
    }

    public long getLocalSSRC(StreamRTPManager streamRTPManager) {
        return ((RTPSessionMgr)this.manager).getLocalSSRC();
    }

    public synchronized Vector<ReceiveStream> getReceiveStreams(StreamRTPManager streamRTPManager) {
        Vector managerReceiveStreams;
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, false);
        Vector<ReceiveStream> receiveStreams = null;
        if (streamRTPManagerDesc != null && (managerReceiveStreams = this.manager.getReceiveStreams()) != null) {
            receiveStreams = new Vector<ReceiveStream>(managerReceiveStreams.size());
            for (Object s : managerReceiveStreams) {
                ReceiveStream receiveStream = (ReceiveStream)s;
                int receiveSSRC = (int)receiveStream.getSSRC();
                if (!streamRTPManagerDesc.containsReceiveSSRC(receiveSSRC)) continue;
                receiveStreams.add(receiveStream);
            }
        }
        return receiveStreams;
    }

    public synchronized Vector<SendStream> getSendStreams(StreamRTPManager streamRTPManager) {
        Vector managerSendStreams = this.manager.getSendStreams();
        Vector<SendStreamImpl> sendStreams = null;
        if (managerSendStreams != null) {
            sendStreams = new Vector<SendStreamImpl>(managerSendStreams.size());
            for (SendStreamDesc sendStreamDesc : this.sendStreams) {
                SendStreamImpl sendStream;
                if (!managerSendStreams.contains(sendStreamDesc.sendStream) || (sendStream = sendStreamDesc.getSendStream(streamRTPManager, false)) == null) continue;
                sendStreams.add(sendStream);
            }
        }
        return sendStreams;
    }

    private synchronized StreamRTPManagerDesc getStreamRTPManagerDesc(StreamRTPManager streamRTPManager, boolean create) {
        StreamRTPManagerDesc s;
        for (StreamRTPManagerDesc s2 : this.streamRTPManagers) {
            if (s2.streamRTPManager != streamRTPManager) continue;
            return s2;
        }
        if (create) {
            s = new StreamRTPManagerDesc(streamRTPManager);
            this.streamRTPManagers.add(s);
        } else {
            s = null;
        }
        return s;
    }

    public synchronized void initialize(StreamRTPManager streamRTPManager, RTPConnector connector) {
        if (this.connector == null) {
            this.connector = new RTPConnectorImpl();
            this.manager.initialize(this.connector);
        }
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, true);
        RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
        if (connectorDesc == null || connectorDesc.connector != connector) {
            if (connectorDesc != null) {
                this.connector.removeConnector(connectorDesc);
            }
            connectorDesc = connector == null ? null : new RTPConnectorDesc(streamRTPManagerDesc, connector);
            streamRTPManagerDesc.connectorDesc = connectorDesc;
            if (connectorDesc != null) {
                this.connector.addConnector(connectorDesc);
            }
        }
    }

    private static void logRTCP(Object obj, String methodName, byte[] buffer, int offset, int length) {
        int rtcpLength;
        byte b1;
        int pt;
        byte b0;
        int v;
        if (length >= 8 && (v = ((b0 = buffer[offset]) & 0xC0) >>> 6) == 2 && (pt = (b1 = buffer[offset + 1]) & 0xFF) == 203 && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buffer, offset + 2) + 1) * 4) <= length) {
            int sc = b0 & 0x1F;
            int off = offset + 4;
            int i = 0;
            int end = offset + length;
            while (i < sc && off + 4 <= end) {
                int ssrc = RTPTranslatorImpl.readInt(buffer, off);
                logger.trace(obj.getClass().getName() + '.' + methodName + ": RTCP BYE SSRC/CSRC " + Long.toString((long)ssrc & 0xFFFFFFFFL));
                ++i;
                off += 4;
            }
        }
    }

    private synchronized int read(PushSourceStreamDesc streamDesc, byte[] buffer, int offset, int length, int read) throws IOException {
        OutputDataStreamImpl outputStream;
        boolean data = streamDesc.data;
        StreamRTPManagerDesc streamRTPManagerDesc = streamDesc.connectorDesc.streamRTPManagerDesc;
        Format format = null;
        if (data) {
            if (!streamRTPManagerDesc.streamRTPManager.getMediaStream().getDirection().allowsReceiving()) {
                return read;
            }
            if (length >= 12 && (buffer[offset] & 0xC0) >>> 6 == 2) {
                int ssrc = RTPTranslatorImpl.readInt(buffer, offset + 8);
                if (!streamRTPManagerDesc.containsReceiveSSRC(ssrc)) {
                    if (this.findStreamRTPManagerDescByReceiveSSRC(ssrc, streamRTPManagerDesc) == null) {
                        streamRTPManagerDesc.addReceiveSSRC(ssrc);
                    } else {
                        return 0;
                    }
                }
                int pt = buffer[offset + 1] & 0x7F;
                format = streamRTPManagerDesc.getFormat(pt);
            }
        } else if (logger.isTraceEnabled()) {
            RTPTranslatorImpl.logRTCP(this, "read", buffer, offset, read);
        }
        OutputDataStreamImpl outputDataStreamImpl = outputStream = data ? this.connector.getDataOutputStream() : this.connector.getControlOutputStream();
        if (outputStream != null) {
            outputStream.write(buffer, offset, read, format, streamRTPManagerDesc);
        }
        return read;
    }

    public static int readInt(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 24 | (buf[off++] & 0xFF) << 16 | (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static int readUnsignedShort(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public synchronized void removeReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, false);
        if (streamRTPManagerDesc != null) {
            streamRTPManagerDesc.removeReceiveStreamListener(listener);
        }
    }

    public void removeRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.removeRemoteListener(listener);
    }

    public void removeSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void removeSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    @Override
    public void update(ReceiveStreamEvent event) {
        int receiveSSRC;
        StreamRTPManagerDesc streamRTPManagerDesc;
        ReceiveStream receiveStream;
        if (event != null && (receiveStream = event.getReceiveStream()) != null && (streamRTPManagerDesc = this.findStreamRTPManagerDescByReceiveSSRC(receiveSSRC = (int)receiveStream.getSSRC(), null)) != null) {
            for (ReceiveStreamListener listener : streamRTPManagerDesc.getReceiveStreamListeners()) {
                listener.update(event);
            }
        }
    }

    static /* synthetic */ int[] access$600() {
        return EMPTY_INT_ARRAY;
    }

    private static class StreamRTPManagerDesc {
        public RTPConnectorDesc connectorDesc;
        private final Map<Integer, Format> formats = new HashMap<Integer, Format>();
        private int[] receiveSSRCs = RTPTranslatorImpl.access$600();
        private final List<ReceiveStreamListener> receiveStreamListeners = new LinkedList<ReceiveStreamListener>();
        public final StreamRTPManager streamRTPManager;

        public StreamRTPManagerDesc(StreamRTPManager streamRTPManager) {
            this.streamRTPManager = streamRTPManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFormat(Format format, int payloadType) {
            Map<Integer, Format> map = this.formats;
            synchronized (map) {
                this.formats.put(payloadType, format);
            }
        }

        public synchronized void addReceiveSSRC(int receiveSSRC) {
            if (!this.containsReceiveSSRC(receiveSSRC)) {
                int receiveSSRCCount = this.receiveSSRCs.length;
                int[] newReceiveSSRCs = new int[receiveSSRCCount + 1];
                System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, receiveSSRCCount);
                newReceiveSSRCs[receiveSSRCCount] = receiveSSRC;
                this.receiveSSRCs = newReceiveSSRCs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReceiveStreamListener(ReceiveStreamListener listener) {
            List<ReceiveStreamListener> list = this.receiveStreamListeners;
            synchronized (list) {
                if (!this.receiveStreamListeners.contains(listener)) {
                    this.receiveStreamListeners.add(listener);
                }
            }
        }

        public synchronized boolean containsReceiveSSRC(int receiveSSRC) {
            for (int i = 0; i < this.receiveSSRCs.length; ++i) {
                if (this.receiveSSRCs[i] != receiveSSRC) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Format getFormat(int payloadType) {
            Map<Integer, Format> map = this.formats;
            synchronized (map) {
                return this.formats.get(payloadType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Format[] getFormats() {
            Map<Integer, Format> map = this.formats;
            synchronized (map) {
                Collection<Format> formats = this.formats.values();
                return formats.toArray(new Format[formats.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer getPayloadType(Format format) {
            Map<Integer, Format> map = this.formats;
            synchronized (map) {
                for (Map.Entry<Integer, Format> entry : this.formats.entrySet()) {
                    Format entryFormat = entry.getValue();
                    if (!entryFormat.matches(format) && !format.matches(entryFormat)) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReceiveStreamListener[] getReceiveStreamListeners() {
            List<ReceiveStreamListener> list = this.receiveStreamListeners;
            synchronized (list) {
                return this.receiveStreamListeners.toArray(new ReceiveStreamListener[this.receiveStreamListeners.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeReceiveStreamListener(ReceiveStreamListener listener) {
            List<ReceiveStreamListener> list = this.receiveStreamListeners;
            synchronized (list) {
                this.receiveStreamListeners.remove(listener);
            }
        }
    }

    private static class SourcePacket
    extends RawPacket {
        public PushSourceStreamDesc streamDesc;

        public SourcePacket(byte[] buf, int off, int len) {
            super(buf, off, len);
        }
    }

    private static class SendStreamImpl
    implements SendStream {
        private boolean closed;
        public final SendStreamDesc sendStreamDesc;
        private boolean started;
        public final StreamRTPManager streamRTPManager;

        public SendStreamImpl(StreamRTPManager streamRTPManager, SendStreamDesc sendStreamDesc) {
            this.sendStreamDesc = sendStreamDesc;
            this.streamRTPManager = streamRTPManager;
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    if (this.started) {
                        this.stop();
                    }
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                finally {
                    this.sendStreamDesc.close(this);
                    this.closed = true;
                }
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.sendStreamDesc.sendStream.getDataSource();
        }

        @Override
        public Participant getParticipant() {
            return this.sendStreamDesc.sendStream.getParticipant();
        }

        @Override
        public SenderReport getSenderReport() {
            return this.sendStreamDesc.sendStream.getSenderReport();
        }

        @Override
        public TransmissionStats getSourceTransmissionStats() {
            return this.sendStreamDesc.sendStream.getSourceTransmissionStats();
        }

        @Override
        public long getSSRC() {
            return this.sendStreamDesc.sendStream.getSSRC();
        }

        @Override
        public int setBitRate(int bitRate) {
            return 0;
        }

        @Override
        public void setSourceDescription(SourceDescription[] sourceDescription) {
        }

        @Override
        public void start() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot start SendStream after it has been closed.");
            }
            if (!this.started) {
                this.sendStreamDesc.start(this);
                this.started = true;
            }
        }

        @Override
        public void stop() throws IOException {
            if (!this.closed && this.started) {
                this.sendStreamDesc.stop(this);
                this.started = false;
            }
        }
    }

    private class SendStreamDesc {
        public final DataSource dataSource;
        public final SendStream sendStream;
        private final List<SendStreamImpl> sendStreams = new LinkedList<SendStreamImpl>();
        private int started;
        public final int streamIndex;

        public SendStreamDesc(DataSource dataSource, int streamIndex, SendStream sendStream) {
            this.dataSource = dataSource;
            this.sendStream = sendStream;
            this.streamIndex = streamIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(SendStreamImpl sendStream) {
            boolean close = false;
            SendStreamDesc sendStreamDesc = this;
            synchronized (sendStreamDesc) {
                if (this.sendStreams.contains(sendStream)) {
                    this.sendStreams.remove(sendStream);
                    close = this.sendStreams.isEmpty();
                }
            }
            if (close) {
                RTPTranslatorImpl.this.closeSendStream(this);
            }
        }

        public synchronized SendStreamImpl getSendStream(StreamRTPManager streamRTPManager, boolean create) {
            for (SendStreamImpl sendStream : this.sendStreams) {
                if (sendStream.streamRTPManager != streamRTPManager) continue;
                return sendStream;
            }
            if (create) {
                SendStreamImpl sendStream = new SendStreamImpl(streamRTPManager, this);
                this.sendStreams.add(sendStream);
                return sendStream;
            }
            return null;
        }

        public synchronized int getSendStreamCount() {
            return this.sendStreams.size();
        }

        synchronized void start(SendStreamImpl sendStream) throws IOException {
            if (this.sendStreams.contains(sendStream)) {
                if (this.started < 1) {
                    this.sendStream.start();
                    this.started = 1;
                } else {
                    ++this.started;
                }
            }
        }

        synchronized void stop(SendStreamImpl sendStream) throws IOException {
            if (this.sendStreams.contains(sendStream)) {
                if (this.started == 1) {
                    this.sendStream.stop();
                    this.started = 0;
                } else if (this.started > 1) {
                    --this.started;
                }
            }
        }
    }

    private static class RTPTranslatorBuffer {
        public byte[] data;
        public StreamRTPManagerDesc exclusion;
        public Format format;
        public int length;

        private RTPTranslatorBuffer() {
        }
    }

    private class RTPConnectorImpl
    implements RTPConnector {
        private final List<RTPConnectorDesc> connectors = new LinkedList<RTPConnectorDesc>();
        private PushSourceStreamImpl controlInputStream;
        private OutputDataStreamImpl controlOutputStream;
        private PushSourceStreamImpl dataInputStream;
        private OutputDataStreamImpl dataOutputStream;

        private RTPConnectorImpl() {
        }

        public synchronized void addConnector(RTPConnectorDesc connector) {
            if (!this.connectors.contains(connector)) {
                this.connectors.add(connector);
                if (this.controlInputStream != null) {
                    PushSourceStream controlInputStream = null;
                    try {
                        controlInputStream = connector.connector.getControlInputStream();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                    if (controlInputStream != null) {
                        this.controlInputStream.addStream(connector, controlInputStream);
                    }
                }
                if (this.controlOutputStream != null) {
                    OutputDataStream controlOutputStream = null;
                    try {
                        controlOutputStream = connector.connector.getControlOutputStream();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                    if (controlOutputStream != null) {
                        this.controlOutputStream.addStream(connector, controlOutputStream);
                    }
                }
                if (this.dataInputStream != null) {
                    PushSourceStream dataInputStream = null;
                    try {
                        dataInputStream = connector.connector.getDataInputStream();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                    if (dataInputStream != null) {
                        this.dataInputStream.addStream(connector, dataInputStream);
                    }
                }
                if (this.dataOutputStream != null) {
                    OutputDataStream dataOutputStream = null;
                    try {
                        dataOutputStream = connector.connector.getDataOutputStream();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                    if (dataOutputStream != null) {
                        this.dataOutputStream.addStream(connector, dataOutputStream);
                    }
                }
            }
        }

        @Override
        public synchronized void close() {
            if (this.controlInputStream != null) {
                this.controlInputStream.close();
                this.controlInputStream = null;
            }
            if (this.controlOutputStream != null) {
                this.controlOutputStream.close();
                this.controlOutputStream = null;
            }
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
                this.dataInputStream = null;
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
                this.dataOutputStream = null;
            }
            for (RTPConnectorDesc connectorDesc : this.connectors) {
                connectorDesc.connector.close();
            }
        }

        @Override
        public synchronized PushSourceStream getControlInputStream() throws IOException {
            if (this.controlInputStream == null) {
                this.controlInputStream = new PushSourceStreamImpl(false);
                for (RTPConnectorDesc connectorDesc : this.connectors) {
                    PushSourceStream controlInputStream = connectorDesc.connector.getControlInputStream();
                    if (controlInputStream == null) continue;
                    this.controlInputStream.addStream(connectorDesc, controlInputStream);
                }
            }
            return this.controlInputStream;
        }

        @Override
        public synchronized OutputDataStreamImpl getControlOutputStream() throws IOException {
            if (this.controlOutputStream == null) {
                this.controlOutputStream = new OutputDataStreamImpl(false);
                for (RTPConnectorDesc connectorDesc : this.connectors) {
                    OutputDataStream controlOutputStream = connectorDesc.connector.getControlOutputStream();
                    if (controlOutputStream == null) continue;
                    this.controlOutputStream.addStream(connectorDesc, controlOutputStream);
                }
            }
            return this.controlOutputStream;
        }

        @Override
        public synchronized PushSourceStream getDataInputStream() throws IOException {
            if (this.dataInputStream == null) {
                this.dataInputStream = new PushSourceStreamImpl(true);
                for (RTPConnectorDesc connectorDesc : this.connectors) {
                    PushSourceStream dataInputStream = connectorDesc.connector.getDataInputStream();
                    if (dataInputStream == null) continue;
                    this.dataInputStream.addStream(connectorDesc, dataInputStream);
                }
            }
            return this.dataInputStream;
        }

        @Override
        public synchronized OutputDataStreamImpl getDataOutputStream() throws IOException {
            if (this.dataOutputStream == null) {
                this.dataOutputStream = new OutputDataStreamImpl(true);
                for (RTPConnectorDesc connectorDesc : this.connectors) {
                    OutputDataStream dataOutputStream = connectorDesc.connector.getDataOutputStream();
                    if (dataOutputStream == null) continue;
                    this.dataOutputStream.addStream(connectorDesc, dataOutputStream);
                }
            }
            return this.dataOutputStream;
        }

        @Override
        public int getReceiveBufferSize() {
            return -1;
        }

        @Override
        public double getRTCPBandwidthFraction() {
            return -1.0;
        }

        @Override
        public double getRTCPSenderBandwidthFraction() {
            return -1.0;
        }

        @Override
        public int getSendBufferSize() {
            return -1;
        }

        public synchronized void removeConnector(RTPConnectorDesc connector) {
            if (this.connectors.contains(connector)) {
                if (this.controlInputStream != null) {
                    this.controlInputStream.removeStreams(connector);
                }
                if (this.controlOutputStream != null) {
                    this.controlOutputStream.removeStreams(connector);
                }
                if (this.dataInputStream != null) {
                    this.dataInputStream.removeStreams(connector);
                }
                if (this.dataOutputStream != null) {
                    this.dataOutputStream.removeStreams(connector);
                }
                this.connectors.remove(connector);
            }
        }

        @Override
        public void setReceiveBufferSize(int receiveBufferSize) throws IOException {
        }

        @Override
        public void setSendBufferSize(int sendBufferSize) throws IOException {
        }
    }

    private static class RTPConnectorDesc {
        public final RTPConnector connector;
        public final StreamRTPManagerDesc streamRTPManagerDesc;

        public RTPConnectorDesc(StreamRTPManagerDesc streamRTPManagerDesc, RTPConnector connector) {
            this.streamRTPManagerDesc = streamRTPManagerDesc;
            this.connector = connector;
        }
    }

    private class PushSourceStreamImpl
    implements PushSourceStream,
    Runnable,
    SourceTransferHandler {
        private boolean closed = false;
        private final boolean data;
        private boolean read = false;
        private final Queue<SourcePacket> readQ;
        private final int readQCapacity;
        private final Queue<SourcePacket> sourcePacketPool = new LinkedBlockingQueue<SourcePacket>();
        private final List<PushSourceStreamDesc> streams = new LinkedList<PushSourceStreamDesc>();
        private Thread transferDataThread;
        private SourceTransferHandler transferHandler;

        public PushSourceStreamImpl(boolean data) {
            this.data = data;
            this.readQCapacity = 256;
            this.readQ = new ArrayBlockingQueue<SourcePacket>(this.readQCapacity);
            this.transferDataThread = new Thread((Runnable)this, this.getClass().getName());
            this.transferDataThread.setDaemon(true);
            this.transferDataThread.start();
        }

        public synchronized void addStream(RTPConnectorDesc connectorDesc, PushSourceStream stream) {
            for (PushSourceStreamDesc streamDesc : this.streams) {
                if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
                return;
            }
            this.streams.add(new PushSourceStreamDesc(connectorDesc, stream, this.data));
            stream.setTransferHandler(this);
        }

        public void close() {
            this.closed = true;
            this.sourcePacketPool.clear();
        }

        @Override
        public boolean endOfStream() {
            return false;
        }

        @Override
        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Object getControl(String controlType) {
            return null;
        }

        @Override
        public Object[] getControls() {
            return null;
        }

        @Override
        public synchronized int getMinimumTransferSize() {
            int minimumTransferSize = 0;
            for (PushSourceStreamDesc streamDesc : this.streams) {
                int streamMinimumTransferSize = streamDesc.stream.getMinimumTransferSize();
                if (minimumTransferSize >= streamMinimumTransferSize) continue;
                minimumTransferSize = streamMinimumTransferSize;
            }
            return minimumTransferSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int pktLength;
            SourcePacket pkt;
            if (this.closed) {
                return -1;
            }
            Queue<SourcePacket> queue = this.readQ;
            synchronized (queue) {
                pkt = this.readQ.peek();
                if (pkt == null) {
                    return 0;
                }
                pktLength = pkt.getLength();
                if (length < pktLength) {
                    throw new IOException("Length " + length + " is insuffient. Must be at least " + pktLength + ".");
                }
                this.readQ.remove();
                this.read = true;
                this.readQ.notifyAll();
            }
            System.arraycopy(pkt.getBuffer(), pkt.getOffset(), buffer, offset, pktLength);
            PushSourceStreamDesc streamDesc = pkt.streamDesc;
            int read = pktLength;
            pkt.streamDesc = null;
            this.sourcePacketPool.offer(pkt);
            if (read > 0) {
                read = RTPTranslatorImpl.this.read(streamDesc, buffer, offset, length, read);
            }
            return read;
        }

        public synchronized void removeStreams(RTPConnectorDesc connectorDesc) {
            Iterator<PushSourceStreamDesc> streamIter = this.streams.iterator();
            while (streamIter.hasNext()) {
                PushSourceStreamDesc streamDesc = streamIter.next();
                if (streamDesc.connectorDesc != connectorDesc) continue;
                streamDesc.stream.setTransferHandler(null);
                streamIter.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                block10: while (true) {
                    while (!this.closed) {
                        SourceTransferHandler transferHandler = this.transferHandler;
                        Queue<SourcePacket> queue = this.readQ;
                        synchronized (queue) {
                            if (this.readQ.isEmpty() || transferHandler == null) {
                                try {
                                    this.readQ.wait(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                continue;
                            }
                        }
                        try {
                            transferHandler.transferData(this);
                            continue block10;
                        }
                        catch (Throwable t) {
                            if (t instanceof ThreadDeath) {
                                throw (ThreadDeath)t;
                            }
                            logger.warn("An RTP packet may have not been fully handled.", t);
                        }
                    }
                    break block15;
                    {
                        continue block10;
                        break;
                    }
                    break;
                }
                finally {
                    if (Thread.currentThread().equals(this.transferDataThread)) {
                        this.transferDataThread = null;
                    }
                }
            }
        }

        @Override
        public synchronized void setTransferHandler(SourceTransferHandler transferHandler) {
            if (this.transferHandler != transferHandler) {
                this.transferHandler = transferHandler;
                for (PushSourceStreamDesc streamDesc : this.streams) {
                    streamDesc.stream.setTransferHandler(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transferData(PushSourceStream stream) {
            SourcePacket pkt;
            block44: {
                boolean yield;
                byte[] buf;
                if (this.closed) {
                    return;
                }
                PushSourceStreamDesc streamDesc = null;
                PushSourceStreamImpl pushSourceStreamImpl = this;
                synchronized (pushSourceStreamImpl) {
                    for (PushSourceStreamDesc aStreamDesc : this.streams) {
                        if (aStreamDesc.stream != stream) continue;
                        streamDesc = aStreamDesc;
                        break;
                    }
                }
                if (streamDesc == null) {
                    return;
                }
                int len = stream.getMinimumTransferSize();
                if (len < 1) {
                    len = 2048;
                }
                if ((pkt = this.sourcePacketPool.poll()) == null || (buf = pkt.getBuffer()).length < len) {
                    buf = new byte[len];
                    pkt = new SourcePacket(buf, 0, len);
                } else {
                    buf = pkt.getBuffer();
                    len = buf.length;
                }
                int read = 0;
                try {
                    read = stream.read(buf, 0, len);
                    if (read <= 0) break block44;
                }
                catch (IOException ioe) {
                    block45: {
                        boolean yield2;
                        try {
                            logger.error("Failed to read from an RTP stream!", ioe);
                            if (read <= 0) break block45;
                        }
                        catch (Throwable throwable) {
                            if (read > 0) {
                                boolean yield3;
                                pkt.setLength(read);
                                pkt.setOffset(0);
                                pkt.streamDesc = streamDesc;
                                Queue<SourcePacket> queue = this.readQ;
                                synchronized (queue) {
                                    int readQSize = this.readQ.size();
                                    yield3 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                                    if (yield3) {
                                        this.readQ.notifyAll();
                                    }
                                }
                                if (yield3) {
                                    Thread.yield();
                                }
                                queue = this.readQ;
                                synchronized (queue) {
                                    if (this.readQ.size() >= this.readQCapacity) {
                                        this.readQ.remove();
                                        logger.warn("Discarded an RTP packet because the read queue is full.");
                                    }
                                    if (this.readQ.offer(pkt)) {
                                        // empty if block
                                    }
                                    this.readQ.notifyAll();
                                }
                            }
                            pkt.streamDesc = null;
                            this.sourcePacketPool.offer(pkt);
                            throw throwable;
                        }
                        pkt.setLength(read);
                        pkt.setOffset(0);
                        pkt.streamDesc = streamDesc;
                        Queue<SourcePacket> queue = this.readQ;
                        synchronized (queue) {
                            int readQSize = this.readQ.size();
                            yield2 = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                            if (yield2) {
                                this.readQ.notifyAll();
                            }
                        }
                        if (yield2) {
                            Thread.yield();
                        }
                        queue = this.readQ;
                        synchronized (queue) {
                            if (this.readQ.size() >= this.readQCapacity) {
                                this.readQ.remove();
                                logger.warn("Discarded an RTP packet because the read queue is full.");
                            }
                            if (this.readQ.offer(pkt)) {
                                // empty if block
                            }
                            this.readQ.notifyAll();
                        }
                    }
                    pkt.streamDesc = null;
                    this.sourcePacketPool.offer(pkt);
                }
                pkt.setLength(read);
                pkt.setOffset(0);
                pkt.streamDesc = streamDesc;
                Queue<SourcePacket> queue = this.readQ;
                synchronized (queue) {
                    int readQSize = this.readQ.size();
                    yield = readQSize < 1 ? false : (readQSize < this.readQCapacity ? !this.read : true);
                    if (yield) {
                        this.readQ.notifyAll();
                    }
                }
                if (yield) {
                    Thread.yield();
                }
                queue = this.readQ;
                synchronized (queue) {
                    if (this.readQ.size() >= this.readQCapacity) {
                        this.readQ.remove();
                        logger.warn("Discarded an RTP packet because the read queue is full.");
                    }
                    if (this.readQ.offer(pkt)) {
                        // empty if block
                    }
                    this.readQ.notifyAll();
                }
            }
            pkt.streamDesc = null;
            this.sourcePacketPool.offer(pkt);
        }
    }

    private static class PushSourceStreamDesc {
        public final RTPConnectorDesc connectorDesc;
        public final boolean data;
        public final PushSourceStream stream;

        public PushSourceStreamDesc(RTPConnectorDesc connectorDesc, PushSourceStream stream, boolean data) {
            this.connectorDesc = connectorDesc;
            this.stream = stream;
            this.data = data;
        }
    }

    private static class OutputDataStreamImpl
    implements OutputDataStream,
    Runnable {
        private static final int WRITE_QUEUE_CAPACITY = 256;
        private boolean closed;
        private final boolean data;
        private final List<OutputDataStreamDesc> streams = new ArrayList<OutputDataStreamDesc>();
        private final RTPTranslatorBuffer[] writeQueue = new RTPTranslatorBuffer[256];
        private int writeQueueHead;
        private int writeQueueLength;
        private Thread writeThread;

        public OutputDataStreamImpl(boolean data) {
            this.data = data;
        }

        public synchronized void addStream(RTPConnectorDesc connectorDesc, OutputDataStream stream) {
            for (OutputDataStreamDesc streamDesc : this.streams) {
                if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
                return;
            }
            this.streams.add(new OutputDataStreamDesc(connectorDesc, stream));
        }

        public synchronized void close() {
            this.closed = true;
            this.writeThread = null;
            this.notify();
        }

        private synchronized void createWriteThread() {
            this.writeThread = new Thread((Runnable)this, this.getClass().getName());
            this.writeThread.setDaemon(true);
            this.writeThread.start();
        }

        private synchronized int doWrite(byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
            int written = 0;
            int streamCount = this.streams.size();
            for (int streamIndex = 0; streamIndex < streamCount; ++streamIndex) {
                int streamWritten;
                boolean write;
                OutputDataStreamDesc streamDesc = this.streams.get(streamIndex);
                StreamRTPManagerDesc streamRTPManagerDesc = streamDesc.connectorDesc.streamRTPManagerDesc;
                if (streamRTPManagerDesc == exclusion || !(write = this.data ? this.willWriteData(streamRTPManagerDesc, buffer, offset, length, format, exclusion) : this.willWriteControl(streamRTPManagerDesc, buffer, offset, length, format, exclusion)) || written >= (streamWritten = streamDesc.stream.write(buffer, offset, length))) continue;
                written = streamWritten;
            }
            return written;
        }

        public synchronized void removeStreams(RTPConnectorDesc connectorDesc) {
            Iterator<OutputDataStreamDesc> streamIter = this.streams.iterator();
            while (streamIter.hasNext()) {
                OutputDataStreamDesc streamDesc = streamIter.next();
                if (streamDesc.connectorDesc != connectorDesc) continue;
                streamIter.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    int length;
                    Format format;
                    StreamRTPManagerDesc exclusion;
                    byte[] buffer;
                    RTPTranslatorBuffer write;
                    int writeIndex;
                    OutputDataStreamImpl outputDataStreamImpl = this;
                    synchronized (outputDataStreamImpl) {
                        if (this.closed) return;
                        if (!Thread.currentThread().equals(this.writeThread)) {
                            return;
                        }
                        if (this.writeQueueLength < 1) {
                            boolean interrupted = false;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                interrupted = true;
                            }
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        writeIndex = this.writeQueueHead++;
                        write = this.writeQueue[writeIndex];
                        buffer = write.data;
                        write.data = null;
                        exclusion = write.exclusion;
                        write.exclusion = null;
                        format = write.format;
                        write.format = null;
                        length = write.length;
                        write.length = 0;
                        if (this.writeQueueHead >= this.writeQueue.length) {
                            this.writeQueueHead = 0;
                        }
                        --this.writeQueueLength;
                    }
                    try {
                        this.doWrite(buffer, 0, length, format, exclusion);
                        outputDataStreamImpl = this;
                    }
                    catch (Throwable throwable) {
                        OutputDataStreamImpl outputDataStreamImpl2 = this;
                        synchronized (outputDataStreamImpl2) {
                            RTPTranslatorBuffer write2 = this.writeQueue[writeIndex];
                            if (write2 == null) throw throwable;
                            if (write2.data != null) throw throwable;
                            write2.data = buffer;
                            throw throwable;
                        }
                    }
                    synchronized (outputDataStreamImpl) {
                        write = this.writeQueue[writeIndex];
                        if (write != null && write.data == null) {
                            write.data = buffer;
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Failed to translate RTP packet", t);
                if (!(t instanceof ThreadDeath)) return;
                throw (ThreadDeath)t;
            }
            finally {
                OutputDataStreamImpl writeIndex = this;
                synchronized (writeIndex) {
                    if (Thread.currentThread().equals(this.writeThread)) {
                        this.writeThread = null;
                    }
                    if (!this.closed && this.writeThread == null && this.writeQueueLength > 0) {
                        this.createWriteThread();
                    }
                }
            }
        }

        private boolean willWriteControl(StreamRTPManagerDesc destination, byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
            int rtcpLength;
            byte b1;
            int pt;
            byte b0;
            int v;
            boolean write = true;
            if (length >= 12 && (v = ((b0 = buffer[offset]) & 0xC0) >>> 6) == 2 && ((pt = (b1 = buffer[offset + 1]) & 0xFF) == 205 || pt == 206) && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buffer, offset + 2) + 1) * 4) <= length) {
                int ssrcOfMediaSource = RTPTranslatorImpl.readInt(buffer, offset + 8);
                if (destination.containsReceiveSSRC(ssrcOfMediaSource)) {
                    if (logger.isTraceEnabled()) {
                        int fmt = b0 & 0x1F;
                        int ssrcOfPacketSender = RTPTranslatorImpl.readInt(buffer, offset + 4);
                        String message = this.getClass().getName() + ".willWriteControl: FMT " + fmt + ", PT " + pt + ", SSRC of packet sender " + Long.toString((long)ssrcOfPacketSender & 0xFFFFFFFFL) + ", SSRC of media source " + Long.toString((long)ssrcOfMediaSource & 0xFFFFFFFFL);
                        logger.trace(message);
                    }
                } else {
                    write = false;
                }
            }
            if (write && logger.isTraceEnabled()) {
                RTPTranslatorImpl.logRTCP(this, "doWrite", buffer, offset, length);
            }
            return write;
        }

        private boolean willWriteData(StreamRTPManagerDesc destination, byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
            if (!destination.streamRTPManager.getMediaStream().getDirection().allowsSending()) {
                return false;
            }
            if (format != null && length > 0) {
                Integer payloadType = destination.getPayloadType(format);
                if (payloadType == null && exclusion != null) {
                    payloadType = exclusion.getPayloadType(format);
                }
                if (payloadType != null) {
                    int payloadTypeByteIndex = offset + 1;
                    buffer[payloadTypeByteIndex] = (byte)(buffer[payloadTypeByteIndex] & 0x80 | payloadType & 0x7F);
                }
            }
            return true;
        }

        @Override
        public int write(byte[] buffer, int offset, int length) {
            return this.doWrite(buffer, offset, length, null, null);
        }

        public synchronized void write(byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
            byte[] data;
            int writeIndex;
            if (this.closed) {
                return;
            }
            if (this.writeQueueLength < this.writeQueue.length) {
                writeIndex = (this.writeQueueHead + this.writeQueueLength) % this.writeQueue.length;
            } else {
                writeIndex = this.writeQueueHead++;
                if (this.writeQueueHead >= this.writeQueue.length) {
                    this.writeQueueHead = 0;
                }
                --this.writeQueueLength;
                logger.warn("Will not translate RTP packet.");
            }
            RTPTranslatorBuffer write = this.writeQueue[writeIndex];
            if (write == null) {
                this.writeQueue[writeIndex] = write = new RTPTranslatorBuffer();
            }
            if ((data = write.data) == null || data.length < length) {
                write.data = data = new byte[length];
            }
            System.arraycopy(buffer, offset, data, 0, length);
            write.exclusion = exclusion;
            write.format = format;
            write.length = length;
            ++this.writeQueueLength;
            if (this.writeThread == null) {
                this.createWriteThread();
            } else {
                this.notify();
            }
        }
    }

    private static class OutputDataStreamDesc {
        public RTPConnectorDesc connectorDesc;
        public OutputDataStream stream;

        public OutputDataStreamDesc(RTPConnectorDesc connectorDesc, OutputDataStream stream) {
            this.connectorDesc = connectorDesc;
            this.stream = stream;
        }
    }
}

