/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.ChannelEndPoint;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.nio.AbstractNIOConnector;
import org.mortbay.jetty.nio.HttpChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class SelectChannelConnector
extends AbstractNIOConnector {
    private transient ServerSocketChannel _acceptChannel;
    private transient SelectionKey _acceptKey;
    private transient SelectSet[] _selectSets;
    private boolean _delaySelectKeyUpdate = false;

    public Object getConnection() {
        return this._acceptChannel;
    }

    public boolean getDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void setDelaySelectKeyUpdate(boolean delay) {
        this._delaySelectKeyUpdate = delay;
    }

    protected void doStart() throws Exception {
        this._selectSets = new SelectSet[this.getAcceptors()];
        for (int i = 0; i < this._selectSets.length; ++i) {
            this._selectSets[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (int i = 0; i < this._selectSets.length; ++i) {
            this._selectSets[i].stop();
        }
        this._selectSets = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        if (this._acceptChannel == null) {
            this._acceptChannel = ServerSocketChannel.open();
            this._acceptChannel.configureBlocking(false);
            InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
            this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
            SelectSet selectSet = this._selectSets[0];
            synchronized (selectSet) {
                this._acceptKey = this._acceptChannel.register(this._selectSets[0].getSelector(), 16);
            }
        }
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException {
        if (this._selectSets != null && this._selectSets.length > acceptorID && this._selectSets[acceptorID] != null) {
            this._selectSets[acceptorID].accept();
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
    }

    public HttpChannelEndPoint newHttpChannelEndPoint(SelectChannelConnector connector, SocketChannel channel, SelectSet selectSet, SelectionKey sKey) throws IOException {
        return new HttpChannelEndPoint(connector, channel, selectSet, sKey);
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    public Continuation newContinuation() {
        return new RetryContinuation();
    }

    public static class SelectChannelEndPoint
    extends ChannelEndPoint {
        protected SelectChannelConnector _connector;
        protected HttpConnection _connection;

        public SelectChannelEndPoint(SelectChannelConnector connector, ByteChannel channel) {
            super(channel);
        }

        protected void connectionOpened() {
            this._connector.connectionOpened(this._connection);
        }

        protected void connectionClosed() {
            this._connector.connectionClosed(this._connection);
        }

        public void close() throws IOException {
            super.close();
        }
    }

    public static class RetryContinuation
    extends Timeout.Task
    implements Continuation {
        Object _object;
        HttpChannelEndPoint _endPoint = (HttpChannelEndPoint)HttpConnection.getCurrentConnection().getEndPoint();
        long _timeout;
        boolean _new = true;
        boolean _pending = false;
        boolean _resumed = false;
        boolean _scheduled = false;
        RetryRequest _retry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean schedule() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                if (!this._pending) {
                    return false;
                }
                this._scheduled = true;
                redispatch = this.isExpired() || this._resumed;
            }
            if (redispatch) {
                this._endPoint._selectSet.addChange((Object)this);
            } else {
                this._endPoint._selectSet.scheduleTimeout(this, this._timeout);
            }
            this._endPoint._selectSet.wakeup();
            return true;
        }

        public long getTimeout() {
            return this._timeout;
        }

        public boolean isNew() {
            return this._new;
        }

        public boolean isPending() {
            return this._pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expire() {
            boolean redispatch = false;
            RetryContinuation retryContinuation = this;
            synchronized (retryContinuation) {
                redispatch = this._scheduled && this._pending && !this._resumed;
            }
            if (redispatch) {
                this._endPoint._selectSet.addChange((Object)this);
                this._endPoint._selectSet.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend(long timeout) {
            boolean resumed = false;
            Object object = this;
            synchronized (object) {
                resumed = this._resumed;
                this._resumed = false;
                this._new = false;
                if (!this._pending && !resumed && timeout > 0L) {
                    this._pending = true;
                    this._scheduled = false;
                    this._timeout = timeout;
                    if (this._retry == null) {
                        this._retry = new RetryRequest();
                    }
                    throw this._retry;
                }
                this._resumed = false;
                this._pending = false;
            }
            object = this._endPoint._selectSet;
            synchronized (object) {
                this.cancel();
            }
            return resumed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            boolean redispatch = false;
            Object object = this;
            synchronized (object) {
                if (this._pending && !this.isExpired()) {
                    this._resumed = true;
                    redispatch = this._scheduled;
                }
            }
            if (redispatch) {
                object = this._endPoint._selectSet;
                synchronized (object) {
                    this.cancel();
                }
                this._endPoint._selectSet.addChange((Object)this);
                this._endPoint._selectSet.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this;
            synchronized (object) {
                this._resumed = false;
                this._pending = false;
                this._scheduled = false;
            }
            object = this._endPoint._selectSet;
            synchronized (object) {
                this.cancel();
            }
        }

        public Object getObject() {
            return this._object;
        }

        public void setObject(Object object) {
            this._object = object;
        }
    }

    public class SelectSet {
        private transient int _setID;
        private transient Timeout _idleTimeout;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient List[] _changes;
        private transient int _change;
        private transient int _nextSet;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout();
            this._idleTimeout.setDuration((long)SelectChannelConnector.this.getMaxIdleTime());
            this._retryTimeout = new Timeout();
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                Iterator<SelectionKey> iter = new ArrayList<SelectionKey>(this._selector.keys()).iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    HttpChannelEndPoint endpoint = (HttpChannelEndPoint)key.attachment();
                    if (endpoint == null) continue;
                    try {
                        endpoint.close();
                    }
                    catch (IOException e) {
                        Log.ignore((Throwable)e);
                    }
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept() throws IOException {
            long idle_next = 0L;
            long retry_next = 0L;
            List[] listArray = this._changes;
            synchronized (this._changes) {
                Object key;
                List changes = this._changes[this._change];
                this._change = this._change == 0 ? 1 : 0;
                // ** MonitorExit[var6_3] (shouldn't be in output)
                for (int i = 0; i < changes.size(); ++i) {
                    try {
                        Object o = changes.get(i);
                        if (o instanceof HttpChannelEndPoint) {
                            HttpChannelEndPoint endpoint = (HttpChannelEndPoint)o;
                            endpoint.syncKey();
                            continue;
                        }
                        if (o instanceof SocketChannel) {
                            SocketChannel channel = (SocketChannel)o;
                            SelectionKey cKey = channel.register(this._selector, 1);
                            HttpChannelEndPoint endpoint = SelectChannelConnector.this.newHttpChannelEndPoint(SelectChannelConnector.this, channel, this, cKey);
                            if (SelectChannelConnector.this._delaySelectKeyUpdate && endpoint.dispatch(SelectChannelConnector.this._delaySelectKeyUpdate)) {
                                this.dispatch(endpoint);
                            }
                            continue;
                        }
                        if (o instanceof RetryContinuation) {
                            this.dispatch(((RetryContinuation)((Object)o))._endPoint);
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    catch (CancelledKeyException e) {
                        if (SelectChannelConnector.this.isRunning()) {
                            Log.warn((Throwable)e);
                            continue;
                        }
                        Log.debug((Throwable)e);
                    }
                }
                changes.clear();
                SelectSet i = this;
                synchronized (i) {
                    this._idleTimeout.setDuration((long)SelectChannelConnector.this.getMaxIdleTime());
                    idle_next = this._idleTimeout.getTimeToNext();
                    retry_next = this._retryTimeout.getTimeToNext();
                }
                long wait = SelectChannelConnector.this.getMaxIdleTime();
                if (wait < 0L || idle_next >= 0L && wait > idle_next) {
                    wait = idle_next;
                }
                if (wait < 0L || retry_next >= 0L && wait > retry_next) {
                    wait = retry_next;
                }
                if (wait > 0L) {
                    this._selector.select(wait);
                } else if (wait == 0L) {
                    this._selector.selectNow();
                } else {
                    this._selector.select();
                }
                long now = -1L;
                if (!this._selector.isOpen()) {
                    return;
                }
                now = System.currentTimeMillis();
                this._idleTimeout.setNow(now);
                this._retryTimeout.setNow(now);
                Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    key = iter.next();
                    iter.remove();
                    try {
                        HttpChannelEndPoint endpoint;
                        if (!((SelectionKey)key).isValid()) {
                            ((SelectionKey)key).cancel();
                            endpoint = (HttpChannelEndPoint)((SelectionKey)key).attachment();
                            if (endpoint == null) continue;
                            endpoint.close();
                            if (endpoint._connection == null) continue;
                            SelectChannelConnector.this.connectionClosed(endpoint._connection);
                            continue;
                        }
                        if (key.equals(SelectChannelConnector.this._acceptKey)) {
                            if (((SelectionKey)key).isAcceptable()) {
                                SocketChannel channel = SelectChannelConnector.this._acceptChannel.accept();
                                if (channel == null) continue;
                                channel.configureBlocking(false);
                                Socket socket = channel.socket();
                                SelectChannelConnector.this.configure(socket);
                                ++this._nextSet;
                                this._nextSet %= SelectChannelConnector.this._selectSets.length;
                                if (this._nextSet != this._setID) {
                                    SelectChannelConnector.this._selectSets[this._nextSet].addChange(channel);
                                    SelectChannelConnector.this._selectSets[this._nextSet].wakeup();
                                } else {
                                    SelectionKey cKey = channel.register(SelectChannelConnector.this._selectSets[this._nextSet].getSelector(), 1);
                                    SelectChannelConnector.this.newHttpChannelEndPoint(SelectChannelConnector.this, channel, SelectChannelConnector.this._selectSets[this._nextSet], cKey);
                                }
                            }
                        } else {
                            endpoint = (HttpChannelEndPoint)((SelectionKey)key).attachment();
                            if (endpoint != null && endpoint.dispatch(SelectChannelConnector.this._delaySelectKeyUpdate)) {
                                this.dispatch(endpoint);
                            }
                        }
                        key = null;
                    }
                    catch (CancelledKeyException e) {
                        if (SelectChannelConnector.this.isRunning()) {
                            Log.warn((Throwable)e);
                            continue;
                        }
                        Log.ignore((Throwable)e);
                    }
                    catch (Exception e) {
                        if (SelectChannelConnector.this.isRunning()) {
                            Log.warn((Throwable)e);
                        } else {
                            Log.ignore((Throwable)e);
                        }
                        if (key == null || key == SelectChannelConnector.this._acceptKey) continue;
                        ((SelectionKey)key).interestOps(0);
                    }
                }
                key = this;
                synchronized (key) {
                    now = System.currentTimeMillis();
                    this._retryTimeout.setNow(now);
                    this._idleTimeout.setNow(now);
                }
                while (this._selector != null) {
                    Timeout.Task task = null;
                    SelectSet selectSet = this;
                    synchronized (selectSet) {
                        task = this._idleTimeout.expired();
                        if (task == null) {
                            task = this._retryTimeout.expired();
                        }
                    }
                    if (task == null) break;
                    task.expire();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch(HttpChannelEndPoint endpoint) {
            boolean dispatch_done = false;
            try {
                dispatch_done = SelectChannelConnector.this.getThreadPool().dispatch((Runnable)endpoint);
            }
            finally {
                if (!dispatch_done) {
                    Log.warn((String)("dispatch failed! threads=" + SelectChannelConnector.this.getThreadPool().getThreads() + " idle=" + SelectChannelConnector.this.getThreadPool().getIdleThreads()));
                    endpoint.undispatch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(HttpChannelEndPoint.IdleTask task, boolean idle) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(HttpChannelEndPoint.IdleTask task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }
    }
}

