/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.bccontrib.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.bccontrib.params.ParametersForThreefish;
import org.jitsi.bccontrib.util.ByteLong;

public class ThreefishCipher
implements BlockCipher {
    static final long KEY_SCHEDULE_CONST = 2004413935125273122L;
    static final int EXPANDED_TWEAK_SIZE = 3;
    private ThreefishCipher cipher;
    private boolean forEncryption;
    private int stateSize;
    long[] expanedKey;
    long[] expanedTweak = new long[3];
    private long[] cipherIn;
    private long[] cipherOut;

    public void setTweak(long[] tweak) {
        this.expanedTweak[0] = tweak[0];
        this.expanedTweak[1] = tweak[1];
        this.expanedTweak[2] = tweak[0] ^ tweak[1];
    }

    public void setKey(long[] key) {
        long parity = 2004413935125273122L;
        for (int i = 0; i < this.expanedKey.length - 1; ++i) {
            this.expanedKey[i] = key[i];
            parity ^= key[i];
        }
        this.expanedKey[i] = parity;
    }

    public static ThreefishCipher createCipher(int stateSize) {
        switch (stateSize) {
            case 256: {
                return new ThreefishCipher().new Threefish256();
            }
            case 512: {
                return new ThreefishCipher().new Threefish512();
            }
            case 1024: {
                return new ThreefishCipher().new Threefish1024();
            }
        }
        return null;
    }

    private void setCipher(int stateSize) {
        this.cipher = null;
        switch (stateSize) {
            case 256: {
                this.cipher = new Threefish256();
                break;
            }
            case 512: {
                this.cipher = new Threefish512();
                break;
            }
            case 1024: {
                this.cipher = new Threefish1024();
            }
        }
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersForThreefish) {
            ParametersForThreefish pft = (ParametersForThreefish)params;
            this.stateSize = pft.getStateSize();
            this.setCipher(this.stateSize);
            if (this.cipher == null) {
                throw new IllegalArgumentException("Threefish: unsupported state size: " + this.stateSize);
            }
            byte[] key = ((KeyParameter)pft.getParameters()).getKey();
            if (key.length != this.stateSize / 8) {
                throw new IllegalArgumentException("Threefish: key length does not match state size: " + key.length);
            }
            long[] tweak = pft.getTweak();
            if (tweak == null) {
                throw new IllegalArgumentException("Threefish: tweak data not set");
            }
            this.cipher.setTweak(tweak);
            long[] keyLong = new long[this.stateSize / 64];
            for (int i = 0; i < keyLong.length; ++i) {
                keyLong[i] = ByteLong.GetUInt64(key, i * 8);
            }
            this.cipher.setKey(keyLong);
            this.forEncryption = forEncryption;
            this.cipherIn = new long[this.stateSize / 64];
            this.cipherOut = new long[this.stateSize / 64];
            return;
        }
        throw new IllegalArgumentException("Threfish: invalid parameter passed to init - " + params.getClass().getName());
    }

    public String getAlgorithmName() {
        return "Threefish";
    }

    public int getBlockSize() {
        return this.stateSize / 8;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int blockLenByte = this.stateSize / 8;
        int blockLenLong = this.stateSize / 64;
        if (this.cipher.expanedKey == null) {
            throw new IllegalStateException("Threefish: engine not initialised");
        }
        if (inOff + blockLenByte > in.length) {
            throw new DataLengthException("Threefish: input buffer too short");
        }
        if (outOff + blockLenByte > out.length) {
            throw new DataLengthException("Threefish: output buffer too short");
        }
        for (int i = 0; i < blockLenLong; ++i) {
            this.cipherIn[i] = ByteLong.GetUInt64(in, inOff + i * 8);
        }
        if (this.forEncryption) {
            this.cipher.encrypt(this.cipherIn, this.cipherOut);
        } else {
            this.cipher.decrypt(this.cipherIn, this.cipherOut);
        }
        ByteLong.PutBytes(this.cipherOut, out, outOff, blockLenByte);
        return this.stateSize / 8;
    }

    public void reset() {
    }

    public void encrypt(long[] input, long[] output) {
    }

    public void decrypt(long[] input, long[] output) {
    }

    public class Threefish1024
    extends ThreefishCipher {
        private final int CIPHER_SIZE = 1024;
        private final int CIPHER_QWORDS = 16;
        private final int EXPANDED_KEY_SIZE = 17;

        public Threefish1024() {
            this.expanedKey = new long[17];
            this.expanedKey[16] = 2004413935125273122L;
        }

        public void encrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long b4 = input[4];
            long b5 = input[5];
            long b6 = input[6];
            long b7 = input[7];
            long b8 = input[8];
            long b9 = input[9];
            long b10 = input[10];
            long b11 = input[11];
            long b12 = input[12];
            long b13 = input[13];
            long b14 = input[14];
            long b15 = input[15];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long k5 = this.expanedKey[5];
            long k6 = this.expanedKey[6];
            long k7 = this.expanedKey[7];
            long k8 = this.expanedKey[8];
            long k9 = this.expanedKey[9];
            long k10 = this.expanedKey[10];
            long k11 = this.expanedKey[11];
            long k12 = this.expanedKey[12];
            long k13 = this.expanedKey[13];
            long k14 = this.expanedKey[14];
            long k15 = this.expanedKey[15];
            long k16 = this.expanedKey[16];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k1) + k0);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k3) + k2);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k5) + k4);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k7) + k6);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k9) + k8);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k11) + k10);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k13 + t0) + k12);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k15) + k14 + t1);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k2) + k1);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k4) + k3);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k6) + k5);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k8) + k7);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k10) + k9);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k12) + k11);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k14 + t1) + k13);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k16 + 1L) + k15 + t2);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k3) + k2);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k5) + k4);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k7) + k6);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k9) + k8);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k11) + k10);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k13) + k12);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k15 + t2) + k14);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k0 + 2L) + k16 + t0);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k4) + k3);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k6) + k5);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k8) + k7);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k10) + k9);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k12) + k11);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k14) + k13);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k16 + t0) + k15);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k1 + 3L) + k0 + t1);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k5) + k4);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k7) + k6);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k9) + k8);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k11) + k10);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k13) + k12);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k15) + k14);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k0 + t1) + k16);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k2 + 4L) + k1 + t2);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k6) + k5);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k8) + k7);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k10) + k9);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k12) + k11);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k14) + k13);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k16) + k15);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k1 + t2) + k0);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k3 + 5L) + k2 + t0);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k7) + k6);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k9) + k8);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k11) + k10);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k13) + k12);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k15) + k14);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k0) + k16);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k2 + t0) + k1);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k4 + 6L) + k3 + t1);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k8) + k7);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k10) + k9);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k12) + k11);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k14) + k13);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k16) + k15);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k1) + k0);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k3 + t1) + k2);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k5 + 7L) + k4 + t2);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k9) + k8);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k11) + k10);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k13) + k12);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k15) + k14);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k0) + k16);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k2) + k1);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k4 + t2) + k3);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k6 + 8L) + k5 + t0);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k10) + k9);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k12) + k11);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k14) + k13);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k16) + k15);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k1) + k0);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k3) + k2);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k5 + t0) + k4);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k7 + 9L) + k6 + t1);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k11) + k10);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k13) + k12);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k15) + k14);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k0) + k16);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k2) + k1);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k4) + k3);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k6 + t1) + k5);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k8 + 10L) + k7 + t2);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k12) + k11);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k14) + k13);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k16) + k15);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k1) + k0);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k3) + k2);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k5) + k4);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k7 + t2) + k6);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k9 + 11L) + k8 + t0);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k13) + k12);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k15) + k14);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k0) + k16);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k2) + k1);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k4) + k3);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k6) + k5);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k8 + t0) + k7);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k10 + 12L) + k9 + t1);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k14) + k13);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k16) + k15);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k1) + k0);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k3) + k2);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k5) + k4);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k7) + k6);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k9 + t1) + k8);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k11 + 13L) + k10 + t2);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k15) + k14);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k0) + k16);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k2) + k1);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k4) + k3);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k6) + k5);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k8) + k7);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k10 + t2) + k9);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k12 + 14L) + k11 + t0);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k16) + k15);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k1) + k0);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k3) + k2);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k5) + k4);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k7) + k6);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k9) + k8);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k11 + t0) + k10);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k13 + 15L) + k12 + t1);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k0) + k16);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k2) + k1);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k4) + k3);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k6) + k5);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k8) + k7);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k10) + k9);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k12 + t1) + k11);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k14 + 16L) + k13 + t2);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k1) + k0);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k3) + k2);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k5) + k4);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k7) + k6);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k9) + k8);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k11) + k10);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k13 + t2) + k12);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k15 + 17L) + k14 + t0);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            b1 = (b1 << 24 | b1 >>> 40) ^ (b0 += (b1 += k2) + k1);
            b3 = (b3 << 13 | b3 >>> 51) ^ (b2 += (b3 += k4) + k3);
            b5 = (b5 << 8 | b5 >>> 56) ^ (b4 += (b5 += k6) + k5);
            b7 = (b7 << 47 | b7 >>> 17) ^ (b6 += (b7 += k8) + k7);
            b9 = (b9 << 8 | b9 >>> 56) ^ (b8 += (b9 += k10) + k9);
            b11 = (b11 << 17 | b11 >>> 47) ^ (b10 += (b11 += k12) + k11);
            b13 = (b13 << 22 | b13 >>> 42) ^ (b12 += (b13 += k14 + t0) + k13);
            b15 = (b15 << 37 | b15 >>> 27) ^ (b14 += (b15 += k16 + 18L) + k15 + t1);
            b0 += b9;
            b9 = (b9 << 38 | b9 >>> 26) ^ b0;
            b2 += b13;
            b13 = (b13 << 19 | b13 >>> 45) ^ b2;
            b6 += b11;
            b11 = (b11 << 10 | b11 >>> 54) ^ b6;
            b4 += b15;
            b15 = (b15 << 55 | b15 >>> 9) ^ b4;
            b10 += b7;
            b7 = (b7 << 49 | b7 >>> 15) ^ b10;
            b12 += b3;
            b3 = (b3 << 18 | b3 >>> 46) ^ b12;
            b14 += b5;
            b5 = (b5 << 23 | b5 >>> 41) ^ b14;
            b8 += b1;
            b1 = (b1 << 52 | b1 >>> 12) ^ b8;
            b0 += b7;
            b7 = (b7 << 33 | b7 >>> 31) ^ b0;
            b2 += b5;
            b5 = (b5 << 4 | b5 >>> 60) ^ b2;
            b4 += b3;
            b3 = (b3 << 51 | b3 >>> 13) ^ b4;
            b6 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b6;
            b12 += b15;
            b15 = (b15 << 34 | b15 >>> 30) ^ b12;
            b14 += b13;
            b13 = (b13 << 41 | b13 >>> 23) ^ b14;
            b8 += b11;
            b11 = (b11 << 59 | b11 >>> 5) ^ b8;
            b10 += b9;
            b9 = (b9 << 17 | b9 >>> 47) ^ b10;
            b0 += b15;
            b15 = (b15 << 5 | b15 >>> 59) ^ b0;
            b2 += b11;
            b11 = (b11 << 20 | b11 >>> 44) ^ b2;
            b6 += b13;
            b13 = (b13 << 48 | b13 >>> 16) ^ b6;
            b4 += b9;
            b9 = (b9 << 41 | b9 >>> 23) ^ b4;
            b14 += b1;
            b1 = (b1 << 47 | b1 >>> 17) ^ b14;
            b8 += b5;
            b5 = (b5 << 28 | b5 >>> 36) ^ b8;
            b10 += b3;
            b3 = (b3 << 16 | b3 >>> 48) ^ b10;
            b12 += b7;
            b7 = (b7 << 25 | b7 >>> 39) ^ b12;
            b1 = (b1 << 41 | b1 >>> 23) ^ (b0 += (b1 += k3) + k2);
            b3 = (b3 << 9 | b3 >>> 55) ^ (b2 += (b3 += k5) + k4);
            b5 = (b5 << 37 | b5 >>> 27) ^ (b4 += (b5 += k7) + k6);
            b7 = (b7 << 31 | b7 >>> 33) ^ (b6 += (b7 += k9) + k8);
            b9 = (b9 << 12 | b9 >>> 52) ^ (b8 += (b9 += k11) + k10);
            b11 = (b11 << 47 | b11 >>> 17) ^ (b10 += (b11 += k13) + k12);
            b13 = (b13 << 44 | b13 >>> 20) ^ (b12 += (b13 += k15 + t1) + k14);
            b15 = (b15 << 30 | b15 >>> 34) ^ (b14 += (b15 += k0 + 19L) + k16 + t2);
            b0 += b9;
            b9 = (b9 << 16 | b9 >>> 48) ^ b0;
            b2 += b13;
            b13 = (b13 << 34 | b13 >>> 30) ^ b2;
            b6 += b11;
            b11 = (b11 << 56 | b11 >>> 8) ^ b6;
            b4 += b15;
            b15 = (b15 << 51 | b15 >>> 13) ^ b4;
            b10 += b7;
            b7 = (b7 << 4 | b7 >>> 60) ^ b10;
            b12 += b3;
            b3 = (b3 << 53 | b3 >>> 11) ^ b12;
            b14 += b5;
            b5 = (b5 << 42 | b5 >>> 22) ^ b14;
            b8 += b1;
            b1 = (b1 << 41 | b1 >>> 23) ^ b8;
            b0 += b7;
            b7 = (b7 << 31 | b7 >>> 33) ^ b0;
            b2 += b5;
            b5 = (b5 << 44 | b5 >>> 20) ^ b2;
            b4 += b3;
            b3 = (b3 << 47 | b3 >>> 17) ^ b4;
            b6 += b1;
            b1 = (b1 << 46 | b1 >>> 18) ^ b6;
            b12 += b15;
            b15 = (b15 << 19 | b15 >>> 45) ^ b12;
            b14 += b13;
            b13 = (b13 << 42 | b13 >>> 22) ^ b14;
            b8 += b11;
            b11 = (b11 << 44 | b11 >>> 20) ^ b8;
            b10 += b9;
            b9 = (b9 << 25 | b9 >>> 39) ^ b10;
            b0 += b15;
            b15 = (b15 << 9 | b15 >>> 55) ^ b0;
            b2 += b11;
            b11 = (b11 << 48 | b11 >>> 16) ^ b2;
            b6 += b13;
            b13 = (b13 << 35 | b13 >>> 29) ^ b6;
            b4 += b9;
            b9 = (b9 << 52 | b9 >>> 12) ^ b4;
            b14 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b14;
            b8 += b5;
            b5 = (b5 << 31 | b5 >>> 33) ^ b8;
            b10 += b3;
            b3 = (b3 << 37 | b3 >>> 27) ^ b10;
            b12 += b7;
            b7 = (b7 << 20 | b7 >>> 44) ^ b12;
            output[0] = b0 + k3;
            output[1] = b1 + k4;
            output[2] = b2 + k5;
            output[3] = b3 + k6;
            output[4] = b4 + k7;
            output[5] = b5 + k8;
            output[6] = b6 + k9;
            output[7] = b7 + k10;
            output[8] = b8 + k11;
            output[9] = b9 + k12;
            output[10] = b10 + k13;
            output[11] = b11 + k14;
            output[12] = b12 + k15;
            output[13] = b13 + k16 + t2;
            output[14] = b14 + k0 + t0;
            output[15] = b15 + k1 + 20L;
        }

        public void decrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long b4 = input[4];
            long b5 = input[5];
            long b6 = input[6];
            long b7 = input[7];
            long b8 = input[8];
            long b9 = input[9];
            long b10 = input[10];
            long b11 = input[11];
            long b12 = input[12];
            long b13 = input[13];
            long b14 = input[14];
            long b15 = input[15];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long k5 = this.expanedKey[5];
            long k6 = this.expanedKey[6];
            long k7 = this.expanedKey[7];
            long k8 = this.expanedKey[8];
            long k9 = this.expanedKey[9];
            long k10 = this.expanedKey[10];
            long k11 = this.expanedKey[11];
            long k12 = this.expanedKey[12];
            long k13 = this.expanedKey[13];
            long k14 = this.expanedKey[14];
            long k15 = this.expanedKey[15];
            long k16 = this.expanedKey[16];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            b0 -= k3;
            b1 -= k4;
            b2 -= k5;
            b3 -= k6;
            b4 -= k7;
            b5 -= k8;
            b6 -= k9;
            b7 -= k10;
            b8 -= k11;
            b9 -= k12;
            b10 -= k13;
            b11 -= k14;
            b13 -= k16 + t2;
            b14 -= k0 + t0;
            b15 -= k1 + 20L;
            long tmp = b7 ^ (b12 -= k15);
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k16 + t2;
            b15 -= k0 + 19L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k14;
            b13 -= k15 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k12;
            b11 -= k13;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k10;
            b9 -= k11;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k8;
            b7 -= k9;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k6;
            b5 -= k7;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k4;
            b3 -= k5;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k2;
            b1 -= k3;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k15 + t1;
            b15 -= k16 + 18L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k13;
            b13 -= k14 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k11;
            b11 -= k12;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k9;
            b9 -= k10;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k7;
            b7 -= k8;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k5;
            b5 -= k6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k3;
            b3 -= k4;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k1;
            b1 -= k2;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k14 + t0;
            b15 -= k15 + 17L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k12;
            b13 -= k13 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k10;
            b11 -= k11;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k8;
            b9 -= k9;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k6;
            b7 -= k7;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k4;
            b5 -= k5;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k2;
            b3 -= k3;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k0;
            b1 -= k1;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k13 + t2;
            b15 -= k14 + 16L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k11;
            b13 -= k12 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k9;
            b11 -= k10;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k7;
            b9 -= k8;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k5;
            b7 -= k6;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k3;
            b5 -= k4;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k1;
            b3 -= k2;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k16;
            b1 -= k0;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k12 + t1;
            b15 -= k13 + 15L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k10;
            b13 -= k11 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k8;
            b11 -= k9;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k6;
            b9 -= k7;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k4;
            b7 -= k5;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k2;
            b5 -= k3;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k0;
            b3 -= k1;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k15;
            b1 -= k16;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k11 + t0;
            b15 -= k12 + 14L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k9;
            b13 -= k10 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k7;
            b11 -= k8;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k5;
            b9 -= k6;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k3;
            b7 -= k4;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k1;
            b5 -= k2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k16;
            b3 -= k0;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k14;
            b1 -= k15;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k10 + t2;
            b15 -= k11 + 13L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k8;
            b13 -= k9 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k6;
            b11 -= k7;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k4;
            b9 -= k5;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k2;
            b7 -= k3;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k0;
            b5 -= k1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k15;
            b3 -= k16;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k13;
            b1 -= k14;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k9 + t1;
            b15 -= k10 + 12L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k7;
            b13 -= k8 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k5;
            b11 -= k6;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k3;
            b9 -= k4;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k1;
            b7 -= k2;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k16;
            b5 -= k0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k14;
            b3 -= k15;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k12;
            b1 -= k13;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k8 + t0;
            b15 -= k9 + 11L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k6;
            b13 -= k7 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k4;
            b11 -= k5;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k2;
            b9 -= k3;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k0;
            b7 -= k1;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k15;
            b5 -= k16;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k13;
            b3 -= k14;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k11;
            b1 -= k12;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k7 + t2;
            b15 -= k8 + 10L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k5;
            b13 -= k6 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k3;
            b11 -= k4;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k1;
            b9 -= k2;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k16;
            b7 -= k0;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k14;
            b5 -= k15;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k12;
            b3 -= k13;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k10;
            b1 -= k11;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k6 + t1;
            b15 -= k7 + 9L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k4;
            b13 -= k5 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k2;
            b11 -= k3;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k0;
            b9 -= k1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k15;
            b7 -= k16;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k13;
            b5 -= k14;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k11;
            b3 -= k12;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k9;
            b1 -= k10;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k5 + t0;
            b15 -= k6 + 8L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k3;
            b13 -= k4 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k1;
            b11 -= k2;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k16;
            b9 -= k0;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k14;
            b7 -= k15;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k12;
            b5 -= k13;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k10;
            b3 -= k11;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k8;
            b1 -= k9;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k4 + t2;
            b15 -= k5 + 7L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k2;
            b13 -= k3 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k0;
            b11 -= k1;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k15;
            b9 -= k16;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k13;
            b7 -= k14;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k11;
            b5 -= k12;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k9;
            b3 -= k10;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k7;
            b1 -= k8;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k3 + t1;
            b15 -= k4 + 6L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k1;
            b13 -= k2 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k16;
            b11 -= k0;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k14;
            b9 -= k15;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k12;
            b7 -= k13;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k10;
            b5 -= k11;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k8;
            b3 -= k9;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k6;
            b1 -= k7;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k2 + t0;
            b15 -= k3 + 5L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k0;
            b13 -= k1 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k15;
            b11 -= k16;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k13;
            b9 -= k14;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k11;
            b7 -= k12;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k9;
            b5 -= k10;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k7;
            b3 -= k8;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k5;
            b1 -= k6;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k1 + t2;
            b15 -= k2 + 4L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k16;
            b13 -= k0 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k14;
            b11 -= k15;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k12;
            b9 -= k13;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k10;
            b7 -= k11;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k8;
            b5 -= k9;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k6;
            b3 -= k7;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k4;
            b1 -= k5;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k0 + t1;
            b15 -= k1 + 3L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k15;
            b13 -= k16 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k13;
            b11 -= k14;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k11;
            b9 -= k12;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k9;
            b7 -= k10;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k7;
            b5 -= k8;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k5;
            b3 -= k6;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k3;
            b1 -= k4;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k16 + t0;
            b15 -= k0 + 2L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k14;
            b13 -= k15 + t2;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k12;
            b11 -= k13;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k10;
            b9 -= k11;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k8;
            b7 -= k9;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k6;
            b5 -= k7;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k4;
            b3 -= k5;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k2;
            b1 -= k3;
            tmp = b7 ^ b12;
            b7 = tmp >>> 20 | tmp << 44;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 37 | tmp << 27;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 31 | tmp << 33;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 23 | tmp << 41;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 52 | tmp << 12;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 35 | tmp << 29;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 48 | tmp << 16;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 9 | tmp << 55;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 25 | tmp << 39;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 44 | tmp << 20;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 42 | tmp << 22;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 19 | tmp << 45;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 46 | tmp << 18;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 47 | tmp << 17;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 44 | tmp << 20;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 31 | tmp << 33;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 41 | tmp << 23;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 42 | tmp << 22;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 53 | tmp << 11;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 4 | tmp << 60;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 51 | tmp << 13;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 56 | tmp << 8;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 34 | tmp << 30;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 16 | tmp << 48;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 30 | tmp << 34;
            b14 -= b15 + k15 + t2;
            b15 -= k16 + 1L;
            tmp = b13 ^ b12;
            b13 = tmp >>> 44 | tmp << 20;
            b12 -= b13 + k13;
            b13 -= k14 + t1;
            tmp = b11 ^ b10;
            b11 = tmp >>> 47 | tmp << 17;
            b10 -= b11 + k11;
            b11 -= k12;
            tmp = b9 ^ b8;
            b9 = tmp >>> 12 | tmp << 52;
            b8 -= b9 + k9;
            b9 -= k10;
            tmp = b7 ^ b6;
            b7 = tmp >>> 31 | tmp << 33;
            b6 -= b7 + k7;
            b7 -= k8;
            tmp = b5 ^ b4;
            b5 = tmp >>> 37 | tmp << 27;
            b4 -= b5 + k5;
            b5 -= k6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 9 | tmp << 55;
            b2 -= b3 + k3;
            b3 -= k4;
            tmp = b1 ^ b0;
            b1 = tmp >>> 41 | tmp << 23;
            b0 -= b1 + k1;
            b1 -= k2;
            tmp = b7 ^ b12;
            b7 = tmp >>> 25 | tmp << 39;
            b12 -= b7;
            tmp = b3 ^ b10;
            b3 = tmp >>> 16 | tmp << 48;
            b10 -= b3;
            tmp = b5 ^ b8;
            b5 = tmp >>> 28 | tmp << 36;
            b8 -= b5;
            tmp = b1 ^ b14;
            b1 = tmp >>> 47 | tmp << 17;
            b14 -= b1;
            tmp = b9 ^ b4;
            b9 = tmp >>> 41 | tmp << 23;
            b4 -= b9;
            tmp = b13 ^ b6;
            b13 = tmp >>> 48 | tmp << 16;
            b6 -= b13;
            tmp = b11 ^ b2;
            b11 = tmp >>> 20 | tmp << 44;
            b2 -= b11;
            tmp = b15 ^ b0;
            b15 = tmp >>> 5 | tmp << 59;
            b0 -= b15;
            tmp = b9 ^ b10;
            b9 = tmp >>> 17 | tmp << 47;
            b10 -= b9;
            tmp = b11 ^ b8;
            b11 = tmp >>> 59 | tmp << 5;
            b8 -= b11;
            tmp = b13 ^ b14;
            b13 = tmp >>> 41 | tmp << 23;
            b14 -= b13;
            tmp = b15 ^ b12;
            b15 = tmp >>> 34 | tmp << 30;
            b12 -= b15;
            tmp = b1 ^ b6;
            b1 = tmp >>> 13 | tmp << 51;
            b6 -= b1;
            tmp = b3 ^ b4;
            b3 = tmp >>> 51 | tmp << 13;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 4 | tmp << 60;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 33 | tmp << 31;
            b0 -= b7;
            tmp = b1 ^ b8;
            b1 = tmp >>> 52 | tmp << 12;
            b8 -= b1;
            tmp = b5 ^ b14;
            b5 = tmp >>> 23 | tmp << 41;
            b14 -= b5;
            tmp = b3 ^ b12;
            b3 = tmp >>> 18 | tmp << 46;
            b12 -= b3;
            tmp = b7 ^ b10;
            b7 = tmp >>> 49 | tmp << 15;
            b10 -= b7;
            tmp = b15 ^ b4;
            b15 = tmp >>> 55 | tmp << 9;
            b4 -= b15;
            tmp = b11 ^ b6;
            b11 = tmp >>> 10 | tmp << 54;
            b6 -= b11;
            tmp = b13 ^ b2;
            b13 = tmp >>> 19 | tmp << 45;
            b2 -= b13;
            tmp = b9 ^ b0;
            b9 = tmp >>> 38 | tmp << 26;
            b0 -= b9;
            tmp = b15 ^ b14;
            b15 = tmp >>> 37 | tmp << 27;
            b14 -= b15 + k14 + t1;
            b15 -= k15;
            tmp = b13 ^ b12;
            b13 = tmp >>> 22 | tmp << 42;
            b12 -= b13 + k12;
            b13 -= k13 + t0;
            tmp = b11 ^ b10;
            b11 = tmp >>> 17 | tmp << 47;
            b10 -= b11 + k10;
            b11 -= k11;
            tmp = b9 ^ b8;
            b9 = tmp >>> 8 | tmp << 56;
            b8 -= b9 + k8;
            b9 -= k9;
            tmp = b7 ^ b6;
            b7 = tmp >>> 47 | tmp << 17;
            b6 -= b7 + k6;
            b7 -= k7;
            tmp = b5 ^ b4;
            b5 = tmp >>> 8 | tmp << 56;
            b4 -= b5 + k4;
            b5 -= k5;
            tmp = b3 ^ b2;
            b3 = tmp >>> 13 | tmp << 51;
            b2 -= b3 + k2;
            b3 -= k3;
            tmp = b1 ^ b0;
            b1 = tmp >>> 24 | tmp << 40;
            b0 -= b1 + k0;
            b1 -= k1;
            output[15] = b15;
            output[14] = b14;
            output[13] = b13;
            output[12] = b12;
            output[11] = b11;
            output[10] = b10;
            output[9] = b9;
            output[8] = b8;
            output[7] = b7;
            output[6] = b6;
            output[5] = b5;
            output[4] = b4;
            output[3] = b3;
            output[2] = b2;
            output[1] = b1;
            output[0] = b0;
        }
    }

    public class Threefish512
    extends ThreefishCipher {
        private final int CIPHER_SIZE = 512;
        private final int CIPHER_QWORDS = 8;
        private final int EXPANDED_KEY_SIZE = 9;

        public Threefish512() {
            this.expanedKey = new long[9];
            this.expanedKey[8] = 2004413935125273122L;
        }

        public void encrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long b4 = input[4];
            long b5 = input[5];
            long b6 = input[6];
            long b7 = input[7];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long k5 = this.expanedKey[5];
            long k6 = this.expanedKey[6];
            long k7 = this.expanedKey[7];
            long k8 = this.expanedKey[8];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k1) + k0);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k3) + k2);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k5 + t0) + k4);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k7) + k6 + t1);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k2) + k1);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k4) + k3);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k6 + t1) + k5);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k8 + 1L) + k7 + t2);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k3) + k2);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k5) + k4);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k7 + t2) + k6);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k0 + 2L) + k8 + t0);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k4) + k3);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k6) + k5);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k8 + t0) + k7);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k1 + 3L) + k0 + t1);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k5) + k4);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k7) + k6);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k0 + t1) + k8);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k2 + 4L) + k1 + t2);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k6) + k5);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k8) + k7);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k1 + t2) + k0);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k3 + 5L) + k2 + t0);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k7) + k6);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k0) + k8);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k2 + t0) + k1);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k4 + 6L) + k3 + t1);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k8) + k7);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k1) + k0);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k3 + t1) + k2);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k5 + 7L) + k4 + t2);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k0) + k8);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k2) + k1);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k4 + t2) + k3);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k6 + 8L) + k5 + t0);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k1) + k0);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k3) + k2);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k5 + t0) + k4);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k7 + 9L) + k6 + t1);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k2) + k1);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k4) + k3);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k6 + t1) + k5);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k8 + 10L) + k7 + t2);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k3) + k2);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k5) + k4);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k7 + t2) + k6);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k0 + 11L) + k8 + t0);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k4) + k3);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k6) + k5);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k8 + t0) + k7);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k1 + 12L) + k0 + t1);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k5) + k4);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k7) + k6);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k0 + t1) + k8);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k2 + 13L) + k1 + t2);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k6) + k5);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k8) + k7);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k1 + t2) + k0);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k3 + 14L) + k2 + t0);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k7) + k6);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k0) + k8);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k2 + t0) + k1);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k4 + 15L) + k3 + t1);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            b1 = (b1 << 46 | b1 >>> 18) ^ (b0 += (b1 += k8) + k7);
            b3 = (b3 << 36 | b3 >>> 28) ^ (b2 += (b3 += k1) + k0);
            b5 = (b5 << 19 | b5 >>> 45) ^ (b4 += (b5 += k3 + t1) + k2);
            b7 = (b7 << 37 | b7 >>> 27) ^ (b6 += (b7 += k5 + 16L) + k4 + t2);
            b2 += b1;
            b1 = (b1 << 33 | b1 >>> 31) ^ b2;
            b4 += b7;
            b7 = (b7 << 27 | b7 >>> 37) ^ b4;
            b6 += b5;
            b5 = (b5 << 14 | b5 >>> 50) ^ b6;
            b0 += b3;
            b3 = (b3 << 42 | b3 >>> 22) ^ b0;
            b4 += b1;
            b1 = (b1 << 17 | b1 >>> 47) ^ b4;
            b6 += b3;
            b3 = (b3 << 49 | b3 >>> 15) ^ b6;
            b0 += b5;
            b5 = (b5 << 36 | b5 >>> 28) ^ b0;
            b2 += b7;
            b7 = (b7 << 39 | b7 >>> 25) ^ b2;
            b6 += b1;
            b1 = (b1 << 44 | b1 >>> 20) ^ b6;
            b0 += b7;
            b7 = (b7 << 9 | b7 >>> 55) ^ b0;
            b2 += b5;
            b5 = (b5 << 54 | b5 >>> 10) ^ b2;
            b4 += b3;
            b3 = (b3 << 56 | b3 >>> 8) ^ b4;
            b1 = (b1 << 39 | b1 >>> 25) ^ (b0 += (b1 += k0) + k8);
            b3 = (b3 << 30 | b3 >>> 34) ^ (b2 += (b3 += k2) + k1);
            b5 = (b5 << 34 | b5 >>> 30) ^ (b4 += (b5 += k4 + t2) + k3);
            b7 = (b7 << 24 | b7 >>> 40) ^ (b6 += (b7 += k6 + 17L) + k5 + t0);
            b2 += b1;
            b1 = (b1 << 13 | b1 >>> 51) ^ b2;
            b4 += b7;
            b7 = (b7 << 50 | b7 >>> 14) ^ b4;
            b6 += b5;
            b5 = (b5 << 10 | b5 >>> 54) ^ b6;
            b0 += b3;
            b3 = (b3 << 17 | b3 >>> 47) ^ b0;
            b4 += b1;
            b1 = (b1 << 25 | b1 >>> 39) ^ b4;
            b6 += b3;
            b3 = (b3 << 29 | b3 >>> 35) ^ b6;
            b0 += b5;
            b5 = (b5 << 39 | b5 >>> 25) ^ b0;
            b2 += b7;
            b7 = (b7 << 43 | b7 >>> 21) ^ b2;
            b6 += b1;
            b1 = (b1 << 8 | b1 >>> 56) ^ b6;
            b0 += b7;
            b7 = (b7 << 35 | b7 >>> 29) ^ b0;
            b2 += b5;
            b5 = (b5 << 56 | b5 >>> 8) ^ b2;
            b4 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b4;
            output[0] = b0 + k0;
            output[1] = b1 + k1;
            output[2] = b2 + k2;
            output[3] = b3 + k3;
            output[4] = b4 + k4;
            output[5] = b5 + k5 + t0;
            output[6] = b6 + k6 + t1;
            output[7] = b7 + k7 + 18L;
        }

        public void decrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long b4 = input[4];
            long b5 = input[5];
            long b6 = input[6];
            long b7 = input[7];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long k5 = this.expanedKey[5];
            long k6 = this.expanedKey[6];
            long k7 = this.expanedKey[7];
            long k8 = this.expanedKey[8];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            b0 -= k0;
            b1 -= k1;
            b2 -= k2;
            b5 -= k5 + t0;
            b6 -= k6 + t1;
            b7 -= k7 + 18L;
            long tmp = (b3 -= k3) ^ (b4 -= k4);
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k5 + t0;
            b7 -= k6 + 17L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k3;
            b5 -= k4 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k1;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k8;
            b1 -= k0;
            tmp = (b3 -= k2) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k4 + t2;
            b7 -= k5 + 16L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k2;
            b5 -= k3 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k0;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k7;
            b1 -= k8;
            tmp = (b3 -= k1) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k3 + t1;
            b7 -= k4 + 15L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k1;
            b5 -= k2 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k8;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k6;
            b1 -= k7;
            tmp = (b3 -= k0) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k2 + t0;
            b7 -= k3 + 14L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k0;
            b5 -= k1 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k7;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k5;
            b1 -= k6;
            tmp = (b3 -= k8) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k1 + t2;
            b7 -= k2 + 13L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k8;
            b5 -= k0 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k6;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k4;
            b1 -= k5;
            tmp = (b3 -= k7) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k0 + t1;
            b7 -= k1 + 12L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k7;
            b5 -= k8 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k5;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k3;
            b1 -= k4;
            tmp = (b3 -= k6) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k8 + t0;
            b7 -= k0 + 11L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k6;
            b5 -= k7 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k4;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k2;
            b1 -= k3;
            tmp = (b3 -= k5) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k7 + t2;
            b7 -= k8 + 10L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k5;
            b5 -= k6 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k3;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k1;
            b1 -= k2;
            tmp = (b3 -= k4) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k6 + t1;
            b7 -= k7 + 9L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k4;
            b5 -= k5 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k2;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k0;
            b1 -= k1;
            tmp = (b3 -= k3) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k5 + t0;
            b7 -= k6 + 8L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k3;
            b5 -= k4 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k1;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k8;
            b1 -= k0;
            tmp = (b3 -= k2) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k4 + t2;
            b7 -= k5 + 7L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k2;
            b5 -= k3 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k0;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k7;
            b1 -= k8;
            tmp = (b3 -= k1) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k3 + t1;
            b7 -= k4 + 6L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k1;
            b5 -= k2 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k8;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k6;
            b1 -= k7;
            tmp = (b3 -= k0) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k2 + t0;
            b7 -= k3 + 5L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k0;
            b5 -= k1 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k7;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k5;
            b1 -= k6;
            tmp = (b3 -= k8) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k1 + t2;
            b7 -= k2 + 4L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k8;
            b5 -= k0 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k6;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k4;
            b1 -= k5;
            tmp = (b3 -= k7) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k0 + t1;
            b7 -= k1 + 3L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k7;
            b5 -= k8 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k5;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k3;
            b1 -= k4;
            tmp = (b3 -= k6) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k8 + t0;
            b7 -= k0 + 2L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k6;
            b5 -= k7 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k4;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k2;
            b1 -= k3;
            tmp = (b3 -= k5) ^ b4;
            b3 = tmp >>> 22 | tmp << 42;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 56 | tmp << 8;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 35 | tmp << 29;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 8 | tmp << 56;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 43 | tmp << 21;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 39 | tmp << 25;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 29 | tmp << 35;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 25 | tmp << 39;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 17 | tmp << 47;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 10 | tmp << 54;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 50 | tmp << 14;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 13 | tmp << 51;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 24 | tmp << 40;
            b6 -= b7 + k7 + t2;
            b7 -= k8 + 1L;
            tmp = b5 ^ b4;
            b5 = tmp >>> 34 | tmp << 30;
            b4 -= b5 + k5;
            b5 -= k6 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 30 | tmp << 34;
            b2 -= b3 + k3;
            tmp = b1 ^ b0;
            b1 = tmp >>> 39 | tmp << 25;
            b0 -= b1 + k1;
            b1 -= k2;
            tmp = (b3 -= k4) ^ b4;
            b3 = tmp >>> 56 | tmp << 8;
            b4 -= b3;
            tmp = b5 ^ b2;
            b5 = tmp >>> 54 | tmp << 10;
            b2 -= b5;
            tmp = b7 ^ b0;
            b7 = tmp >>> 9 | tmp << 55;
            b0 -= b7;
            tmp = b1 ^ b6;
            b1 = tmp >>> 44 | tmp << 20;
            b6 -= b1;
            tmp = b7 ^ b2;
            b7 = tmp >>> 39 | tmp << 25;
            b2 -= b7;
            tmp = b5 ^ b0;
            b5 = tmp >>> 36 | tmp << 28;
            b0 -= b5;
            tmp = b3 ^ b6;
            b3 = tmp >>> 49 | tmp << 15;
            b6 -= b3;
            tmp = b1 ^ b4;
            b1 = tmp >>> 17 | tmp << 47;
            b4 -= b1;
            tmp = b3 ^ b0;
            b3 = tmp >>> 42 | tmp << 22;
            b0 -= b3;
            tmp = b5 ^ b6;
            b5 = tmp >>> 14 | tmp << 50;
            b6 -= b5;
            tmp = b7 ^ b4;
            b7 = tmp >>> 27 | tmp << 37;
            b4 -= b7;
            tmp = b1 ^ b2;
            b1 = tmp >>> 33 | tmp << 31;
            b2 -= b1;
            tmp = b7 ^ b6;
            b7 = tmp >>> 37 | tmp << 27;
            b6 -= b7 + k6 + t1;
            b7 -= k7;
            tmp = b5 ^ b4;
            b5 = tmp >>> 19 | tmp << 45;
            b4 -= b5 + k4;
            b5 -= k5 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 36 | tmp << 28;
            b2 -= b3 + k2;
            b3 -= k3;
            tmp = b1 ^ b0;
            b1 = tmp >>> 46 | tmp << 18;
            b0 -= b1 + k0;
            b1 -= k1;
            output[7] = b7;
            output[6] = b6;
            output[5] = b5;
            output[4] = b4;
            output[3] = b3;
            output[2] = b2;
            output[1] = b1;
            output[0] = b0;
        }
    }

    public class Threefish256
    extends ThreefishCipher {
        final int CIPHER_SIZE = 256;
        final int CIPHER_QWORDS = 4;
        final int EXPANDED_KEY_SIZE = 5;

        public Threefish256() {
            this.expanedKey = new long[5];
            this.expanedKey[4] = 2004413935125273122L;
        }

        public void encrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k1 + t0) + k0);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k3) + k2 + t1);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k2 + t1) + k1);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k4 + 1L) + k3 + t2);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k3 + t2) + k2);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k0 + 2L) + k4 + t0);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k4 + t0) + k3);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k1 + 3L) + k0 + t1);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k0 + t1) + k4);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k2 + 4L) + k1 + t2);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k1 + t2) + k0);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k3 + 5L) + k2 + t0);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k2 + t0) + k1);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k4 + 6L) + k3 + t1);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k3 + t1) + k2);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k0 + 7L) + k4 + t2);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k4 + t2) + k3);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k1 + 8L) + k0 + t0);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k0 + t0) + k4);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k2 + 9L) + k1 + t1);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k1 + t1) + k0);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k3 + 10L) + k2 + t2);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k2 + t2) + k1);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k4 + 11L) + k3 + t0);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k3 + t0) + k2);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k0 + 12L) + k4 + t1);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k4 + t1) + k3);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k1 + 13L) + k0 + t2);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k0 + t2) + k4);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k2 + 14L) + k1 + t0);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k1 + t0) + k0);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k3 + 15L) + k2 + t1);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            b1 = (b1 << 14 | b1 >>> 50) ^ (b0 += (b1 += k2 + t1) + k1);
            b3 = (b3 << 16 | b3 >>> 48) ^ (b2 += (b3 += k4 + 16L) + k3 + t2);
            b0 += b3;
            b3 = (b3 << 52 | b3 >>> 12) ^ b0;
            b2 += b1;
            b1 = (b1 << 57 | b1 >>> 7) ^ b2;
            b0 += b1;
            b1 = (b1 << 23 | b1 >>> 41) ^ b0;
            b2 += b3;
            b3 = (b3 << 40 | b3 >>> 24) ^ b2;
            b0 += b3;
            b3 = (b3 << 5 | b3 >>> 59) ^ b0;
            b2 += b1;
            b1 = (b1 << 37 | b1 >>> 27) ^ b2;
            b1 = (b1 << 25 | b1 >>> 39) ^ (b0 += (b1 += k3 + t2) + k2);
            b3 = (b3 << 33 | b3 >>> 31) ^ (b2 += (b3 += k0 + 17L) + k4 + t0);
            b0 += b3;
            b3 = (b3 << 46 | b3 >>> 18) ^ b0;
            b2 += b1;
            b1 = (b1 << 12 | b1 >>> 52) ^ b2;
            b0 += b1;
            b1 = (b1 << 58 | b1 >>> 6) ^ b0;
            b2 += b3;
            b3 = (b3 << 22 | b3 >>> 42) ^ b2;
            b0 += b3;
            b3 = (b3 << 32 | b3 >>> 32) ^ b0;
            b2 += b1;
            b1 = (b1 << 32 | b1 >>> 32) ^ b2;
            output[0] = b0 + k3;
            output[1] = b1 + k4 + t0;
            output[2] = b2 + k0 + t1;
            output[3] = b3 + k1 + 18L;
        }

        public void decrypt(long[] input, long[] output) {
            long b0 = input[0];
            long b1 = input[1];
            long b2 = input[2];
            long b3 = input[3];
            long k0 = this.expanedKey[0];
            long k1 = this.expanedKey[1];
            long k2 = this.expanedKey[2];
            long k3 = this.expanedKey[3];
            long k4 = this.expanedKey[4];
            long t0 = this.expanedTweak[0];
            long t1 = this.expanedTweak[1];
            long t2 = this.expanedTweak[2];
            long tmp = (b3 -= k1 + 18L) ^ (b0 -= k3);
            b3 = tmp >>> 32 | tmp << 32;
            tmp = (b1 -= k4 + t0) ^ (b2 -= k0 + t1);
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k2;
            b1 -= k3 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k4 + t0;
            tmp = (b3 -= k0 + 17L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k1;
            b1 -= k2 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k3 + t2;
            tmp = (b3 -= k4 + 16L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k0;
            b1 -= k1 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k2 + t1;
            tmp = (b3 -= k3 + 15L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k4;
            b1 -= k0 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k1 + t0;
            tmp = (b3 -= k2 + 14L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k3;
            b1 -= k4 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k0 + t2;
            tmp = (b3 -= k1 + 13L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k2;
            b1 -= k3 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k4 + t1;
            tmp = (b3 -= k0 + 12L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k1;
            b1 -= k2 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k3 + t0;
            tmp = (b3 -= k4 + 11L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k0;
            b1 -= k1 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k2 + t2;
            tmp = (b3 -= k3 + 10L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k4;
            b1 -= k0 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k1 + t1;
            tmp = (b3 -= k2 + 9L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k3;
            b1 -= k4 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k0 + t0;
            tmp = (b3 -= k1 + 8L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k2;
            b1 -= k3 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k4 + t2;
            tmp = (b3 -= k0 + 7L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k1;
            b1 -= k2 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k3 + t1;
            tmp = (b3 -= k4 + 6L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k0;
            b1 -= k1 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k2 + t0;
            tmp = (b3 -= k3 + 5L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k4;
            b1 -= k0 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k1 + t2;
            tmp = (b3 -= k2 + 4L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k3;
            b1 -= k4 + t0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k0 + t1;
            tmp = (b3 -= k1 + 3L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k2;
            b1 -= k3 + t2;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k4 + t0;
            tmp = (b3 -= k0 + 2L) ^ b0;
            b3 = tmp >>> 32 | tmp << 32;
            tmp = b1 ^ b2;
            b1 = tmp >>> 32 | tmp << 32;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 58 | tmp << 6;
            tmp = b3 ^ b2;
            b3 = tmp >>> 22 | tmp << 42;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 46 | tmp << 18;
            tmp = b1 ^ b2;
            b1 = tmp >>> 12 | tmp << 52;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 25 | tmp << 39;
            b0 -= b1 + k1;
            b1 -= k2 + t1;
            tmp = b3 ^ b2;
            b3 = tmp >>> 33 | tmp << 31;
            b2 -= b3 + k3 + t2;
            tmp = (b3 -= k4 + 1L) ^ b0;
            b3 = tmp >>> 5 | tmp << 59;
            tmp = b1 ^ b2;
            b1 = tmp >>> 37 | tmp << 27;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 23 | tmp << 41;
            tmp = b3 ^ b2;
            b3 = tmp >>> 40 | tmp << 24;
            b2 -= b3;
            tmp = b3 ^ (b0 -= b1);
            b3 = tmp >>> 52 | tmp << 12;
            tmp = b1 ^ b2;
            b1 = tmp >>> 57 | tmp << 7;
            b2 -= b1;
            tmp = b1 ^ (b0 -= b3);
            b1 = tmp >>> 14 | tmp << 50;
            b0 -= b1 + k0;
            tmp = b3 ^ b2;
            b3 = tmp >>> 16 | tmp << 48;
            b2 -= b3 + k2 + t1;
            output[0] = b0;
            output[1] = b1 -= k1 + t0;
            output[2] = b2;
            output[3] = b3 -= k3;
        }
    }
}

