/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.version;

import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import org.jitsi.service.version.Version;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

public class VersionManager
implements RegistrationStateChangeListener,
PacketListener {
    private ProtocolProviderServiceJabberImpl parentProvider = null;

    public VersionManager(ProtocolProviderServiceJabberImpl parentProvider) {
        this.parentProvider = parentProvider;
        this.parentProvider.addRegistrationStateChangeListener(this);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState() == RegistrationState.REGISTERED) {
            this.parentProvider.getConnection().removePacketListener((PacketListener)this);
            this.parentProvider.getConnection().addPacketListener((PacketListener)this, (PacketFilter)new AndFilter(new PacketFilter[]{new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(org.jivesoftware.smackx.packet.Version.class)}));
        } else if ((evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED) && this.parentProvider.getConnection() != null) {
            this.parentProvider.getConnection().removePacketListener((PacketListener)this);
        }
    }

    public void processPacket(Packet packet) {
        org.jivesoftware.smackx.packet.Version versionIQ = new org.jivesoftware.smackx.packet.Version();
        versionIQ.setType(IQ.Type.RESULT);
        versionIQ.setTo(packet.getFrom());
        versionIQ.setFrom(packet.getTo());
        versionIQ.setPacketID(packet.getPacketID());
        Version ver = JabberActivator.getVersionService().getCurrentVersion();
        String appName = ver.getApplicationName();
        if (!appName.toLowerCase().contains("jitsi")) {
            appName = appName + "-Jitsi";
        }
        versionIQ.setName(appName);
        versionIQ.setVersion(ver.toString());
        versionIQ.setOs(System.getProperty("os.name"));
        this.parentProvider.getConnection().sendPacket((Packet)versionIQ);
    }
}

