/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.rayo;

import java.util.Collection;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.rayo.EndExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.rayo.HeaderExtension;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class RayoIqProvider
implements IQProvider {
    public static final String NAMESPACE = "urn:xmpp:rayo:1";

    public void registerRayoIQs(ProviderManager providerManager) {
        providerManager.addIQProvider("dial", NAMESPACE, (Object)this);
        providerManager.addIQProvider("ref", NAMESPACE, (Object)this);
        providerManager.addIQProvider("hangup", NAMESPACE, (Object)this);
        providerManager.addExtensionProvider("end", NAMESPACE, new DefaultPacketExtensionProvider<EndExtension>(EndExtension.class));
        providerManager.addExtensionProvider("header", "", new DefaultPacketExtensionProvider<HeaderExtension>(HeaderExtension.class));
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        RayoIq iq;
        String namespace = parser.getNamespace();
        if (!NAMESPACE.equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("dial".equals(rootElement)) {
            DialIq dial;
            iq = dial = new DialIq();
            String src = parser.getAttributeValue("", "from");
            String dst = parser.getAttributeValue("", "to");
            if (StringUtils.isNullOrEmpty((String)dst)) {
                return null;
            }
            dial.setSource(src);
            dial.setDestination(dst);
        } else if ("ref".equals(rootElement)) {
            RefIq ref = new RefIq();
            iq = ref;
            String uri = parser.getAttributeValue("", "uri");
            if (StringUtils.isNullOrEmpty((String)uri)) {
                return null;
            }
            ref.setUri(uri);
        } else if ("hangup".equals(rootElement)) {
            iq = new HangUp();
        } else {
            return null;
        }
        boolean done = false;
        HeaderExtension header = null;
        while (!done) {
            switch (parser.next()) {
                case 3: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"header".equals(name) || header == null) break;
                    iq.addExtension(header);
                    header = null;
                    break;
                }
                case 2: {
                    String name = parser.getName();
                    if (!"header".equals(name)) break;
                    header = new HeaderExtension();
                    String nameAttr = parser.getAttributeValue("", "name");
                    header.setName(nameAttr);
                    String valueAttr = parser.getAttributeValue("", "value");
                    header.setValue(valueAttr);
                    break;
                }
            }
        }
        return iq;
    }

    public static class HangUp
    extends RayoIq {
        public static final String ELEMENT_NAME = "hangup";

        protected HangUp() {
            super(ELEMENT_NAME);
        }

        public static HangUp create(String from, String to) {
            HangUp hangUp = new HangUp();
            hangUp.setFrom(from);
            hangUp.setTo(to);
            hangUp.setType(IQ.Type.SET);
            return hangUp;
        }

        @Override
        protected void printAttributes(StringBuilder out) {
        }
    }

    public static class RefIq
    extends RayoIq {
        public static final String ELEMENT_NAME = "ref";
        public static final String URI_ATTR_NAME = "uri";
        private String uri;

        protected RefIq() {
            super(ELEMENT_NAME);
        }

        public static RefIq create(String uri) {
            RefIq refIq = new RefIq();
            refIq.setUri(uri);
            return refIq;
        }

        public static RefIq createResult(IQ requestIq, String uri) {
            RefIq refIq = RefIq.create(uri);
            refIq.setType(IQ.Type.RESULT);
            refIq.setPacketID(requestIq.getPacketID());
            refIq.setFrom(requestIq.getTo());
            refIq.setTo(requestIq.getFrom());
            return refIq;
        }

        @Override
        protected void printAttributes(StringBuilder out) {
            String uri = this.getUri();
            if (!StringUtils.isNullOrEmpty((String)uri)) {
                out.append(URI_ATTR_NAME).append("='").append(uri).append("' ");
            }
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public static class DialIq
    extends RayoIq {
        public static final String ELEMENT_NAME = "dial";
        public static final String SRC_ATTR_NAME = "from";
        public static final String DST_ATTR_NAME = "to";
        private String source;
        private String destination;

        public DialIq() {
            super(ELEMENT_NAME);
        }

        public static DialIq create(String to, String from) {
            DialIq dialIq = new DialIq();
            dialIq.setSource(from);
            dialIq.setDestination(to);
            return dialIq;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        protected void printAttributes(StringBuilder out) {
            String dst;
            String src = this.getSource();
            if (!StringUtils.isNullOrEmpty((String)src)) {
                out.append(SRC_ATTR_NAME).append("='").append(src).append("' ");
            }
            if (!StringUtils.isNullOrEmpty((String)(dst = this.getDestination()))) {
                out.append(DST_ATTR_NAME).append("='").append(dst).append("' ");
            }
        }
    }

    public static abstract class RayoIq
    extends IQ {
        private final String elementName;

        protected RayoIq(String elementName) {
            this.elementName = elementName;
        }

        protected abstract void printAttributes(StringBuilder var1);

        public String getChildElementXML() {
            StringBuilder xml = new StringBuilder();
            xml.append('<').append(this.elementName);
            xml.append(" xmlns='").append(RayoIqProvider.NAMESPACE).append("' ");
            this.printAttributes(xml);
            Collection extensions = this.getExtensions();
            if (extensions.size() > 0) {
                xml.append(">");
                for (PacketExtension extension : extensions) {
                    xml.append(extension.toXML());
                }
                xml.append("</").append(this.elementName).append(">");
            } else {
                xml.append("/>");
            }
            return xml.toString();
        }

        public String getHeader(String name) {
            HeaderExtension header = this.findHeader(name);
            return header != null ? header.getValue() : null;
        }

        private HeaderExtension findHeader(String name) {
            for (PacketExtension ext : this.getExtensions()) {
                HeaderExtension header;
                if (!(ext instanceof HeaderExtension) || !name.equals((header = (HeaderExtension)ext).getName())) continue;
                return header;
            }
            return null;
        }

        public void setHeader(String name, String value) {
            HeaderExtension headerExt = this.findHeader(name);
            if (headerExt == null) {
                headerExt = new HeaderExtension();
                headerExt.setName(name);
                this.addExtension(headerExt);
            }
            headerExt.setValue(value);
        }
    }
}

