/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.coin;

import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CallInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CoinIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.DisconnectionType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.EndpointPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.EndpointStatusType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.JoiningType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.MediaProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.StateType;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

public class EndpointProvider
implements PacketExtensionProvider {
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        boolean done = false;
        String elementName = null;
        String entity = parser.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        EndpointPacketExtension ext = new EndpointPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            int eventType = parser.next();
            elementName = parser.getName();
            if (eventType == 2) {
                PacketExtension childExtension;
                Object provider;
                if (elementName.equals("display-text")) {
                    ext.setDisplayText(CoinIQProvider.parseText(parser));
                    continue;
                }
                if (elementName.equals("disconnection-method")) {
                    ext.setDisconnectionType(DisconnectionType.parseString(parser.getText()));
                    continue;
                }
                if (elementName.equals("joining-method")) {
                    ext.setJoiningType(JoiningType.parseString(CoinIQProvider.parseText(parser)));
                    continue;
                }
                if (elementName.equals("status")) {
                    ext.setStatus(EndpointStatusType.parseString(CoinIQProvider.parseText(parser)));
                    continue;
                }
                if (elementName.equals("call-info")) {
                    provider = new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class);
                    childExtension = provider.parseExtension(parser);
                    ext.addChildExtension(childExtension);
                    continue;
                }
                if (!elementName.equals("media")) continue;
                provider = new MediaProvider();
                childExtension = provider.parseExtension(parser);
                ext.addChildExtension(childExtension);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("endpoint")) continue;
            done = true;
        }
        return ext;
    }
}

