/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.sdp;

import gov.nist.javax.sdp.fields.AttributeField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.sdp.CandidateAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IceSdpUtils {
    public static final String ICE_UFRAG = "ice-ufrag";
    public static final String ICE_PWD = "ice-pwd";
    public static final String ICE_OPTIONS = "ice-options";
    public static final String ICE_OPTION_TRICKLE = "trickle";
    public static final String MID = "mid";
    private static final String RTCP = "rtcp";
    private static final String END_OF_CANDIDATES = "end-of-candidates";
    private static final SdpFactory sdpFactory = SdpFactory.getInstance();
    private static final Logger logger = Logger.getLogger(IceSdpUtils.class.getName());

    public static void setIceCredentials(SessionDescription sDes, String uFrag, String pwd) throws NullPointerException {
        if (sDes == null || uFrag == null || pwd == null) {
            throw new NullPointerException("sDes, uFrag and pwd, cannot be null");
        }
        try {
            Vector sessionAttributes = sDes.getAttributes(true);
            sessionAttributes.add(sdpFactory.createAttribute(ICE_UFRAG, uFrag));
            sessionAttributes.add(sdpFactory.createAttribute(ICE_PWD, pwd));
            sDes.setAttributes(sessionAttributes);
        }
        catch (Exception cause) {
            logger.log(Level.INFO, "Failed to set ICE credentials for some weird reason", cause);
        }
    }

    public static void initMediaDescription(MediaDescription mediaDescription, IceMediaStream iceMediaStream) {
        try {
            TransportAddress transportAddress;
            mediaDescription.setAttribute(MID, iceMediaStream.getName());
            Component firstComponent = null;
            for (Component component : iceMediaStream.getComponents()) {
                if (firstComponent == null) {
                    firstComponent = component;
                }
                for (Candidate candidate : component.getLocalCandidates()) {
                    mediaDescription.addAttribute((AttributeField)new CandidateAttribute(candidate));
                }
            }
            TransportAddress defaultAddress = firstComponent.getDefaultCandidate().getTransportAddress();
            mediaDescription.getMedia().setMediaPort(defaultAddress.getPort());
            String addressFamily = defaultAddress.isIPv6() ? "IP6" : "IP4";
            mediaDescription.setConnection(sdpFactory.createConnection("IN", defaultAddress.getHostAddress(), addressFamily));
            Component rtcpComponent = iceMediaStream.getComponent(2);
            if (rtcpComponent != null && (transportAddress = rtcpComponent.getDefaultCandidate().getTransportAddress()).getPort() != defaultAddress.getPort() + 1) {
                mediaDescription.setAttribute(RTCP, Integer.toString(transportAddress.getPort()));
            }
        }
        catch (SdpException exc) {
            throw new IllegalArgumentException("Something went wrong when setting default candidates", exc);
        }
    }

    public static void initSessionDescription(SessionDescription sDes, Agent agent) throws IllegalArgumentException {
        StringBuilder allOptionsBuilder = new StringBuilder();
        allOptionsBuilder.append(ICE_OPTION_TRICKLE).append(" ");
        String allOptions = allOptionsBuilder.toString().trim();
        try {
            TransportAddress defaultAddress;
            if (allOptions.length() > 0) {
                Vector sessionAttributes = sDes.getAttributes(true);
                sessionAttributes.add(sdpFactory.createAttribute(ICE_OPTIONS, allOptions));
            }
            String addressFamily = (defaultAddress = agent.getStreams().get(0).getComponent(1).getDefaultCandidate().getTransportAddress()).isIPv6() ? "IP6" : "IP4";
            Origin o = sDes.getOrigin();
            if (o == null || "user".equals(o.getUsername())) {
                o = sdpFactory.createOrigin("ice4j.org", 0L, 0L, "IN", addressFamily, defaultAddress.getHostAddress());
            } else {
                o.setAddress(defaultAddress.getHostAddress());
                o.setAddressType(addressFamily);
            }
            sDes.setOrigin(o);
            List<IceMediaStream> streams = agent.getStreams();
            Vector<MediaDescription> mDescs = new Vector<MediaDescription>(agent.getStreamCount());
            for (IceMediaStream stream : streams) {
                MediaDescription mLine = sdpFactory.createMediaDescription(stream.getName(), 0, 1, "RTP/AVP", new int[]{0});
                IceSdpUtils.initMediaDescription(mLine, stream);
                mDescs.add(mLine);
            }
            sDes.setMediaDescriptions(mDescs);
        }
        catch (SdpException exc) {
            throw new IllegalArgumentException("Something went wrong when setting ICE options", exc);
        }
        IceSdpUtils.setIceCredentials(sDes, agent.getLocalUfrag(), agent.getLocalPassword());
    }

    public static Collection<Attribute> createTrickleUpdate(Collection<LocalCandidate> localCandidates) {
        ArrayList<Attribute> trickleUpdate = null;
        if (localCandidates == null || localCandidates.size() == 0) {
            trickleUpdate = new ArrayList<Attribute>(1);
            trickleUpdate.add(sdpFactory.createAttribute(END_OF_CANDIDATES, null));
            return trickleUpdate;
        }
        trickleUpdate = new ArrayList(localCandidates.size() + 1);
        String streamName = null;
        for (LocalCandidate candidate : localCandidates) {
            streamName = candidate.getParentComponent().getParentStream().getName();
            trickleUpdate.add((Attribute)new CandidateAttribute(candidate));
        }
        trickleUpdate.add(0, sdpFactory.createAttribute(MID, streamName));
        return trickleUpdate;
    }
}

