/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import net.java.sip.communicator.service.gui.ExportedWindow;

public abstract class AbstractExportedWindow<T extends Window>
implements ExportedWindow {
    protected T window;

    @Override
    public void bringToFront() {
        Frame frame;
        T window = this.getWindow();
        if (window instanceof Frame && ((frame = (Frame)window).getExtendedState() & 1) == 1) {
            frame.setExtendedState(0);
        }
        ((Window)window).toFront();
    }

    protected abstract T createWindow();

    @Override
    public Object getSource() {
        return this.getWindow();
    }

    protected T getWindow() {
        if (this.window == null) {
            this.window = this.createWindow();
        }
        return this.window;
    }

    @Override
    public boolean isFocused() {
        return this.window == null ? false : ((Window)this.window).isFocused();
    }

    @Override
    public boolean isVisible() {
        boolean visible;
        if (this.window == null) {
            visible = false;
        } else {
            visible = ((Component)this.window).isVisible();
            if (visible && this.window instanceof Frame) {
                Frame frame = (Frame)this.window;
                visible = (frame.getExtendedState() & 1) != 1;
            }
        }
        return visible;
    }

    @Override
    public void maximize() {
        T window = this.getWindow();
        if (window instanceof Frame) {
            ((Frame)window).setExtendedState(6);
        }
    }

    @Override
    public void minimize() {
        T window = this.getWindow();
        if (window instanceof Frame) {
            ((Frame)window).setExtendedState(1);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        ((Window)this.getWindow()).setLocation(x, y);
    }

    @Override
    public void setParams(Object[] windowParams) {
    }

    @Override
    public void setSize(int width, int height) {
        ((Window)this.getWindow()).setSize(width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        ((Window)this.getWindow()).setVisible(visible);
    }
}

