/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.videobridge.simulcast.SimulcastLayer;
import org.jitsi.videobridge.simulcast.SimulcastManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulcastLayersFactory {
    public static SortedSet<SimulcastLayer> fromSourceGroups(List<SourceGroupPacketExtension> sourceGroups, SimulcastManager manager) {
        List sources;
        if (sourceGroups == null || sourceGroups.size() == 0) {
            return null;
        }
        HashMap<Long, SimulcastLayer> reverseMap = new HashMap<Long, SimulcastLayer>();
        TreeSet<SimulcastLayer> layers = new TreeSet<SimulcastLayer>();
        for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
            sources = sourceGroup.getSources();
            if (sources == null || sources.size() == 0 || !"SIM".equals(sourceGroup.getSemantics())) continue;
            int order = 0;
            for (SourcePacketExtension source : sources) {
                Long primarySSRC = source.getSSRC();
                SimulcastLayer simulcastLayer = new SimulcastLayer(manager, primarySSRC, order++);
                reverseMap.put(primarySSRC, simulcastLayer);
                layers.add(simulcastLayer);
            }
        }
        for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
            sources = sourceGroup.getSources();
            if (sources == null || sources.size() == 0 || "SIM".equals(sourceGroup.getSemantics())) continue;
            SimulcastLayer simulcastLayer = null;
            HashSet<Long> ssrcs = new HashSet<Long>();
            for (SourcePacketExtension source : sources) {
                Long ssrc = source.getSSRC();
                ssrcs.add(source.getSSRC());
                if (!reverseMap.containsKey(ssrc)) continue;
                simulcastLayer = (SimulcastLayer)reverseMap.get(ssrc);
            }
            if (simulcastLayer == null) continue;
            simulcastLayer.associateSSRCs(ssrcs);
        }
        return layers;
    }
}

