/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.sip.PeerUnavailableException;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;

public class SipFactory {
    private String pathName = "gov.nist";
    private Hashtable sipStackByName;
    private MessageFactory messageFactory = null;
    private HeaderFactory headerFactory = null;
    private AddressFactory addressFactory = null;
    private static SipFactory myFactory = null;
    private final LinkedList sipStackList = new LinkedList();

    public static synchronized SipFactory getInstance() {
        if (myFactory == null) {
            myFactory = new SipFactory();
        }
        return myFactory;
    }

    public synchronized SipStack createSipStack(Properties properties) throws PeerUnavailableException {
        String string = properties.getProperty("javax.sip.IP_ADDRESS");
        String string2 = properties.getProperty("javax.sip.STACK_NAME");
        if (string2 == null) {
            throw new PeerUnavailableException("Missing javax.sip.STACK_NAME property");
        }
        if (string == null) {
            SipStack sipStack = (SipStack)this.sipStackByName.get(string2);
            if (sipStack == null) {
                sipStack = this.createStack(properties);
            }
            return sipStack;
        }
        int n = 0;
        for (n = 0; n < this.sipStackList.size(); ++n) {
            if (!((SipStack)this.sipStackList.get(n)).getIPAddress().equals(string)) continue;
            return (SipStack)this.sipStackList.get(n);
        }
        return this.createStack(properties);
    }

    public MessageFactory createMessageFactory() throws PeerUnavailableException {
        if (this.messageFactory == null) {
            this.messageFactory = (MessageFactory)this.createSipFactory("javax.sip.message.MessageFactoryImpl");
        }
        return this.messageFactory;
    }

    public HeaderFactory createHeaderFactory() throws PeerUnavailableException {
        if (this.headerFactory == null) {
            this.headerFactory = (HeaderFactory)this.createSipFactory("javax.sip.header.HeaderFactoryImpl");
        }
        return this.headerFactory;
    }

    public AddressFactory createAddressFactory() throws PeerUnavailableException {
        if (this.addressFactory == null) {
            this.addressFactory = (AddressFactory)this.createSipFactory("javax.sip.address.AddressFactoryImpl");
        }
        return this.addressFactory;
    }

    public void setPathName(String string) {
        this.pathName = string;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void resetFactory() {
        this.sipStackList.clear();
        this.messageFactory = null;
        this.headerFactory = null;
        this.addressFactory = null;
        this.sipStackByName = new Hashtable();
        this.pathName = "gov.nist";
    }

    private Object createSipFactory(String string) throws PeerUnavailableException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz = Class.forName(this.getPathName() + "." + string);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception exception) {
            String string2 = "The Peer Factory: " + this.getPathName() + "." + string + " could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(string2, exception);
        }
    }

    private SipStack createStack(Properties properties) throws PeerUnavailableException {
        try {
            Class[] classArray = new Class[]{Class.forName("java.util.Properties")};
            Constructor<?> constructor = Class.forName(this.getPathName() + ".javax.sip.SipStackImpl").getConstructor(classArray);
            Object[] objectArray = new Object[]{properties};
            SipStack sipStack = (SipStack)constructor.newInstance(objectArray);
            this.sipStackList.add(sipStack);
            String string = properties.getProperty("javax.sip.STACK_NAME");
            this.sipStackByName.put(string, sipStack);
            return sipStack;
        }
        catch (Exception exception) {
            String string = "The Peer SIP Stack: " + this.getPathName() + ".javax.sip.SipStackImpl" + " could not be instantiated. Ensure the Path Name has been set.";
            throw new PeerUnavailableException(string, exception);
        }
    }

    private SipFactory() {
        this.sipStackByName = new Hashtable();
    }
}

