/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import org.jetbrains.annotations.Nullable;

public final class OldIconHashInfo {
    private final long size;
    private final int sum;
    private final long timestamp;
    private final int hashBlockSize;

    public static int computeIconSum(InputStream in) throws IOException {
        int a;
        long sum = 0L;
        int lastByte = -1;
        while ((a = in.read()) != -1) {
            int b = in.read();
            if (b == -1) {
                lastByte = a;
                break;
            }
            sum += (long)(((b & 0xFF) << 8) + (a & 0xFF));
        }
        if (lastByte != -1) {
            sum += (long)lastByte;
        }
        sum = ((sum & 0xFFFF0000L) >> 16) + (sum & 0xFFFFL);
        return (int)sum;
    }

    public static int computeIconSum(ByteBlock data) {
        DefensiveTools.checkNull((Object)data, (String)"data");
        try {
            return OldIconHashInfo.computeIconSum(ByteBlock.createInputStream((ByteBlock)data));
        }
        catch (IOException impossible) {
            return -1;
        }
    }

    @Nullable
    public static OldIconHashInfo readIconHashFromImTlvData(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 12) {
            return null;
        }
        long size = BinaryTools.getUInt((ByteBlock)block, (int)0);
        int sum = BinaryTools.getUShort((ByteBlock)block, (int)6);
        long stamp = BinaryTools.getUInt((ByteBlock)block, (int)8);
        return new OldIconHashInfo(size, sum, stamp, 12);
    }

    public static OldIconHashInfo readIconHashFromRvData(ByteBlock block) {
        DefensiveTools.checkNull((Object)block, (String)"block");
        if (block.getLength() < 12) {
            return null;
        }
        int sum = BinaryTools.getUShort((ByteBlock)block, (int)2);
        long size = BinaryTools.getUInt((ByteBlock)block, (int)4);
        long stamp = BinaryTools.getUInt((ByteBlock)block, (int)8);
        return new OldIconHashInfo(size, sum, stamp, 12);
    }

    public OldIconHashInfo(File file) throws FileNotFoundException, IOException {
        DefensiveTools.checkNull((Object)file, (String)"file");
        this.size = file.length();
        this.timestamp = file.lastModified();
        FileInputStream fin = new FileInputStream(file);
        this.sum = OldIconHashInfo.computeIconSum(fin);
        fin.close();
        this.hashBlockSize = -1;
    }

    private OldIconHashInfo(long size, int sum, long timestamp, int blockSize) {
        DefensiveTools.checkRange((long)size, (String)"size", (long)0L);
        DefensiveTools.checkRange((int)sum, (String)"sum", (int)0);
        DefensiveTools.checkRange((long)timestamp, (String)"timestamp", (long)0L);
        DefensiveTools.checkRange((int)blockSize, (String)"blockSize", (int)-1);
        this.size = size;
        this.sum = sum;
        this.timestamp = timestamp;
        this.hashBlockSize = blockSize;
    }

    public OldIconHashInfo(long size, int sum, long timestamp) {
        this(size, sum, timestamp, -1);
    }

    public final long getIconSize() {
        return this.size;
    }

    public final int getSum() {
        return this.sum;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public int getHashBlockSize() {
        return this.hashBlockSize;
    }

    public void writeToImTlv(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(12);
        BinaryTools.writeUInt((OutputStream)bout, (long)this.size);
        BinaryTools.writeUShort((OutputStream)bout, (int)1);
        BinaryTools.writeUShort((OutputStream)bout, (int)this.sum);
        BinaryTools.writeUInt((OutputStream)bout, (long)this.timestamp);
        bout.writeTo(out);
    }

    public int getImTlvFormatLength() {
        return 12;
    }

    public void writeToRvData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)0);
        BinaryTools.writeUShort((OutputStream)out, (int)this.sum);
        BinaryTools.writeUInt((OutputStream)out, (long)this.size);
        BinaryTools.writeUInt((OutputStream)out, (long)this.timestamp);
    }

    public int getRvDataFormatLength() {
        return 12;
    }

    public String toString() {
        return "OldIconHashData: size=" + this.size + " bytes, sum=" + this.sum + ", lastmod=" + new Date(this.timestamp * 1000L);
    }
}

