/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.util.ArrayList;
import org.hn.sleek.jmml.IncomingMessage;
import org.hn.sleek.jmml.MSNPListener;
import org.hn.sleek.jmml.Message;
import org.hn.sleek.jmml.OutgoingMessage;
import org.hn.sleek.jmml.ServerConnection;

public class DispatchServerConnector
implements MSNPListener {
    static final String MESSENGER_DS_SERVER = "messenger.hotmail.com";
    static final int MESSENGER_DS_PORT = 1863;
    ServerConnection sc;
    int transactionID = 0;
    int port = -1;
    String serverIP;
    String userName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getNSServer(String userName) {
        this.userName = userName;
        this.sc = new ServerConnection(MESSENGER_DS_SERVER, 1863, this);
        if (!this.sc.isConnected()) {
            return null;
        }
        OutgoingMessage msg = new OutgoingMessage(32, this.getTransactionID());
        msg.addArgument("MSNP8");
        msg.addArgument("CVR0");
        this.sc.sendMSNPMessage(msg);
        try {
            DispatchServerConnector dispatchServerConnector = this;
            synchronized (dispatchServerConnector) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.port != -1) {
            ArrayList<Object> serverInfo = new ArrayList<Object>();
            serverInfo.add(this.serverIP);
            serverInfo.add(new Integer(this.port));
            return serverInfo;
        }
        return null;
    }

    private int getTransactionID() {
        ++this.transactionID;
        return this.transactionID;
    }

    public void incomingMSNPMessage(IncomingMessage incomingMessage) {
        switch (incomingMessage.getType()) {
            case 32: {
                this.receivedVER(incomingMessage);
                break;
            }
            case 33: {
                this.receivedXFR(incomingMessage);
                break;
            }
            case 34: {
                this.receivedCVR(incomingMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverDisconnected() {
        System.out.println("DispatchServerConnector.serverDisconnected() - Dispatch server has disconnected...");
        DispatchServerConnector dispatchServerConnector = this;
        synchronized (dispatchServerConnector) {
            this.notifyAll();
        }
    }

    private void receivedVER(IncomingMessage incomingMessage) {
        OutgoingMessage outgoingMsg = new OutgoingMessage(34, this.getTransactionID());
        String strArgument = "0x0409 winnt 5.1 i386 MSNMSGR 5.0.0540 MSMSGS " + this.userName;
        outgoingMsg.addArgument(strArgument);
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    private void receivedXFR(IncomingMessage incomingMessage) {
        try {
            this.serverIP = incomingMessage.getServerIP();
            this.port = incomingMessage.getServerPort();
        }
        catch (Exception e) {
            this.serverIP = "64.4.12.93";
            this.port = 1863;
        }
    }

    private void receivedCVR(IncomingMessage incomingMessage) {
        OutgoingMessage outgoingMsg = new OutgoingMessage(31, this.getTransactionID());
        outgoingMsg.addArgument(Message.commandToString(14));
        outgoingMsg.addArgument("I");
        outgoingMsg.addArgument(this.userName);
        this.sc.sendMSNPMessage(outgoingMsg);
    }

    public static void main(String[] args) {
        DispatchServerConnector ds = new DispatchServerConnector();
        System.out.println(ds.getNSServer(args[0]));
    }
}

