/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flapcmd.KeepaliveFlapCmd;
import net.kano.joscar.net.ClientConn;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnection;

public class KeepaliveSender {
    private static final Logger LOGGER = Logger.getLogger(KeepaliveSender.class.getName());
    private static final int KEEPALIVE_INTERVAL = 180000;
    private final OscarConnection connection;
    private Timer timer = null;

    public static KeepaliveSender start(OscarConnection conn) {
        return new KeepaliveSender(conn);
    }

    private KeepaliveSender(OscarConnection conn) {
        this.connection = conn;
        conn.getClientFlapConn().addConnListener(new ClientConnListener(){

            public void stateChanged(ClientConnEvent e) {
                KeepaliveSender.this.handleConnectionState(e.getNewState());
            }
        });
        this.handleConnectionState(conn.getConnectionState());
    }

    private synchronized void handleConnectionState(ClientConn.State newState) {
        if (this.timer == null && newState == ClientConn.STATE_CONNECTED) {
            LOGGER.fine("Starting KeepaliveSender for " + this.connection);
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    if (!KeepaliveSender.this.connection.isDisconnected()) {
                        LOGGER.finer("Sending FLAP keepalive on " + KeepaliveSender.this.connection);
                        KeepaliveSender.this.connection.sendFlap((FlapCommand)new KeepaliveFlapCmd());
                    }
                }
            }, 0L, 180000L);
        } else if (this.timer != null && newState == ClientConn.STATE_NOT_CONNECTED) {
            LOGGER.fine("Stopping KeepaliveSender for " + this.connection);
            this.timer.cancel();
            this.timer = null;
        }
    }
}

