/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import net.sf.jml.util.DigestUtils;
import net.sf.jml.util.NumberUtils;

public class GUID {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final String LOCALHOST;
    private int hash;
    private int timeLow;
    private short timeMid;
    private short timeHiAndVersion;
    private byte clockSeqHiAndReserved;
    private byte clockSeqLow;
    private byte node0;
    private byte node1;
    private byte node2;
    private byte node3;
    private byte node4;
    private byte node5;

    private GUID() {
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(this.timeLow);
        byteBuffer.putShort(this.timeMid);
        byteBuffer.putShort(this.timeHiAndVersion);
        byteBuffer.put(this.clockSeqHiAndReserved);
        byteBuffer.put(this.clockSeqLow);
        byteBuffer.put(this.node0);
        byteBuffer.put(this.node1);
        byteBuffer.put(this.node2);
        byteBuffer.put(this.node3);
        byteBuffer.put(this.node4);
        byteBuffer.put(this.node5);
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GUID)) {
            return false;
        }
        GUID gUID = (GUID)object;
        return gUID.clockSeqHiAndReserved == this.clockSeqHiAndReserved && gUID.clockSeqLow == this.clockSeqLow && gUID.node0 == this.node0 && gUID.node1 == this.node1 && gUID.node2 == this.node2 && gUID.node3 == this.node3 && gUID.node4 == this.node4 && gUID.node5 == this.node5 && gUID.timeHiAndVersion == this.timeHiAndVersion && gUID.timeLow == this.timeLow && gUID.timeMid == this.timeMid;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 17;
            this.hash = 31 * this.hash + this.timeLow;
            this.hash = 31 * this.hash + this.timeMid;
            this.hash = 31 * this.hash + this.timeHiAndVersion;
            this.hash = 31 * this.hash + this.node0;
            this.hash = 31 * this.hash + this.node1;
            this.hash = 31 * this.hash + this.node2;
            this.hash = 31 * this.hash + this.node3;
            this.hash = 31 * this.hash + this.node4;
            this.hash = 31 * this.hash + this.node5;
            this.hash = 31 * this.hash + this.clockSeqHiAndReserved;
            this.hash = 31 * this.hash + this.clockSeqLow;
        }
        return this.hash;
    }

    public String toString() {
        byte[] byArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.timeLow);
        byteBuffer.putShort(this.timeMid);
        byteBuffer.putShort(this.timeHiAndVersion);
        byteBuffer.put(this.clockSeqHiAndReserved);
        byteBuffer.put(this.clockSeqLow);
        byteBuffer.put(this.node0);
        byteBuffer.put(this.node1);
        byteBuffer.put(this.node2);
        byteBuffer.put(this.node3);
        byteBuffer.put(this.node4);
        byteBuffer.put(this.node5);
        StringBuffer stringBuffer = new StringBuffer(36);
        stringBuffer.append(NumberUtils.toHexValue(ByteBuffer.wrap(byArray, 0, 4)));
        stringBuffer.append("-");
        stringBuffer.append(NumberUtils.toHexValue(ByteBuffer.wrap(byArray, 4, 2)));
        stringBuffer.append("-");
        stringBuffer.append(NumberUtils.toHexValue(ByteBuffer.wrap(byArray, 6, 2)));
        stringBuffer.append("-");
        stringBuffer.append(NumberUtils.toHexValue(ByteBuffer.wrap(byArray, 8, 2)));
        stringBuffer.append("-");
        stringBuffer.append(NumberUtils.toHexValue(ByteBuffer.wrap(byArray, 10, 6)));
        return stringBuffer.toString().toUpperCase();
    }

    public static GUID parseGUID(byte[] byArray) {
        if (byArray == null || byArray.length != 16) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        GUID gUID = new GUID();
        gUID.timeLow = byteBuffer.getInt();
        gUID.timeMid = byteBuffer.getShort();
        gUID.timeHiAndVersion = byteBuffer.getShort();
        gUID.clockSeqHiAndReserved = byteBuffer.get();
        gUID.clockSeqLow = byteBuffer.get();
        gUID.node0 = byteBuffer.get();
        gUID.node1 = byteBuffer.get();
        gUID.node2 = byteBuffer.get();
        gUID.node3 = byteBuffer.get();
        gUID.node4 = byteBuffer.get();
        gUID.node5 = byteBuffer.get();
        return gUID;
    }

    public static GUID parseGUID(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.remaining() >= 16) {
            byte[] byArray = new byte[16];
            byteBuffer.get(byArray);
            return GUID.parseGUID(byArray);
        }
        return null;
    }

    public static GUID parseGUID(String string) {
        if (string == null || string.length() != 36) {
            return null;
        }
        char c = '-';
        if (string.charAt(8) != c || string.charAt(13) != c || string.charAt(18) != c || string.charAt(23) != c) {
            return null;
        }
        try {
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt((int)Long.parseLong(string.substring(0, 8), 16));
            byteBuffer.putShort((short)Integer.parseInt(string.substring(9, 13), 16));
            byteBuffer.putShort((short)Integer.parseInt(string.substring(14, 18), 16));
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putShort((short)Integer.parseInt(string.substring(19, 23), 16));
            for (int i = 24; i < 36; i += 2) {
                byteBuffer.put((byte)Short.parseShort(string.substring(i, i + 2), 16));
            }
            return GUID.parseGUID(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static GUID createRandomGuid() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LOCALHOST);
        stringBuffer.append(System.currentTimeMillis());
        stringBuffer.append(SECURE_RANDOM.nextInt());
        return GUID.parseGUID(DigestUtils.md5(stringBuffer.toString().getBytes()));
    }

    static {
        String string = "";
        try {
            string = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        LOCALHOST = string;
        SECURE_RANDOM.nextInt();
    }
}

