/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingPushDataSource
extends PushDataSource {
    protected final List<PushDataSource> sources;

    public MergingPushDataSource(List<PushDataSource> list) {
        this.sources = list;
    }

    @Override
    public void connect() throws IOException {
        for (PushDataSource pushDataSource : this.sources) {
            pushDataSource.connect();
        }
    }

    @Override
    public void disconnect() {
        for (PushDataSource pushDataSource : this.sources) {
            pushDataSource.disconnect();
        }
    }

    @Override
    public String getContentType() {
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get(i).getContentType().equals(this.sources.get(0).getContentType())) continue;
            return "application.mixed-data";
        }
        return this.sources.get(0).getContentType();
    }

    @Override
    public Object getControl(String string) {
        for (PushDataSource pushDataSource : this.sources) {
            Object object = pushDataSource.getControl(string);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (PushDataSource pushDataSource : this.sources) {
            for (Object object : pushDataSource.getControls()) {
                arrayList.add(object);
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    @Override
    public Time getDuration() {
        ArrayList<Time> arrayList = new ArrayList<Time>();
        for (PushDataSource object : this.sources) {
            arrayList.add(object.getDuration());
        }
        for (Time time : arrayList) {
            if (time.getNanoseconds() != Duration.DURATION_UNKNOWN.getNanoseconds()) continue;
            return Duration.DURATION_UNKNOWN;
        }
        for (Time time : arrayList) {
            if (time.getNanoseconds() != Duration.DURATION_UNBOUNDED.getNanoseconds()) continue;
            return Duration.DURATION_UNBOUNDED;
        }
        long l = -1L;
        for (Time time : arrayList) {
            if (time.getNanoseconds() <= l) continue;
            l = time.getNanoseconds();
        }
        if (l < 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(l);
    }

    @Override
    public PushSourceStream[] getStreams() {
        ArrayList<PushSourceStream> arrayList = new ArrayList<PushSourceStream>();
        for (PushDataSource pushDataSource : this.sources) {
            for (PushSourceStream pushSourceStream : pushDataSource.getStreams()) {
                arrayList.add(pushSourceStream);
            }
        }
        return arrayList.toArray(new PushSourceStream[0]);
    }

    @Override
    public void start() throws IOException {
        for (PushDataSource pushDataSource : this.sources) {
            pushDataSource.start();
        }
    }

    @Override
    public void stop() throws IOException {
        for (PushDataSource pushDataSource : this.sources) {
            pushDataSource.stop();
        }
    }
}

