/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptureDeviceManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static Class<?> implClass;
    private static Method getDeviceMethod;
    private static Method getDeviceListMethod;
    private static Method addDeviceMethod;
    private static Method removeDeviceMethod;
    private static Method commitMethod;

    public static boolean addDevice(CaptureDeviceInfo captureDeviceInfo) {
        if (!CaptureDeviceManager.init()) {
            return false;
        }
        return (Boolean)CaptureDeviceManager.callImpl(addDeviceMethod, new Object[]{captureDeviceInfo});
    }

    private static Object callImpl(Method method, Object[] objectArray) {
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "" + illegalArgumentException, illegalArgumentException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.WARNING, "" + illegalAccessException, illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.log(Level.WARNING, "" + invocationTargetException, invocationTargetException);
            return null;
        }
    }

    public static void commit() throws IOException {
        if (!CaptureDeviceManager.init()) {
            return;
        }
        Method method = commitMethod;
        Object[] objectArray = new Object[]{};
        try {
            method.invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "" + illegalArgumentException, illegalArgumentException);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.WARNING, "" + illegalAccessException, illegalAccessException);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof IOException) {
                throw (IOException)invocationTargetException.getCause();
            }
            logger.log(Level.WARNING, "" + invocationTargetException, invocationTargetException);
            return;
        }
    }

    public static CaptureDeviceInfo getDevice(String string) {
        if (!CaptureDeviceManager.init()) {
            return null;
        }
        return (CaptureDeviceInfo)CaptureDeviceManager.callImpl(getDeviceMethod, new Object[]{string});
    }

    public static Vector getDeviceList(Format format) {
        if (!CaptureDeviceManager.init()) {
            return null;
        }
        return (Vector)CaptureDeviceManager.callImpl(getDeviceListMethod, new Object[]{format});
    }

    private static Method getStaticMethodOnImplClass(String string, Class<?>[] classArray, Class<?> clazz) throws Exception {
        Method method = implClass.getMethod(string, classArray);
        if (method.getReturnType() != clazz) {
            throw new Exception("Expected return type of method " + string + " to be " + clazz + ", was " + method.getReturnType());
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new Exception("Expected method " + string + " to be static");
        }
        return method;
    }

    private static synchronized boolean init() {
        if (implClass != null) {
            return true;
        }
        try {
            implClass = Class.forName("javax.media.cdm.CaptureDeviceManager");
            if (!CaptureDeviceManager.class.isAssignableFrom(implClass)) {
                throw new Exception("javax.media.cdm.CaptureDeviceManager not subclass of " + CaptureDeviceManager.class.getName());
            }
            getDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("getDevice", new Class[]{String.class}, CaptureDeviceInfo.class);
            getDeviceListMethod = CaptureDeviceManager.getStaticMethodOnImplClass("getDeviceList", new Class[]{Format.class}, Vector.class);
            addDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("addDevice", new Class[]{CaptureDeviceInfo.class}, Boolean.TYPE);
            removeDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("removeDevice", new Class[]{CaptureDeviceInfo.class}, Boolean.TYPE);
            commitMethod = CaptureDeviceManager.getStaticMethodOnImplClass("commit", new Class[0], Void.TYPE);
        }
        catch (Exception exception) {
            implClass = null;
            logger.log(Level.WARNING, "" + exception, exception);
            return false;
        }
        return true;
    }

    public static boolean removeDevice(CaptureDeviceInfo captureDeviceInfo) {
        if (!CaptureDeviceManager.init()) {
            return false;
        }
        return (Boolean)CaptureDeviceManager.callImpl(removeDeviceMethod, new Object[]{captureDeviceInfo});
    }
}

