/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCache;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCacheEntry;

public class FeedbackCacheProcessor {
    private final FeedbackCache feedbackCache;
    private int percentile = 70;
    private long lastRun;
    private long expireMillis = 0L;

    public FeedbackCacheProcessor(FeedbackCache feedbackCache) {
        this.feedbackCache = feedbackCache;
    }

    private Map<Integer, Map<Integer, FeedbackData>> getReverseFeedbackMapMap() {
        HashMap<Integer, Map<Integer, FeedbackData>> reverseFeedbackMapMap = new HashMap<Integer, Map<Integer, FeedbackData>>();
        if (this.feedbackCache != null && this.feedbackCache.size() != 0) {
            for (Map.Entry<Integer, FeedbackCacheEntry> entry : this.feedbackCache.entrySet()) {
                Map<Integer, FeedbackData> reverseFeedbackMap;
                Integer dest;
                FeedbackCacheEntry item = entry.getValue();
                if (item.lastUpdate < this.lastRun - this.expireMillis) continue;
                Integer sender = entry.getKey();
                if (item.reports != null && item.reports.length != 0) {
                    for (RTCPReportBlock b : item.reports) {
                        FeedbackData feedback = new FeedbackData();
                        feedback.rr = new RRData();
                        feedback.rr.fraction = b.getFractionLost();
                        feedback.rr.lost = b.getNumLost();
                        feedback.rr.jitter = b.getJitter();
                        feedback.rr.dlsr = b.getDLSR();
                        feedback.rr.lsr = b.getLSR();
                        feedback.rr.seqnum = b.getXtndSeqNum();
                        dest = (int)b.getSSRC();
                        reverseFeedbackMap = new HashMap();
                        reverseFeedbackMapMap.put(dest, reverseFeedbackMap);
                        reverseFeedbackMap.put(sender, feedback);
                    }
                }
                if (item.remb == null || item.remb.dest == null || item.remb.dest.length == 0) continue;
                for (long destl : item.remb.dest) {
                    FeedbackData feedback;
                    dest = (int)destl;
                    if (reverseFeedbackMapMap.containsKey(dest)) {
                        reverseFeedbackMap = (Map)reverseFeedbackMapMap.get(dest);
                    } else {
                        reverseFeedbackMap = new HashMap();
                        reverseFeedbackMapMap.put(dest, reverseFeedbackMap);
                    }
                    if (reverseFeedbackMap.containsKey(sender)) {
                        feedback = (FeedbackData)reverseFeedbackMap.get(sender);
                    } else {
                        feedback = new FeedbackData();
                        reverseFeedbackMap.put(sender, feedback);
                    }
                    feedback.remb = new REMBData();
                    feedback.remb.exp = item.remb.exp;
                    feedback.remb.mantissa = item.remb.mantissa;
                }
            }
        }
        this.lastRun = System.currentTimeMillis();
        return reverseFeedbackMapMap;
    }

    private double calculateScore(FeedbackData feedback) {
        if (feedback == null) {
            throw new IllegalArgumentException();
        }
        if (feedback.remb == null) {
            return -1.0;
        }
        double score = (double)feedback.remb.mantissa * Math.pow(2.0, feedback.remb.exp);
        if (feedback.rr != null) {
            score = (double)((100L - feedback.rr.lost) / 100L) * score;
        }
        return score;
    }

    public Map<Integer, FeedbackData> getReverseFeedbackMap() {
        Map<Integer, Map<Integer, FeedbackData>> reverseFeedbackMapMap = this.getReverseFeedbackMapMap();
        if (reverseFeedbackMapMap == null || reverseFeedbackMapMap.size() == 0) {
            return null;
        }
        HashMap<Integer, FeedbackData> reverseFeedbackMap = new HashMap<Integer, FeedbackData>();
        for (Map.Entry<Integer, Map<Integer, FeedbackData>> entry : reverseFeedbackMapMap.entrySet()) {
            Integer dest = entry.getKey();
            TreeMap<Double, FeedbackData> scoresMap = new TreeMap<Double, FeedbackData>();
            Map<Integer, FeedbackData> feedbackMap = entry.getValue();
            for (FeedbackData feedback : feedbackMap.values()) {
                double score = this.calculateScore(feedback);
                scoresMap.put(score, feedback);
            }
            int p = this.percentile;
            if (p > 100 || p < 0) {
                p = 70;
            }
            int idxNearestBest = (int)Math.ceil((double)p / 100.0 * (double)scoresMap.size()) - 1;
            FeedbackData feedback = (FeedbackData)new ArrayList(scoresMap.values()).get(idxNearestBest);
            reverseFeedbackMap.put(dest, feedback);
        }
        return reverseFeedbackMap;
    }

    public int getPercentile() {
        return this.percentile;
    }

    public void setPercentile(int percentile) {
        this.percentile = percentile;
    }

    public RTCPPacket[] makeReports(int localSSRC) {
        Map<Integer, FeedbackData> reverseFeedback = this.getReverseFeedbackMap();
        if (reverseFeedback == null || reverseFeedback.size() == 0) {
            return null;
        }
        ArrayList<RTCPReportBlock> reportBlocks = new ArrayList<RTCPReportBlock>(reverseFeedback.size());
        ArrayList<RTCPREMBPacket> rembs = new ArrayList<RTCPREMBPacket>(reverseFeedback.size());
        for (Map.Entry<Integer, FeedbackData> entry : reverseFeedback.entrySet()) {
            Integer dest = entry.getKey();
            FeedbackData feedback = entry.getValue();
            if (feedback.remb != null) {
                RTCPREMBPacket remb = new RTCPREMBPacket(localSSRC, 0L, feedback.remb.exp, feedback.remb.mantissa, new long[]{(long)dest.intValue() & 0xFFFFFFFFL});
                rembs.add(remb);
            }
            if (feedback.rr == null) continue;
            RTCPReportBlock reportBlock = new RTCPReportBlock(dest, feedback.rr.fraction, (int)feedback.rr.lost, feedback.rr.seqnum, (int)feedback.rr.jitter, feedback.rr.lsr, feedback.rr.dlsr);
            reportBlocks.add(reportBlock);
        }
        RTCPPacket[] packets = new RTCPPacket[rembs.size() + 1];
        RTCPReportBlock[] rtcpReportBlocks = reportBlocks.toArray(new RTCPReportBlock[reportBlocks.size()]);
        packets[0] = new RTCPRRPacket(localSSRC, rtcpReportBlocks);
        RTCPREMBPacket[] rembarr = rembs.toArray(new RTCPREMBPacket[rembs.size()]);
        System.arraycopy(rembarr, 0, packets, 1, rembarr.length);
        this.lastRun = System.currentTimeMillis();
        return packets;
    }

    static class FeedbackData {
        REMBData remb;
        RRData rr;

        FeedbackData() {
        }
    }

    static class REMBData {
        int exp;
        int mantissa;

        REMBData() {
        }
    }

    static class RRData {
        int fraction;
        long lost;
        long jitter;
        long dlsr;
        long lsr;
        long seqnum;

        RRData() {
        }
    }
}

