/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.sf.jqql.QQClient;
import net.sf.jqql.net.IConnection;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResendTrigger<T>
implements Callable<T> {
    private QQClient client;
    private Queue<_08OutPacket> timeoutQueue;
    private Map<_08OutPacket, String> toPort;
    private String portName;

    public ResendTrigger(QQClient qQClient) {
        this.client = qQClient;
        this.timeoutQueue = new LinkedList<_08OutPacket>();
        this.toPort = new HashMap<_08OutPacket, String>();
        QQClient.executor.schedule(this, 5000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void add(_08OutPacket _08OutPacket2, String string) {
        this.timeoutQueue.offer(_08OutPacket2);
        this.toPort.put(_08OutPacket2, string);
    }

    public synchronized void clear() {
        this.timeoutQueue.clear();
        this.toPort.clear();
    }

    public synchronized _08OutPacket get() {
        return this.timeoutQueue.peek();
    }

    public synchronized _08OutPacket remove() {
        _08OutPacket _08OutPacket2 = this.timeoutQueue.poll();
        if (_08OutPacket2 != null) {
            this.portName = this.toPort.remove(_08OutPacket2);
        }
        return _08OutPacket2;
    }

    public synchronized void remove(_08InPacket _08InPacket2) {
        Iterator iterator = this.timeoutQueue.iterator();
        while (iterator.hasNext()) {
            _08OutPacket _08OutPacket2 = (_08OutPacket)iterator.next();
            if (!_08InPacket2.equals(_08OutPacket2)) continue;
            this.toPort.remove(_08OutPacket2);
            iterator.remove();
            break;
        }
    }

    private long getTimeoutLeft() {
        _08OutPacket _08OutPacket2 = this.get();
        if (_08OutPacket2 == null) {
            return 5000L;
        }
        return _08OutPacket2.getTimeout() - System.currentTimeMillis();
    }

    private void fireOperationTimeOutEvent(_08OutPacket _08OutPacket2, String string) {
        ErrorPacket errorPacket = new ErrorPacket(1, this.client.getUser());
        errorPacket.timeoutPacket = _08OutPacket2;
        errorPacket.setHeader(_08OutPacket2.getHeader());
        errorPacket.setFamily(_08OutPacket2.getFamily());
        this.client.addIncomingPacket(errorPacket, string);
    }

    @Override
    public T call() throws Exception {
        long l = this.getTimeoutLeft();
        while (l <= 0L) {
            _08OutPacket _08OutPacket2 = this.remove();
            IConnection iConnection = this.client.getConnection(this.portName);
            if (iConnection != null && _08OutPacket2 != null && !iConnection.getPolicy().isReplied(_08OutPacket2, false)) {
                if (_08OutPacket2.needResend()) {
                    this.client.sendPacketAnyway(_08OutPacket2, this.portName);
                } else {
                    this.fireOperationTimeOutEvent(_08OutPacket2, this.portName);
                }
            }
            l = this.getTimeoutLeft();
        }
        QQClient.executor.schedule(this, l, TimeUnit.MILLISECONDS);
        return null;
    }
}

