/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference.client;

import com.hazelcast.concurrent.atomicreference.client.ModifyRequest;
import com.hazelcast.concurrent.atomicreference.operations.CompareAndSetOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CompareAndSetRequest
extends ModifyRequest {
    private Data expected;

    public CompareAndSetRequest() {
    }

    public CompareAndSetRequest(String name, Data expected, Data update) {
        super(name, update);
        this.expected = expected;
    }

    @Override
    protected Operation prepareOperation() {
        return new CompareAndSetOperation(this.name, this.expected, this.update);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.expected);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.expected = in.readData();
    }

    @Override
    public String getMethodName() {
        return "compareAndSet";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.expected, this.update};
    }
}

