/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.operations.MultiMapBackupAwareOperation;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.operations.RemoveAllBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.util.Collection;

public class RemoveAllOperation
extends MultiMapBackupAwareOperation {
    transient Collection<MultiMapRecord> coll;

    public RemoveAllOperation() {
    }

    public RemoveAllOperation(String name, Data dataKey, int threadId) {
        super(name, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        this.coll = this.remove(this.getResponseHandler().isLocal());
        this.response = new MultiMapResponse(this.coll);
    }

    @Override
    public void afterRun() throws Exception {
        if (this.coll != null) {
            this.getOrCreateContainer().update();
            for (MultiMapRecord record : this.coll) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, record.getObject());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.coll != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveAllBackupOperation(this.name, this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(new MultiMapResponse(null));
    }

    @Override
    public int getId() {
        return 18;
    }
}

