/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.operation;

import com.hazelcast.management.ThreadDumpGenerator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ThreadDumpOperation
extends Operation {
    private boolean isDeadlock;
    private String result;

    public ThreadDumpOperation() {
        this(false);
    }

    public ThreadDumpOperation(boolean deadlock) {
        this.isDeadlock = deadlock;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.result = this.isDeadlock ? ThreadDumpGenerator.dumpDeadlocks() : ThreadDumpGenerator.dumpAllThreads();
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.isDeadlock);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.isDeadlock = in.readBoolean();
    }
}

