/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.GetLockCountOperation;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockPortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public final class GetLockCountRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private Data key;

    public GetLockCountRequest() {
    }

    public GetLockCountRequest(Data key) {
        this.key = key;
    }

    @Override
    protected final Operation prepareOperation() {
        String name = (String)this.getClientEngine().toObject(this.key);
        return new GetLockCountOperation(new InternalLockNamespace(name), this.key);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public int getFactoryId() {
        return LockPortableHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        String name = (String)this.getClientEngine().toObject(this.key);
        return new LockPermission(name, "read");
    }
}

