/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.neomedia.SrtpControlType;
import org.osgi.framework.BundleContext;

public abstract class AccountID {
    private static final Logger logger = Logger.getLogger(AccountID.class);
    protected static final String DEFAULTS_PREFIX = "net.java.sip.communicator.service.protocol.";
    private final String protocolDisplayName;
    private final String protocolName;
    protected Map<String, String> accountProperties = null;
    private final String userID;
    private final String accountUID;
    private final String serviceName;

    private static final String getOverriddenProtocolName(Map<String, String> accountProperties, String defaultProtocolName) {
        String key = "PROTOCOL_NAME";
        String protocolName = accountProperties.get(key);
        if (protocolName == null && defaultProtocolName != null) {
            protocolName = defaultProtocolName;
            accountProperties.put(key, protocolName);
        }
        return protocolName;
    }

    protected AccountID(String userID, Map<String, String> accountProperties, String protocolName, String serviceName) {
        this.protocolDisplayName = AccountID.getOverriddenProtocolName(accountProperties, protocolName);
        this.protocolName = protocolName;
        this.userID = userID;
        this.accountProperties = new HashMap<String, String>(accountProperties);
        this.serviceName = serviceName;
        String existingAccountUID = accountProperties.get("ACCOUNT_UID");
        this.accountUID = existingAccountUID == null ? this.protocolDisplayName + ":" + userID + "@" + (serviceName == null ? "" : serviceName) : existingAccountUID;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getDisplayName() {
        String key = "ACCOUNT_DISPLAY_NAME";
        String accountDisplayName = this.accountProperties.get(key);
        if (accountDisplayName != null && accountDisplayName.length() > 0) {
            return accountDisplayName;
        }
        String returnValue = this.getUserID();
        String protocolName = this.getProtocolDisplayName();
        if (protocolName != null && protocolName.trim().length() > 0) {
            returnValue = returnValue + " (" + protocolName + ")";
        }
        return returnValue;
    }

    public void setDisplayName(String displayName) {
        this.setOrRemoveIfEmpty("DISPLAY_NAME", displayName);
    }

    public String getProtocolDisplayName() {
        return this.protocolDisplayName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getAccountUniqueID() {
        return this.accountUID;
    }

    public Map<String, String> getAccountProperties() {
        return new HashMap<String, String>(this.accountProperties);
    }

    public boolean getAccountPropertyBoolean(Object key, boolean defaultValue) {
        String value = this.getAccountPropertyString(key);
        if (value == null) {
            value = this.getDefaultString(key.toString());
        }
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getAccountPropertyInt(Object key, int defaultValue) {
        String stringValue = this.getAccountPropertyString(key);
        int intValue = defaultValue;
        if (stringValue == null || stringValue.isEmpty()) {
            stringValue = this.getDefaultString(key.toString());
        }
        if (stringValue != null && stringValue.length() > 0) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                logger.error((Object)("Failed to parse account property " + key + " value " + stringValue + " as an integer"), (Throwable)ex);
            }
        }
        return intValue;
    }

    public String getAccountPropertyString(Object key) {
        return this.getAccountPropertyString(key, null);
    }

    public String getAccountPropertyString(Object key, String defValue) {
        String value = this.accountProperties.get(key);
        if (value == null) {
            value = this.getDefaultString(key.toString());
        }
        return value == null ? defValue : value;
    }

    public void putAccountProperty(String key, String value) {
        this.accountProperties.put(key, value);
    }

    public void putAccountProperty(String key, Object value) {
        this.accountProperties.put(key, String.valueOf(value));
    }

    public void removeAccountProperty(String key) {
        this.accountProperties.remove(key);
    }

    public int hashCode() {
        return this.accountUID == null ? 0 : this.accountUID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().isInstance(obj) && this.userID.equals(((AccountID)obj).userID);
    }

    public String toString() {
        return this.getAccountUniqueID();
    }

    public String getService() {
        return this.serviceName;
    }

    public String getAccountAddress() {
        String userID = this.getUserID();
        return userID.indexOf(64) > 0 ? userID : userID + "@" + this.getService();
    }

    public boolean isEnabled() {
        return !this.getAccountPropertyBoolean("IS_ACCOUNT_DISABLED", false);
    }

    public String getServerAddress() {
        return this.getAccountPropertyString("SERVER_ADDRESS");
    }

    public String getAccountDisplayName() {
        return this.getAccountPropertyString("ACCOUNT_DISPLAY_NAME");
    }

    public void setAccountDisplayName(String displayName) {
        this.setOrRemoveIfEmpty("ACCOUNT_DISPLAY_NAME", displayName);
    }

    public String getPassword() {
        return this.getAccountPropertyString("PASSWORD");
    }

    public void setPassword(String password) {
        this.setOrRemoveIfEmpty("PASSWORD", password);
    }

    public String getAuthorizationName() {
        return this.getAccountPropertyString("AUTHORIZATION_NAME");
    }

    public void setAuthorizationName(String authName) {
        this.setOrRemoveIfEmpty("AUTHORIZATION_NAME", authName);
    }

    public String getServerPort() {
        return this.getAccountPropertyString("SERVER_PORT");
    }

    public void setServerPort(String port) {
        this.setOrRemoveIfEmpty("SERVER_PORT", port);
    }

    public void setServerAddress(String serverAddress) {
        this.setOrRemoveIfEmpty("SERVER_ADDRESS", serverAddress);
    }

    public boolean isServerOverridden() {
        return this.getAccountPropertyBoolean("IS_SERVER_OVERRIDDEN", false);
    }

    public void setServerOverridden(boolean isServerOverridden) {
        this.putAccountProperty("IS_SERVER_OVERRIDDEN", isServerOverridden);
    }

    public String getProtocolIconPath() {
        return this.getAccountPropertyString("PROTOCOL_ICON_PATH");
    }

    public void setProtocolIconPath(String iconPath) {
        this.putAccountProperty("PROTOCOL_ICON_PATH", iconPath);
    }

    public String getAccountIconPath() {
        return this.getAccountPropertyString("ACCOUNT_ICON_PATH");
    }

    public void setAccountIconPath(String iconPath) {
        this.putAccountProperty("ACCOUNT_ICON_PATH", iconPath);
    }

    public String getDTMFMethod() {
        return this.getAccountPropertyString("DTMF_METHOD");
    }

    public void setDTMFMethod(String dtmfMethod) {
        this.putAccountProperty("DTMF_METHOD", dtmfMethod);
    }

    public String getDtmfMinimalToneDuration() {
        return this.getAccountPropertyString("DTMF_MINIMAL_TONE_DURATION");
    }

    public void setDtmfMinimalToneDuration(String dtmfMinimalToneDuration) {
        this.putAccountProperty("DTMF_MINIMAL_TONE_DURATION", dtmfMinimalToneDuration);
    }

    public String getTlsClientCertificate() {
        return this.getAccountPropertyString("CLIENT_TLS_CERTIFICATE");
    }

    public void setTlsClientCertificate(String id) {
        this.setOrRemoveIfEmpty("CLIENT_TLS_CERTIFICATE", id);
    }

    public boolean isHidden() {
        return this.getAccountPropertyString("IS_PROTOCOL_HIDDEN") != null;
    }

    public boolean isConfigHidden() {
        return this.getAccountPropertyString("IS_CONFIG_HIDDEN") != null;
    }

    public boolean isStatusMenuHidden() {
        return this.getAccountPropertyString("IS_STATUS_MENU_HIDDEN") != null;
    }

    public boolean isReadOnly() {
        return this.getAccountPropertyString("IS_READ_ONLY") != null;
    }

    public boolean isPreferredProvider() {
        String preferredProtocolProp = this.getAccountPropertyString("IS_PREFERRED_PROTOCOL");
        return preferredProtocolProp != null && preferredProtocolProp.length() > 0 && Boolean.parseBoolean(preferredProtocolProp);
    }

    public void setAccountProperties(Map<String, String> accountProperties) {
        this.accountProperties = accountProperties;
    }

    public boolean isEncryptionProtocolEnabled(SrtpControlType type) {
        boolean defaultValue = type == SrtpControlType.ZRTP;
        return this.getAccountPropertyBoolean("ENCRYPTION_PROTOCOL_STATUS." + type.toString(), defaultValue);
    }

    public List<StunServerDescriptor> getStunServers(BundleContext bundleContext) {
        StunServerDescriptor stunServer;
        Map<String, String> accountProperties = this.getAccountProperties();
        ArrayList<StunServerDescriptor> stunServerList = new ArrayList<StunServerDescriptor>();
        for (int i = 0; i < 100 && (stunServer = StunServerDescriptor.loadDescriptor(accountProperties, "STUN" + i)) != null; ++i) {
            String password = AccountID.loadStunPassword(bundleContext, this, "STUN" + i);
            if (password != null) {
                stunServer.setPassword(password);
            }
            stunServerList.add(stunServer);
        }
        return stunServerList;
    }

    protected static String loadStunPassword(BundleContext bundleContext, AccountID accountID, String namePrefix) {
        ProtocolProviderFactory providerFactory = ProtocolProviderFactory.getProtocolProviderFactory(bundleContext, accountID.getSystemProtocolName());
        String password = null;
        String className = providerFactory.getClass().getName();
        String packageSourceName = className.substring(0, className.lastIndexOf(46));
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix(bundleContext, accountID, packageSourceName);
        CredentialsStorageService credentialsService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        try {
            password = credentialsService.loadPassword(accountPrefix + "." + namePrefix);
        }
        catch (Exception e) {
            return null;
        }
        return password;
    }

    public boolean isStunServerDiscoveryEnabled() {
        return this.getAccountPropertyBoolean("AUTO_DISCOVER_STUN", true);
    }

    public boolean isUPNPEnabled() {
        return this.getAccountPropertyBoolean("UPNP_ENABLED", true);
    }

    public boolean isUseDefaultStunServer() {
        return this.getAccountPropertyBoolean("USE_DEFAULT_STUN_SERVER", true);
    }

    public String getSystemProtocolName() {
        return this.getProtocolName();
    }

    public List<SrtpControlType> getSortedEnabledEncryptionProtocolList() {
        Map<String, Integer> encryptionProtocols = this.getIntegerPropertiesByPrefix("ENCRYPTION_PROTOCOL", true);
        Map<String, Boolean> encryptionProtocolStatus = this.getBooleanPropertiesByPrefix("ENCRYPTION_PROTOCOL_STATUS", true, false);
        if (encryptionProtocols.size() == 0) {
            encryptionProtocols.put("ENCRYPTION_PROTOCOL.ZRTP", 0);
            encryptionProtocolStatus.put("ENCRYPTION_PROTOCOL_STATUS.ZRTP", true);
        }
        ArrayList<SrtpControlType> sortedEncryptionProtocols = new ArrayList<SrtpControlType>(encryptionProtocols.size());
        for (Map.Entry<String, Integer> e : encryptionProtocols.entrySet()) {
            int index = e.getValue();
            if (index == -1) continue;
            if (index > sortedEncryptionProtocols.size()) {
                index = sortedEncryptionProtocols.size();
            }
            String name = e.getKey().substring("ENCRYPTION_PROTOCOL".length() + 1);
            sortedEncryptionProtocols.add(index, SrtpControlType.fromString((String)name));
        }
        Iterator i = sortedEncryptionProtocols.iterator();
        while (i.hasNext()) {
            String name = ((SrtpControlType)i.next()).toString();
            if (encryptionProtocolStatus.get("ENCRYPTION_PROTOCOL_STATUS." + name).booleanValue()) continue;
            i.remove();
        }
        return sortedEncryptionProtocols;
    }

    public Map<String, Boolean> getBooleanPropertiesByPrefix(String prefix, boolean exactPrefixMatch, boolean defaultValue) {
        List<String> propertyNames = this.getPropertyNamesByPrefix(prefix, exactPrefixMatch);
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(propertyNames.size());
        for (int i = 0; i < propertyNames.size(); ++i) {
            String propertyName = propertyNames.get(i);
            properties.put(propertyName, this.getAccountPropertyBoolean(propertyName, defaultValue));
        }
        return properties;
    }

    public Map<String, Integer> getIntegerPropertiesByPrefix(String prefix, boolean exactPrefixMatch) {
        List<String> propertyNames = this.getPropertyNamesByPrefix(prefix, exactPrefixMatch);
        HashMap<String, Integer> properties = new HashMap<String, Integer>(propertyNames.size());
        for (int i = 0; i < propertyNames.size(); ++i) {
            String propertyName = propertyNames.get(i);
            properties.put(propertyName, this.getAccountPropertyInt(propertyName, -1));
        }
        return properties;
    }

    public List<String> getPropertyNamesByPrefix(String prefix, boolean exactPrefixMatch) {
        LinkedList<String> resultKeySet = new LinkedList<String>();
        for (String key : this.accountProperties.keySet()) {
            int ix = key.lastIndexOf(46);
            if (ix == -1) continue;
            String keyPrefix = key.substring(0, ix);
            if (exactPrefixMatch) {
                if (!prefix.equals(keyPrefix)) continue;
                resultKeySet.add(key);
                continue;
            }
            if (!keyPrefix.startsWith(prefix)) continue;
            resultKeySet.add(key);
        }
        return resultKeySet;
    }

    public void setOrRemoveIfNull(String key, String value) {
        if (value != null) {
            this.putAccountProperty(key, value);
        } else {
            this.removeAccountProperty(key);
        }
    }

    public void setOrRemoveIfEmpty(String key, String value) {
        this.setOrRemoveIfEmpty(key, value, false);
    }

    public void setOrRemoveIfEmpty(String key, String value, boolean trim) {
        if (value != null && (trim ? !value.trim().isEmpty() : !value.isEmpty())) {
            this.putAccountProperty(key, value);
        } else {
            this.removeAccountProperty(key);
        }
    }

    public void storeProperties(String protocolIconPath, String accountIconPath, Map<String, String> accountProperties) {
        if (protocolIconPath != null) {
            this.setProtocolIconPath(protocolIconPath);
        }
        if (accountIconPath != null) {
            this.setAccountIconPath(accountIconPath);
        }
        AccountID.mergeProperties(this.accountProperties, accountProperties);
        accountProperties.remove("ENCRYPTED_PASSWORD");
    }

    protected String getDefaultString(String key) {
        return AccountID.getDefaultStr(key);
    }

    public static String getDefaultStr(String key) {
        return ProtocolProviderActivator.getConfigurationService().getString(DEFAULTS_PREFIX + key);
    }

    public static void mergeProperties(Map<String, String> input, Map<String, String> output) {
        for (String key : input.keySet()) {
            output.put(key, input.get(key));
        }
    }
}

