/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

class ExecutionCallbackAdapterFactory {
    private final MultiExecutionCallback multiExecutionCallback;
    private final ConcurrentMap<Member, ValueWrapper> responses;
    private final Collection<Member> members;
    private final ILogger logger;
    private final AtomicBoolean done = new AtomicBoolean(false);

    ExecutionCallbackAdapterFactory(NodeEngine nodeEngine, Collection<Member> members, MultiExecutionCallback multiExecutionCallback) {
        this.multiExecutionCallback = multiExecutionCallback;
        this.responses = new ConcurrentHashMap<Member, ValueWrapper>(members.size());
        this.members = new HashSet<Member>(members);
        this.logger = nodeEngine.getLogger(ExecutionCallbackAdapterFactory.class.getName());
    }

    private void onResponse(Member member, Object response) {
        if (this.done.get()) {
            throw new IllegalStateException("This callback is invalid!");
        }
        if (this.members.contains(member)) {
            ValueWrapper current = null;
            current = this.responses.put(member, new ValueWrapper(response));
            if (current != null) {
                this.logger.warning("Replacing current callback value[" + current.value + " with value[" + response + "].");
            }
            try {
                this.multiExecutionCallback.onResponse(member, response);
            }
            catch (Throwable e) {
                this.logger.warning(e.getMessage(), e);
            }
            if (this.members.size() == this.responses.size() && this.done.compareAndSet(false, true)) {
                HashMap<Member, Object> realResponses = new HashMap<Member, Object>(this.members.size());
                for (Map.Entry entry : this.responses.entrySet()) {
                    realResponses.put((Member)entry.getKey(), ((ValueWrapper)entry.getValue()).value);
                }
                this.multiExecutionCallback.onComplete(realResponses);
            }
        } else {
            throw new IllegalArgumentException(member + " is not known by this callback!");
        }
    }

    <V> ExecutionCallback<V> callbackFor(Member member) {
        return new InnerExecutionCallback(member);
    }

    private class InnerExecutionCallback<V>
    implements ExecutionCallback<V> {
        private final Member member;

        private InnerExecutionCallback(Member member) {
            this.member = member;
        }

        @Override
        public void onResponse(V response) {
            ExecutionCallbackAdapterFactory.this.onResponse(this.member, response);
        }

        @Override
        public void onFailure(Throwable t) {
            ExecutionCallbackAdapterFactory.this.onResponse(this.member, t);
        }
    }

    private class ValueWrapper {
        final Object value;

        private ValueWrapper(Object value) {
            this.value = value;
        }
    }
}

