/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.ActiveCallsRepositoryJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.CallIdPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.Reason;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferPacketExtension;
import net.java.sip.communicator.service.protocol.AbstractCallPeer;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetSecureSDesTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSecureZrtpTelephony;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.TransferAuthority;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class OperationSetBasicTelephonyJabberImpl
extends AbstractOperationSetBasicTelephony<ProtocolProviderServiceJabberImpl>
implements RegistrationStateChangeListener,
PacketListener,
PacketFilter,
OperationSetSecureSDesTelephony,
OperationSetSecureZrtpTelephony,
OperationSetAdvancedTelephony<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetBasicTelephonyJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl protocolProvider;
    private ActiveCallsRepositoryJabberGTalkImpl<CallJabberImpl, CallPeerJabberImpl> activeCallsRepository = new ActiveCallsRepositoryJabberGTalkImpl(this);
    private static final String GOOGLE_VOICE_DOMAIN = "voice.google.com";

    public OperationSetBasicTelephonyJabberImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
        this.protocolProvider.addRegistrationStateChangeListener(this);
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        RegistrationState registrationState = evt.getNewState();
        if (registrationState == RegistrationState.REGISTERING) {
            ProviderManager.getInstance().addIQProvider("jingle", "urn:xmpp:jingle:1", (Object)new JingleIQProvider());
            this.subscribeForJinglePackets();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle : ON ");
            }
        } else if (registrationState == RegistrationState.UNREGISTERED) {
            this.unsubscribeForJinglePackets();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle : OFF ");
            }
        }
    }

    public Call createCall(String callee, CallConference conference) throws OperationFailedException {
        AbstractCallPeer<?, ?> callPeer;
        CallJabberImpl call = new CallJabberImpl(this);
        if (conference != null) {
            call.setConference(conference);
        }
        if ((callPeer = this.createOutgoingCall(call, callee)) == null) {
            throw new OperationFailedException("Failed to create outgoing call because no peer was created", 4);
        }
        Call callOfCallPeer = callPeer.getCall();
        if (callOfCallPeer != call && conference != null) {
            callOfCallPeer.setConference(conference);
        }
        return callOfCallPeer;
    }

    public CallJabberImpl createCall(ConferenceDescription cd, final ChatRoom chatRoom) throws OperationFailedException {
        final CallJabberImpl call = new CallJabberImpl(this);
        ((ChatRoomJabberImpl)chatRoom).addConferenceCall(call);
        call.addCallChangeListener(new CallChangeListener(){

            public void callPeerAdded(CallPeerEvent ev) {
            }

            public void callPeerRemoved(CallPeerEvent ev) {
            }

            public void callStateChanged(CallChangeEvent ev) {
                if (CallState.CALL_ENDED.equals(ev.getNewValue())) {
                    ((ChatRoomJabberImpl)chatRoom).removeConferenceCall(call);
                }
            }
        });
        String remoteJid = cd.getUri();
        if (remoteJid.startsWith("xmpp:")) {
            remoteJid = remoteJid.substring(5, remoteJid.length());
        }
        ArrayList<PacketExtension> sessionInitiateExtensions = new ArrayList<PacketExtension>(2);
        String callid = cd.getCallId();
        if (callid != null) {
            sessionInitiateExtensions.add(new CallIdPacketExtension(callid));
        }
        call.initiateSession(remoteJid, null, sessionInitiateExtensions, cd.getSupportedTransports());
        return call;
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress) throws OperationFailedException {
        return this.createOutgoingCall(call, calleeAddress, null);
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress, Iterable<PacketExtension> sessionInitiateExtensions) throws OperationFailedException {
        return this.createOutgoingCall(call, calleeAddress, null, null);
    }

    AbstractCallPeer<?, ?> createOutgoingCall(CallJabberImpl call, String calleeAddress, String fullCalleeURI, Iterable<PacketExtension> sessionInitiateExtensions) throws OperationFailedException {
        String bypassDomain;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating outgoing call to " + calleeAddress));
        }
        if (this.protocolProvider.getConnection() == null || call == null) {
            throw new OperationFailedException("Failed to create OutgoingJingleSession. We don't have a valid XMPPConnection.", 4);
        }
        boolean isGoogle = this.protocolProvider.isGmailOrGoogleAppsAccount();
        boolean isGoogleVoice = false;
        if (isGoogle) {
            if (!calleeAddress.contains("@")) {
                calleeAddress = calleeAddress + "@voice.google.com";
                isGoogleVoice = true;
            } else if (calleeAddress.endsWith(GOOGLE_VOICE_DOMAIN)) {
                isGoogleVoice = true;
            }
        }
        AccountID accountID = this.getProtocolProvider().getAccountID();
        if (calleeAddress.indexOf(64) == -1) {
            String phoneSuffix = accountID.getAccountPropertyString((Object)"OVERRIDE_PHONE_SUFFIX");
            String serviceName = null;
            serviceName = phoneSuffix == null || phoneSuffix.length() == 0 ? StringUtils.parseServer((String)accountID.getUserID()) : phoneSuffix;
            calleeAddress = calleeAddress + "@" + serviceName;
        }
        boolean alwaysCallGtalk = (bypassDomain = accountID.getAccountPropertyString((Object)"TELEPHONY_BYPASS_GTALK_CAPS")) != null && bypassDomain.equals(calleeAddress.substring(calleeAddress.indexOf(64) + 1)) || isGoogleVoice;
        boolean isPrivateMessagingContact = ((OperationSetMultiUserChat)this.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class)).isPrivateMessagingContact(calleeAddress);
        if (!(this.getProtocolProvider().getConnection().getRoster().contains(StringUtils.parseBareAddress((String)calleeAddress)) || isPrivateMessagingContact || alwaysCallGtalk)) {
            throw new OperationFailedException(calleeAddress + " does not belong to our contact list", 404);
        }
        if (fullCalleeURI == null) {
            fullCalleeURI = this.discoverFullJid(calleeAddress, alwaysCallGtalk);
        }
        if (fullCalleeURI == null) {
            throw new OperationFailedException("Failed to create outgoing call to " + calleeAddress + ". Could not find a resource which supports " + "Jingle or Google Talk", 4);
        }
        DiscoverInfo di = null;
        try {
            di = this.protocolProvider.getDiscoveryManager().discoverInfo(fullCalleeURI);
        }
        catch (XMPPException ex) {
            logger.warn((Object)("could not retrieve info for " + fullCalleeURI), (Throwable)ex);
        }
        if (di != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(fullCalleeURI + ": jingle supported "));
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(fullCalleeURI + ": jingle not supported?"));
            }
            throw new OperationFailedException("Failed to create an outgoing call.\n" + fullCalleeURI + " does not support jingle or Google Talk", 4);
        }
        CallPeerJabberImpl peer = null;
        try {
            if (di != null) {
                peer = call.initiateSession(fullCalleeURI, di, sessionInitiateExtensions, null);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("Failed to create a call to " + fullCalleeURI, 4, t, logger);
        }
        return peer;
    }

    private String discoverFullJid(String calleeAddress, boolean isAlwaysCallGtalk) {
        String fullCalleeURI = null;
        DiscoverInfo discoverInfo = null;
        int bestPriority = -1;
        boolean isGingle = false;
        String gingleURI = null;
        PresenceStatus jabberStatus = null;
        String calleeURI = null;
        Iterator it = this.getProtocolProvider().getConnection().getRoster().getPresences(calleeAddress);
        while (it.hasNext()) {
            PresenceStatus tempStatus;
            Presence presence = (Presence)it.next();
            int priority = presence.getPriority() == Integer.MIN_VALUE ? 0 : presence.getPriority();
            calleeURI = presence.getFrom();
            try {
                discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(calleeURI);
            }
            catch (XMPPException ex) {
                logger.warn((Object)("could not retrieve info for " + fullCalleeURI), (Throwable)ex);
            }
            boolean hasGtalkCaps = this.getProtocolProvider().isExtFeatureListSupported(calleeURI, "voice-v1");
            if (discoverInfo != null && discoverInfo.containsFeature("urn:xmpp:jingle:1")) {
                if (priority > bestPriority) {
                    bestPriority = priority;
                    fullCalleeURI = calleeURI;
                    isGingle = false;
                    jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider);
                    continue;
                }
                if (priority != bestPriority || jabberStatus == null || (tempStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider)).compareTo(jabberStatus) <= 0) continue;
                fullCalleeURI = calleeURI;
                isGingle = false;
                jabberStatus = tempStatus;
                continue;
            }
            if (!this.protocolProvider.isGTalkTesting() || !hasGtalkCaps && !isAlwaysCallGtalk) continue;
            if (priority > bestPriority) {
                bestPriority = priority;
                isGingle = true;
                gingleURI = calleeURI;
                jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider);
                continue;
            }
            if (priority != bestPriority || jabberStatus == null || (tempStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider)).compareTo(jabberStatus) <= 0) continue;
            isGingle = true;
            gingleURI = calleeURI;
            jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.protocolProvider);
        }
        if (isGingle) {
            fullCalleeURI = gingleURI;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Full JID for outgoing call: " + fullCalleeURI + ", priority " + bestPriority));
        }
        return fullCalleeURI;
    }

    String getFullCalleeURI(String calleeAddress) {
        return calleeAddress.indexOf(47) > 0 ? calleeAddress : this.protocolProvider.getConnection().getRoster().getPresence(calleeAddress).getFrom();
    }

    public Iterator<CallJabberImpl> getActiveCalls() {
        return this.activeCallsRepository.getActiveCalls();
    }

    public CallPeerJabberImpl getActiveCallPeer(String sid) {
        return this.activeCallsRepository.findCallPeer(sid);
    }

    public synchronized void putOffHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, false);
    }

    public synchronized void putOnHold(CallPeer peer) throws OperationFailedException {
        this.putOnHold(peer, true);
    }

    private void putOnHold(CallPeer peer, boolean on) throws OperationFailedException {
        if (peer instanceof CallPeerJabberImpl) {
            ((CallPeerJabberImpl)peer).putOnHold(on);
        }
    }

    public synchronized void hangupCallPeer(CallPeer peer) throws ClassCastException, OperationFailedException {
        this.hangupCallPeer(peer, 200, null);
    }

    public void hangupCallPeer(CallPeer peer, int reasonCode, String reasonText) {
        Reason reason;
        boolean failed = reasonCode != 200;
        ReasonPacketExtension reasonPacketExt = null;
        if (failed && reasonText != null && (reason = OperationSetBasicTelephonyJabberImpl.convertReasonCodeToSIPCode(reasonCode)) != null) {
            reasonPacketExt = new ReasonPacketExtension(reason, reasonText, null);
        }
        if (peer instanceof CallPeerJabberImpl) {
            ((CallPeerJabberImpl)peer).hangup(failed, reasonText, reasonPacketExt);
        }
    }

    private static Reason convertReasonCodeToSIPCode(int reasonCode) {
        switch (reasonCode) {
            case 200: {
                return Reason.SUCCESS;
            }
            case 609: {
                return Reason.SECURITY_ERROR;
            }
            case 408: {
                return Reason.TIMEOUT;
            }
            case 486: {
                return Reason.BUSY;
            }
        }
        return null;
    }

    public void answerCallPeer(CallPeer peer) throws OperationFailedException {
        if (peer instanceof CallPeerJabberImpl) {
            ((CallPeerJabberImpl)peer).answer();
        }
    }

    public void shutdown() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Ending all active calls. ");
        }
        Iterator activeCalls = this.activeCallsRepository.getActiveCalls();
        while (activeCalls.hasNext()) {
            CallJabberImpl call = (CallJabberImpl)((Object)activeCalls.next());
            Iterator callPeers = call.getCallPeers();
            while (callPeers.hasNext()) {
                CallPeer peer = (CallPeer)callPeers.next();
                try {
                    this.hangupCallPeer(peer);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to properly hangup peer " + peer), (Throwable)ex);
                }
            }
        }
    }

    private void subscribeForJinglePackets() {
        this.protocolProvider.getConnection().addPacketListener((PacketListener)this, (PacketFilter)this);
    }

    private void unsubscribeForJinglePackets() {
        XMPPConnection connection = this.protocolProvider.getConnection();
        if (connection != null) {
            connection.removePacketListener((PacketListener)this);
        }
    }

    public boolean accept(Packet packet) {
        if (!(packet instanceof JingleIQ)) {
            XMPPError error;
            String packetID = packet.getPacketID();
            CallPeerJabberImpl callPeer = this.activeCallsRepository.findCallPeerBySessInitPacketID(packetID);
            if (callPeer != null && (error = packet.getError()) != null) {
                String message;
                String errorMessage = error.getMessage();
                logger.error((Object)("Received an error: code=" + error.getCode() + " message=" + errorMessage));
                if (errorMessage == null) {
                    Roster roster = this.getProtocolProvider().getConnection().getRoster();
                    String packetFrom = packet.getFrom();
                    message = "Service unavailable";
                    if (!roster.contains(packetFrom)) {
                        message = message + ": try adding the contact " + packetFrom + " to your contact list first.";
                    }
                } else {
                    message = errorMessage;
                }
                callPeer.setState(CallPeerState.FAILED, message);
            }
            return false;
        }
        if (packet instanceof JingleIQ) {
            JingleIQ jingleIQ = (JingleIQ)packet;
            if (jingleIQ.getAction() == JingleAction.SESSION_INITIATE) {
                return jingleIQ.containsContentChildOfType(RtpDescriptionPacketExtension.class);
            }
            String sid = jingleIQ.getSID();
            return this.activeCallsRepository.findSID(sid) != null;
        }
        return false;
    }

    public void processPacket(Packet packet) {
        block5: {
            IQ iq = (IQ)packet;
            if (iq.getType() == IQ.Type.SET) {
                IQ ack = IQ.createResultIQ((IQ)iq);
                this.protocolProvider.getConnection().sendPacket((Packet)ack);
            }
            try {
                if (iq instanceof JingleIQ) {
                    this.processJingleIQ((JingleIQ)iq);
                }
            }
            catch (Throwable t) {
                if (logger.isInfoEnabled()) {
                    String packetClass = iq instanceof JingleIQ ? "Jingle" : packet.getClass().getSimpleName();
                    logger.info((Object)("Error while handling incoming " + packetClass + " packet: "), t);
                }
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }

    private void processJingleIQ(final JingleIQ jingleIQ) {
        CallPeerJabberImpl callPeer = this.activeCallsRepository.findCallPeer(jingleIQ.getSID());
        IQ.Type type = jingleIQ.getType();
        if (type == IQ.Type.ERROR) {
            logger.error((Object)"Received error");
            XMPPError error = jingleIQ.getError();
            String message = "Remote party returned an error!";
            if (error != null) {
                String errorStr = "code=" + error.getCode() + " message=" + error.getMessage();
                message = message + "\n" + errorStr;
                logger.error((Object)(" " + errorStr));
            }
            if (callPeer != null) {
                callPeer.setState(CallPeerState.FAILED, message);
            }
            return;
        }
        JingleAction action = jingleIQ.getAction();
        if (action == JingleAction.SESSION_INITIATE) {
            String callid;
            CallPeerJabberImpl attendant;
            CallJabberImpl attendantCall;
            String sid;
            TransferPacketExtension transfer = (TransferPacketExtension)jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
            CallIdPacketExtension callidExt = (CallIdPacketExtension)jingleIQ.getExtension("callid", "http://jitsi.org/protocol/condesc");
            CallJabberImpl call = null;
            if (transfer != null && (sid = transfer.getSID()) != null && (attendantCall = this.getActiveCallsRepository().findSID(sid)) != null && (attendant = (CallPeerJabberImpl)((Object)attendantCall.getPeer(sid))) != null && this.getFullCalleeURI(attendant.getAddress()).equals(transfer.getFrom()) && this.protocolProvider.getOurJID().equals(transfer.getTo())) {
                call = attendantCall;
            }
            if (callidExt != null && (callid = callidExt.getText()) != null) {
                call = this.getActiveCallsRepository().findCallId(callid);
            }
            if (transfer != null && callidExt != null) {
                logger.warn((Object)"Received a session-initiate with both 'transfer' and 'callid' extensions. Ignored 'transfer' and used 'callid'.");
            }
            if (call == null) {
                call = new CallJabberImpl(this);
            }
            final CallJabberImpl finalCall = call;
            new Thread(){

                @Override
                public void run() {
                    finalCall.processSessionInitiate(jingleIQ);
                }
            }.start();
            return;
        }
        if (callPeer == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a stray trying response.");
            }
            return;
        }
        if (action == JingleAction.SESSION_TERMINATE) {
            callPeer.processSessionTerminate(jingleIQ);
        } else if (action == JingleAction.SESSION_ACCEPT) {
            callPeer.processSessionAccept(jingleIQ);
        } else if (action == JingleAction.SESSION_INFO) {
            SessionInfoPacketExtension info = jingleIQ.getSessionInfo();
            if (info != null) {
                callPeer.processSessionInfo(info);
            } else {
                PacketExtension packetExtension = jingleIQ.getExtension("transfer", "urn:xmpp:jingle:transfer:0");
                if (packetExtension instanceof TransferPacketExtension) {
                    TransferPacketExtension transfer = (TransferPacketExtension)packetExtension;
                    if (transfer.getFrom() == null) {
                        transfer.setFrom(jingleIQ.getFrom());
                    }
                    try {
                        callPeer.processTransfer(transfer);
                    }
                    catch (OperationFailedException ofe) {
                        logger.error((Object)("Failed to transfer to " + transfer.getTo()), (Throwable)ofe);
                    }
                }
                if ((packetExtension = jingleIQ.getExtension("conference-info", "")) instanceof CoinPacketExtension) {
                    CoinPacketExtension coinExt = (CoinPacketExtension)packetExtension;
                    callPeer.setConferenceFocus(Boolean.parseBoolean(coinExt.getAttributeAsString("isfocus")));
                }
            }
        } else if (action == JingleAction.CONTENT_ACCEPT) {
            callPeer.processContentAccept(jingleIQ);
        } else if (action == JingleAction.CONTENT_ADD) {
            callPeer.processContentAdd(jingleIQ);
        } else if (action == JingleAction.CONTENT_MODIFY) {
            callPeer.processContentModify(jingleIQ);
        } else if (action == JingleAction.CONTENT_REJECT) {
            callPeer.processContentReject(jingleIQ);
        } else if (action == JingleAction.CONTENT_REMOVE) {
            callPeer.processContentRemove(jingleIQ);
        } else if (action == JingleAction.TRANSPORT_INFO) {
            callPeer.processTransportInfo(jingleIQ);
        }
    }

    protected ActiveCallsRepositoryJabberGTalkImpl<CallJabberImpl, CallPeerJabberImpl> getActiveCallsRepository() {
        return this.activeCallsRepository;
    }

    public ProtocolProviderServiceJabberImpl getProtocolProvider() {
        return this.protocolProvider;
    }

    public boolean isSecure(CallPeer peer) {
        return ((MediaAwareCallPeer)peer).getMediaHandler().isSecure();
    }

    public void transfer(CallPeer peer, CallPeer target) throws OperationFailedException {
        AbstractCallPeerJabberGTalkImpl targetJabberGTalkImpl = (AbstractCallPeerJabberGTalkImpl)target;
        String to = this.getFullCalleeURI(targetJabberGTalkImpl.getAddress());
        try {
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(to);
            if (!discoverInfo.containsFeature("urn:xmpp:jingle:transfer:0")) {
                throw new OperationFailedException("Callee " + to + " does not support" + " XEP-0251: Jingle Session Transfer", 4);
            }
        }
        catch (XMPPException xmppe) {
            logger.warn((Object)("Failed to retrieve DiscoverInfo for " + to), (Throwable)xmppe);
        }
        this.transfer(peer, to, targetJabberGTalkImpl.getSID());
    }

    public void transfer(CallPeer peer, String target) throws OperationFailedException {
        this.transfer(peer, target, null);
    }

    private void transfer(CallPeer peer, String to, String sid) throws OperationFailedException {
        String caller = this.getFullCalleeURI(peer.getAddress());
        try {
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(caller);
            if (!discoverInfo.containsFeature("urn:xmpp:jingle:transfer:0")) {
                throw new OperationFailedException("Caller " + caller + " does not support" + " XEP-0251: Jingle Session Transfer", 4);
            }
        }
        catch (XMPPException xmppe) {
            logger.warn((Object)("Failed to retrieve DiscoverInfo for " + to), (Throwable)xmppe);
        }
        ((CallPeerJabberImpl)peer).transfer(this.getFullCalleeURI(to), sid);
    }

    public void setTransferAuthority(TransferAuthority authority) {
    }
}

