/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.IsLockedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AbstractIsLockedRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected Data key;
    private int threadId;

    public AbstractIsLockedRequest() {
    }

    public AbstractIsLockedRequest(Data key) {
        this.key = key;
        this.threadId = -1;
    }

    protected AbstractIsLockedRequest(Data key, int threadId) {
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    protected final Operation prepareOperation() {
        return new IsLockedOperation(this.getNamespace(), this.key, this.threadId);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    protected abstract ObjectNamespace getNamespace();

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("tid", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.threadId = reader.readInt("tid");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }
}

