/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.list;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.list.ListContainer;
import com.hazelcast.collection.list.ListProxyImpl;
import com.hazelcast.collection.list.ListReplicationOperation;
import com.hazelcast.collection.txn.TransactionalListProxy;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.transaction.impl.TransactionSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ListService
extends CollectionService {
    public static final String SERVICE_NAME = "hz:impl:listService";
    private final ConcurrentMap<String, ListContainer> containerMap = new ConcurrentHashMap<String, ListContainer>();

    public ListService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public ListContainer getOrCreateContainer(String name, boolean backup) {
        ListContainer current;
        ListContainer container = (ListContainer)this.containerMap.get(name);
        if (container == null && (current = this.containerMap.putIfAbsent(name, container = new ListContainer(name, this.nodeEngine, this))) != null) {
            container = current;
        }
        return container;
    }

    @Override
    public Map<String, ? extends CollectionContainer> getContainerMap() {
        return this.containerMap;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public DistributedObject createDistributedObject(String objectId) {
        return new ListProxyImpl(objectId, this.nodeEngine, this);
    }

    public TransactionalListProxy createTransactionalObject(String name, TransactionSupport transaction) {
        return new TransactionalListProxy(name, transaction, this.nodeEngine, this);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        Map<String, CollectionContainer> migrationData = this.getMigrationData(event);
        return migrationData.isEmpty() ? null : new ListReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }
}

