/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ServiceRedirect
extends ConnCommand {
    private static final int TYPE_FAMILY = 13;
    private static final int TYPE_HOST = 5;
    private static final int TYPE_COOKIE = 6;
    private final int family;
    private final String host;
    private final int port;
    private final ByteBlock cookie;

    protected ServiceRedirect(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        this.family = immutableTlvChain.getUShort(13);
        String string = immutableTlvChain.getString(5);
        if (string != null) {
            int n = string.indexOf(58);
            if (n != -1) {
                this.host = string.substring(0, n);
                int n2 = -1;
                String string2 = string.substring(n + 1);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.port = n2;
            } else {
                this.host = string;
                this.port = -1;
            }
        } else {
            this.host = null;
            this.port = -1;
        }
        this.cookie = immutableTlvChain.getLastTlv(6).getData();
    }

    public ServiceRedirect(int n, String string, ByteBlock byteBlock) {
        this(n, string, -1, byteBlock);
    }

    public ServiceRedirect(int n, String string, int n2, ByteBlock byteBlock) {
        super(5);
        DefensiveTools.checkRange(n, "family", 0);
        this.family = n;
        this.host = string;
        this.port = n2;
        this.cookie = byteBlock;
    }

    public final int getSnacFamily() {
        return this.family;
    }

    public final String getRedirectHost() {
        return this.host;
    }

    public int getRedirectPort() {
        return this.port;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        Tlv.getUShortInstance(13, this.family).write(outputStream);
        if (this.host != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.host);
            if (this.port != -1) {
                stringBuffer.append(':');
                stringBuffer.append(this.port);
            }
            Tlv.getStringInstance(5, stringBuffer.toString()).write(outputStream);
        }
        if (this.cookie != null) {
            new Tlv(6, this.cookie).write(outputStream);
        }
    }

    public String toString() {
        return "ServiceRedirect: family=0x" + Integer.toHexString(this.family) + ", host=" + this.host + ", port=" + this.port + ", cookie=" + this.cookie.getLength() + " bytes";
    }
}

