/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.header;

import de.javawi.jstun.attribute.MessageAttribute;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public class MessageHeader
implements MessageHeaderInterface {
    private static Logger logger = Logger.getLogger("de.javawi.stun.header.MessageHeader");
    MessageHeaderInterface.MessageHeaderType type;
    byte[] id = new byte[16];
    TreeMap<MessageAttributeInterface.MessageAttributeType, MessageAttribute> ma = new TreeMap();

    public MessageHeader() {
    }

    public MessageHeader(MessageHeaderInterface.MessageHeaderType type) {
        this.setType(type);
    }

    public void setType(MessageHeaderInterface.MessageHeaderType type) {
        this.type = type;
    }

    public MessageHeaderInterface.MessageHeaderType getType() {
        return this.type;
    }

    public static int typeToInteger(MessageHeaderInterface.MessageHeaderType type) {
        if (type == MessageHeaderInterface.MessageHeaderType.BindingRequest) {
            return 1;
        }
        if (type == MessageHeaderInterface.MessageHeaderType.BindingResponse) {
            return 257;
        }
        if (type == MessageHeaderInterface.MessageHeaderType.BindingErrorResponse) {
            return 273;
        }
        if (type == MessageHeaderInterface.MessageHeaderType.SharedSecretRequest) {
            return 2;
        }
        if (type == MessageHeaderInterface.MessageHeaderType.SharedSecretResponse) {
            return 258;
        }
        if (type == MessageHeaderInterface.MessageHeaderType.SharedSecretErrorResponse) {
            return 274;
        }
        return -1;
    }

    public void setTransactionID(byte[] id) {
        System.arraycopy(id, 0, this.id, 0, 16);
    }

    public void generateTransactionID() throws UtilityException {
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 0, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 2, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 4, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 6, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 8, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 10, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 12, 2);
        System.arraycopy(Utility.integerToTwoBytes((int)(Math.random() * 65536.0)), 0, this.id, 14, 2);
    }

    public byte[] getTransactionID() {
        byte[] idCopy = new byte[this.id.length];
        System.arraycopy(this.id, 0, idCopy, 0, this.id.length);
        return idCopy;
    }

    public boolean equalTransactionID(MessageHeader header) {
        byte[] idHeader = header.getTransactionID();
        if (idHeader.length != 16) {
            return false;
        }
        return idHeader[0] == this.id[0] && idHeader[1] == this.id[1] && idHeader[2] == this.id[2] && idHeader[3] == this.id[3] && idHeader[4] == this.id[4] && idHeader[5] == this.id[5] && idHeader[6] == this.id[6] && idHeader[7] == this.id[7] && idHeader[8] == this.id[8] && idHeader[9] == this.id[9] && idHeader[10] == this.id[10] && idHeader[11] == this.id[11] && idHeader[12] == this.id[12] && idHeader[13] == this.id[13] && idHeader[14] == this.id[14] && idHeader[15] == this.id[15];
    }

    public void addMessageAttribute(MessageAttribute attri) {
        this.ma.put(attri.getType(), attri);
    }

    public MessageAttribute getMessageAttribute(MessageAttributeInterface.MessageAttributeType type) {
        return this.ma.get((Object)type);
    }

    public byte[] getBytes() throws UtilityException {
        int length = 20;
        Iterator<MessageAttributeInterface.MessageAttributeType> it = this.ma.keySet().iterator();
        while (it.hasNext()) {
            MessageAttribute attri = this.ma.get((Object)it.next());
            length += attri.getLength();
        }
        byte[] result = new byte[length];
        System.arraycopy(Utility.integerToTwoBytes(MessageHeader.typeToInteger(this.type)), 0, result, 0, 2);
        System.arraycopy(Utility.integerToTwoBytes(length - 20), 0, result, 2, 2);
        System.arraycopy(this.id, 0, result, 4, 16);
        int offset = 20;
        it = this.ma.keySet().iterator();
        while (it.hasNext()) {
            MessageAttribute attri = this.ma.get((Object)it.next());
            System.arraycopy(attri.getBytes(), 0, result, offset, attri.getLength());
            offset += attri.getLength();
        }
        return result;
    }

    public int getLength() throws UtilityException {
        return this.getBytes().length;
    }

    public void parseAttributes(byte[] data) throws MessageAttributeParsingException {
        try {
            byte[] lengthArray = new byte[2];
            System.arraycopy(data, 2, lengthArray, 0, 2);
            int length = Utility.twoBytesToInteger(lengthArray);
            System.arraycopy(data, 4, this.id, 0, 16);
            int offset = 20;
            while (length > 0) {
                byte[] cuttedData = new byte[length];
                System.arraycopy(data, offset, cuttedData, 0, length);
                MessageAttribute ma = MessageAttribute.parseCommonHeader(cuttedData);
                this.addMessageAttribute(ma);
                length -= ma.getLength();
                offset += ma.getLength();
            }
        }
        catch (UtilityException ue) {
            throw new MessageAttributeParsingException("Parsing error");
        }
    }

    public static MessageHeader parseHeader(byte[] data) throws MessageHeaderParsingException {
        try {
            MessageHeader mh = new MessageHeader();
            byte[] typeArray = new byte[2];
            System.arraycopy(data, 0, typeArray, 0, 2);
            int type = Utility.twoBytesToInteger(typeArray);
            switch (type) {
                case 1: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                    logger.finer("Binding Request received.");
                    break;
                }
                case 257: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.BindingResponse);
                    logger.finer("Binding Response received.");
                    break;
                }
                case 273: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.BindingErrorResponse);
                    logger.finer("Binding Error Response received.");
                    break;
                }
                case 2: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretRequest);
                    logger.finer("Shared Secret Request received.");
                    break;
                }
                case 258: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretResponse);
                    logger.finer("Shared Secret Response received.");
                    break;
                }
                case 274: {
                    mh.setType(MessageHeaderInterface.MessageHeaderType.SharedSecretErrorResponse);
                    logger.finer("Shared Secret Error Response received.");
                    break;
                }
                default: {
                    throw new MessageHeaderParsingException("Message type " + type + "is not supported");
                }
            }
            return mh;
        }
        catch (UtilityException ue) {
            throw new MessageHeaderParsingException("Parsing error");
        }
    }
}

