/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalReplicatedMapStatsImpl
implements LocalReplicatedMapStats {
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> LAST_ACCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> LAST_UPDATE_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "lastUpdateTime");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> NUMBER_OF_OTHER_OPERATIONS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> NUMBER_OF_EVENTS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "numberOfEvents");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> NUMBER_OF_REPLICATION_EVENTS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "numberOfReplicationEvents");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> GET_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> PUT_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> REMOVE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_GET_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalGetLatencies");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_PUT_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalPutLatencies");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> TOTAL_REMOVE_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "totalRemoveLatencies");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_GET_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxGetLatency");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_PUT_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxPutLatency");
    private static final AtomicLongFieldUpdater<LocalReplicatedMapStatsImpl> MAX_REMOVE_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalReplicatedMapStatsImpl.class, "maxRemoveLatency");
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;
    private volatile long hits;
    private volatile long numberOfOtherOperations;
    private volatile long numberOfEvents;
    private volatile long numberOfReplicationEvents;
    private volatile long getCount;
    private volatile long putCount;
    private volatile long removeCount;
    private volatile long totalGetLatencies;
    private volatile long totalPutLatencies;
    private volatile long totalRemoveLatencies;
    private volatile long maxGetLatency;
    private volatile long maxPutLatency;
    private volatile long maxRemoveLatency;
    private volatile long creationTime = Clock.currentTimeMillis();
    private volatile long ownedEntryCount;

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return 0L;
    }

    public void setBackupEntryCount(long backupEntryCount) {
    }

    @Override
    public int getBackupCount() {
        return 0;
    }

    public void setBackupCount(int backupCount) {
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return 0L;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return 0L;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        long max = Math.max(this.lastAccessTime, lastAccessTime);
        LAST_ACCESS_TIME_UPDATER.set(this, max);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        long max = Math.max(this.lastUpdateTime, lastUpdateTime);
        LAST_UPDATE_TIME_UPDATER.set(this, max);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        HITS_UPDATER.set(this, hits);
    }

    @Override
    public long getLockedEntryCount() {
        return 0L;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
    }

    @Override
    public long getDirtyEntryCount() {
        return 0L;
    }

    public void setDirtyEntryCount(long dirtyEntryCount) {
    }

    @Override
    public long total() {
        return this.putCount + this.getCount + this.removeCount + this.numberOfOtherOperations;
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    public void incrementPuts(long latency) {
        PUT_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_PUT_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_PUT_LATENCY_UPDATER.set(this, Math.max(this.maxPutLatency, latency));
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    public void incrementGets(long latency) {
        GET_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_GET_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_GET_LATENCY_UPDATER.set(this, Math.max(this.maxGetLatency, latency));
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    public void incrementRemoves(long latency) {
        REMOVE_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_REMOVE_LATENCY_UPDATER.set(this, Math.max(this.maxRemoveLatency, latency));
    }

    @Override
    public long getTotalPutLatency() {
        return this.totalPutLatencies;
    }

    @Override
    public long getTotalGetLatency() {
        return this.totalGetLatencies;
    }

    @Override
    public long getTotalRemoveLatency() {
        return this.totalRemoveLatencies;
    }

    @Override
    public long getMaxPutLatency() {
        return this.maxPutLatency;
    }

    @Override
    public long getMaxGetLatency() {
        return this.maxGetLatency;
    }

    @Override
    public long getMaxRemoveLatency() {
        return this.maxRemoveLatency;
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations;
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getReplicationEventCount() {
        return this.numberOfReplicationEvents;
    }

    public void incrementReceivedReplicationEvents() {
        NUMBER_OF_REPLICATION_EVENTS_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getHeapCost() {
        return 0L;
    }

    public void setHeapCost(long heapCost) {
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        throw new UnsupportedOperationException("Replicated map has no Near Cache!");
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("getCount", this.getCount);
        root.add("putCount", this.putCount);
        root.add("removeCount", this.removeCount);
        root.add("numberOfOtherOperations", this.numberOfOtherOperations);
        root.add("numberOfEvents", this.numberOfEvents);
        root.add("numberOfReplicationEvents", this.numberOfReplicationEvents);
        root.add("lastAccessTime", this.lastAccessTime);
        root.add("lastUpdateTime", this.lastUpdateTime);
        root.add("hits", this.hits);
        root.add("ownedEntryCount", this.ownedEntryCount);
        root.add("creationTime", this.creationTime);
        root.add("totalGetLatencies", this.totalGetLatencies);
        root.add("totalPutLatencies", this.totalPutLatencies);
        root.add("totalRemoveLatencies", this.totalRemoveLatencies);
        root.add("maxGetLatency", this.maxGetLatency);
        root.add("maxPutLatency", this.maxPutLatency);
        root.add("maxRemoveLatency", this.maxRemoveLatency);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.getCount = JsonUtil.getLong(json, "getCount", -1L);
        this.putCount = JsonUtil.getLong(json, "putCount", -1L);
        this.removeCount = JsonUtil.getLong(json, "removeCount", -1L);
        this.numberOfOtherOperations = JsonUtil.getLong(json, "numberOfOtherOperations", -1L);
        this.numberOfEvents = JsonUtil.getLong(json, "numberOfEvents", -1L);
        this.numberOfReplicationEvents = JsonUtil.getLong(json, "numberOfReplicationEvents", -1L);
        this.lastAccessTime = JsonUtil.getLong(json, "lastAccessTime", -1L);
        this.lastUpdateTime = JsonUtil.getLong(json, "lastUpdateTime", -1L);
        this.hits = JsonUtil.getLong(json, "hits", -1L);
        this.ownedEntryCount = JsonUtil.getLong(json, "ownedEntryCount", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.totalGetLatencies = JsonUtil.getLong(json, "totalGetLatencies", -1L);
        this.totalPutLatencies = JsonUtil.getLong(json, "totalPutLatencies", -1L);
        this.totalRemoveLatencies = JsonUtil.getLong(json, "totalRemoveLatencies", -1L);
        this.maxGetLatency = JsonUtil.getLong(json, "maxGetLatency", -1L);
        this.maxPutLatency = JsonUtil.getLong(json, "maxPutLatency", -1L);
        this.maxRemoveLatency = JsonUtil.getLong(json, "maxRemoveLatency", -1L);
    }

    public String toString() {
        return "LocalReplicatedMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", numberOfReplicationEvents=" + this.numberOfReplicationEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + this.totalGetLatencies + ", totalPutLatencies=" + this.totalPutLatencies + ", totalRemoveLatencies=" + this.totalRemoveLatencies + ", ownedEntryCount=" + this.ownedEntryCount + ", creationTime=" + this.creationTime + '}';
    }
}

